/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: depend.c,v 3.5 2002/01/21 18:11:12 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<unistd.h>
#include	<string.h>
#include	<sys/types.h>
#include	<sys/stat.h>
#include	<fcntl.h>
#include	<sys/mman.h>

#include	"murasaki.h"
#include	"env.h"

#define	DEPEND_PATH		MU_CONF_DIR "/" MU_DEPEND_FILE
#define	CALL_PATH		MU_CONF_DIR "/" MU_CALL_FILE

#define	CHAR_RSEP		'\n'
#define	CHAR_DEP		':'

char *module_list[LIST_MAX];
char *script_list[LIST_MAX];
char *class_list[LIST_MAX];

enum string_status {ST_START, ST_END };

/*
 * ptr: point to next for ':'
 */
static char *
append_module_list(char **list,char *ptr,char *endp,int max_arg)
{
	char *module,*mod_start;
	int mod_len;
	enum string_status status = ST_END;

	for(;ptr <= endp;ptr++) {
		if (status == ST_END) {
			if (*ptr == ' ' || *ptr == '\t') /* skip */
				continue;
			if (*ptr == CHAR_RSEP)	/* invalid line end */
				return NULL;
			status = ST_START;
			mod_start = ptr;
		} else {	/* status == ST_START */
			if (*ptr != ' ' && *ptr != '\t' && *ptr != CHAR_RSEP)
				continue;
			mod_len = ptr - mod_start;
			module = malloc(mod_len+1);
			if (module == NULL)
				return NULL;
			memcpy(module,mod_start,mod_len);
			module[mod_len] = '\0';
			syslog(LOG_LEVEL,"found depended module=\"%s\"",module);
			if (add_to_list(list,module,max_arg) == INVALID)
				return NULL;
			if (*ptr == CHAR_RSEP)	/* all modules be appended */
				break;
			status = ST_END;	/* -> next modules */
		}
	}
	return ptr;
}

/* 
 * expand_list: destination list for 'list'
 * list: source list should be expanded
 */

static int
get_helper(char *fname,char **expand_list,char **list,int start_arg,int max_arg)
{
	struct stat st;
	int fd,base_len;
	char *mp,*endp,*ptr;
	int index;

	if ((fd = open(fname,O_RDONLY)) == -1)
		return INVALID;
	if (fstat(fd,&st) == -1)
		return INVALID;
	if ((mp = mmap(0,st.st_size,PROT_READ,MAP_SHARED,fd,0)) == MAP_FAILED)
		return INVALID;
	close(fd);
	endp = mp+st.st_size;

	DPRINTF(LOG_LEVEL,"==================== File name %s",fname);
	/* try to match an argument for 'modprobe' */
	for(index = start_arg;list[index] != NULL;index++) {
		DPRINTF(LOG_LEVEL,"try expanding \"%s\"",list[index]);
		base_len = strlen(list[index]);
		for(ptr = mp;ptr < endp;ptr++) {
			/* module is matched */
			if ((ptr[base_len] == CHAR_DEP) &&
				(ptr + base_len < endp) &&
				(memcmp(ptr,list[index],base_len) == 0)) {
				/* base_len + 1 -> point to next character for ':' */
				ptr = append_module_list(expand_list,ptr+base_len+1,endp,max_arg);
				if (ptr == NULL) {
					syslog(LOG_LEVEL,"%s is invalid",fname);
					return INVALID;
				}
			} else {	/* skip an unmatched line */
				while(ptr < endp) {
					if (*ptr == CHAR_RSEP)
						break;
					ptr++;
				}
			}
		}
	}	/* list loop */

	munmap(mp,st.st_size);

	return GOOD;
}

/*
 * already created [0]:loader [1]:loader option [2]:module
 * now creat [3]:dep-mod ...
 */
int
get_depend(char **list)
{
	return get_helper(DEPEND_PATH,list,list,START_ARG,LIST_MAX);
}

/*
 * create [0]:...    script-file
 */
int
get_script(char **expand_list,char **list)
{
	return get_helper(CALL_PATH,expand_list,list,START_ARG,LIST_MAX);
}
