/*
 *  Copyright (c) by Shuu Yamaguchi <shuu@dotaster.com>
 *
 *  $Id: hotplug.c,v 3.8 2002/01/21 17:41:36 shuu Exp shuu $
 *
 *  Can be freely distributed and used under the terms of the GNU GPL.
 */
#include	<stdio.h>
#include	<stdlib.h>
#include	<string.h>
#include	<syslog.h>
#include	<unistd.h>

#include	"murasaki.h"

#define	EXEC_PATH		MU_CONF_DIR ":" MU_BIN_DIR ":"
#define	HOTPLUG_MAX_ARGS	3

#define	LOG_LEVEL	LOG_CONS

#ifdef	DEBUG
#define	DPRINTF( args... )		syslog(args)
#define	DPRINT_ARGS(name,arg)	print_args((name),(arg))
#else
#define	DPRINTF( args... )
#define	DPRINT_ARGS(name,arg)
#endif

struct arg_command {
	char *arg;
	char *cmd;
};

struct arg_command cmd_table[] = {
	{MU_ARG_USB,	MU_MURASAKI "." MU_ARG_USB},
	{MU_ARG_PCI,	MU_MURASAKI "." MU_ARG_PCI},
	{MU_ARG_NET,	MU_MURASAKI "." MU_ARG_NET},
	{MU_ARG_IEEE1394,	MU_MURASAKI "." MU_ARG_IEEE1394},
	{NULL,NULL}
};

static int
add_path(char **env)
{
	char *newpath;
	int i;

	for(i = 0;env[i] != NULL;i++) {
		if (strncmp("PATH=",env[i],sizeof("PATH=")-1) == 0)
			break;
	}
	/* 
	 * need to reallocate env if env[i] == NULL
	 * but, I think it should be error.
	 */ 
	if (env[i] == NULL)
		return -1;
	newpath = malloc(sizeof("PATH=") - 1 + sizeof(EXEC_PATH) - 1 + strlen(env[i]) + 1);
	if (newpath == NULL)
		return -1;
	strcpy(newpath,"PATH=");
	strcpy(newpath+sizeof("PATH=")-1,EXEC_PATH);
	strcpy(newpath+sizeof("PATH=")-1+sizeof(EXEC_PATH)-1,env[i]+sizeof("PATH=")-1);
	DPRINTF(LOG_LEVEL,"path = \"%s\"",newpath);
	env[i] = newpath;

	return 0;
}

#ifdef	DEBUG
static void
print_args(char *name,char **av)
{
	int i;

	for(i = 0;av[i] != NULL;i++)
		syslog(LOG_LEVEL,"%s[%d] = \"%s\"\n",name,i,av[i]);

}
#endif

static void
usage(void)
{
	printf("Usage: hotplug usb|pci|net|ieee1394\n");
	exit(1);
}

int
main(int argc,char **argv,char **env)
{
	char *cmd[HOTPLUG_MAX_ARGS];
	int idx;

	if (argc == 1) {
		usage();
	}
	openlog("hotplug",LOG_PID|LOG_CONS,LOG_DAEMON);
	
	if (add_path(env) == -1) {
		exit(1);
	}
	DPRINT_ARGS("argv",argv);

	cmd[1] = NULL;
	for (idx = 0;cmd_table[idx].arg != NULL;idx++) {
		if (strcmp(argv[1],cmd_table[idx].arg) == 0) {
			cmd[0] = cmd_table[idx].cmd;
#ifdef	DEBUG
			switch(idx) {
			case 0:	/* USB */
				DPRINTF(LOG_LEVEL,"%s ACTION=%s PRODUCT=%s TYPE=%s INTERFACE=%s DEVFS=%s DEVICE=%s",
					argv[1],getenv("ACTION"),getenv("PRODUCT"),
					getenv("TYPE"),getenv("INTERFACE"),getenv("DEVFS"),
					getenv("DEVICE"));
					break;
			case 1:	/* PCI */
				DPRINTF(LOG_LEVEL,"%s ACTION=%s PCI_CLASS=%s PCI_ID=%s PCI_SUBSYS_ID=%s PCI_SLOT_NAME=%s",
					argv[1],getenv("ACTION"),getenv("PCI_CLASS"),
					getenv("PCI_ID"),getenv("PCI_SUBSYS_ID"),
					getenv("PCI_SLOT_NAME"));
					break;
			case 2:	/* NET */
				DPRINTF(LOG_LEVEL,"%s ACTION=%s INTERFACE=%s",
					argv[1],getenv("ACTION"),getenv("INTERFACE"));
					break;
			case 3:	/* IEEE1394 */
				DPRINTF(LOG_LEVEL,"%s ACTION=%s VENDOR_ID=%s GUID=%s SPECIFIER_ID=%s VERSION=%s",
					argv[1],getenv("ACTION"),getenv("VENDOR_ID"),
					getenv("GUID"),getenv("SPECIFIER_ID"),getenv("VERSION"));
			}
#endif
			break;
		}
	}
	if (cmd_table[idx].arg == NULL) {
		syslog(LOG_LEVEL,"unknown argument");
#ifdef	DEBUG
		print_args("argv",argv);
		print_args("env",env);
#endif
		exit(1);
	}
	closelog();
	DPRINT_ARGS("cmd",cmd);
	execvp(cmd[0],cmd);

	/* not reached */
	return 0;
}
