<html>
<head>
<title>Userlist</title>
</head>
<body>
<?php

#
# Murmur.php is generated by calling
# slice2php /path/to/Murmur.ice
# in this directory
#

if (Ice_intversion() >= 30400) {
  if (!stream_resolve_include_path('Ice.php')) {
		exit('The required file Ice.php could not be found in the PHP include path(s).');
  }
  if (!stream_resolve_include_path('Murmur.php')) {
		exit('The required file Murmur.php could not be found in the PHP include path(s).');
  }
  require 'Ice.php';
  require 'Murmur.php';
} else {
  Ice_loadProfile();
}

try {
  if (Ice_intversion() >= 30400) {
    $ICE = Ice_initialize();
  }

  $base = $ICE->stringToProxy("Meta:tcp -h 127.0.0.1 -p 6502");
  $meta = $base->ice_checkedCast("::Murmur::Meta");

  $servers = $meta->getBootedServers();
  $default = $meta->getDefaultConf();
  foreach($servers as $s) {
    $name = $s->getConf("registername");
    if (! $name) {
      $name =  $default["registername"];
    }
    echo "<h1>SERVER #" . $s->id() . " " .$name ."</h1>\n";
    echo "<table><tr><th>Name</th><th>Channel</th></tr>\n";

    $channels = $s->getChannels();
    $players = $s->getUsers();

    foreach($players as $id => $state) {
      $chan = $channels[$state->channel];
      echo "<tr><td>".$state->name."</td><td>".$chan->name."</td></tr>\n";
    }
    echo "</table>\n";
  }
} catch (Ice_LocalException $ex) {
  print_r($ex);
}

?>
</body>
</html>
