/* 
   MultiSync Opie Plugin - Synchronize Opie/Zaurus Devices
   Copyright (C) 2003 Tom Foottit <tom@foottit.com>

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License version 2 as
   published by the Free Software Foundation;

   THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS
   OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
   FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF THIRD PARTY RIGHTS.
   IN NO EVENT SHALL THE COPYRIGHT HOLDER(S) AND AUTHOR(S) BE LIABLE FOR ANY
   CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES, OR ANY DAMAGES 
   WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN 
   ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF 
   OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.

   ALL LIABILITY, INCLUDING LIABILITY FOR INFRINGEMENT OF ANY PATENTS, 
   COPYRIGHTS, TRADEMARKS OR OTHER RIGHTS, RELATING TO USE OF THIS 
   SOFTWARE IS DISCLAIMED.
*/

/*
 *  $Id: gui.c,v 1.3 2003/09/22 18:19:41 irix Exp $
 */

#include <glib.h>
#include <gmodule.h>
#include <gtk/gtkmain.h>
#include <gtk/gtksignal.h>

#include <multisync.h>

#include "gui.h"
#include "interface.h"
#include "support.h"
#include "opie_comms.h"
#include "opie_config.h"

GtkWidget* opie_config = NULL;
opie_conn* conn = NULL;

#define OPIE_SYNC_MIN_PORT (1)
#define OPIE_SYNC_MAX_PORT (65536)

void opie_ui_error(gchar* message);

/*
 * opie_window_closed
 */
void opie_window_closed(void) 
{
  if(conn)
  {
    if(conn->device_addr)
      g_free(conn->device_addr);
    if(conn->username)
      g_free(conn->username);
    if(conn->password)
      g_free(conn->password);
    g_free(conn);
    conn = NULL;
  }
  
  sync_plugin_window_closed();
  opie_config = NULL;
}


/*
 * opie_cancel
 */
void opie_cancel(void) 
{
  gtk_widget_destroy(opie_config);
  opie_window_closed();
}


/*
 * opie_ok
 */
void opie_ok(void) 
{
  GtkWidget *active_protocol, *active_device, *option_menu, *menu;

  /* setup conn with the values they set */
  conn->device_addr = 
    g_strdup(gtk_entry_get_text(GTK_ENTRY(lookup_widget(opie_config, "device_ip_entry"))));
  conn->username = 
    g_strdup(gtk_entry_get_text(GTK_ENTRY(lookup_widget(opie_config, "username_entry"))));
  conn->password = 
    g_strdup(gtk_entry_get_text(GTK_ENTRY(lookup_widget(opie_config, "password_entry"))));
  conn->device_port = 
    atoi(gtk_entry_get_text(GTK_ENTRY(lookup_widget(opie_config, "port_entry"))));  
  conn->enable_qcop = 
    gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(lookup_widget(opie_config, "enable_qcop")));  
  
  /* validate the port */
  if((conn->device_port < OPIE_SYNC_MIN_PORT) ||
     (conn->device_port > OPIE_SYNC_MAX_PORT))
  {
    gchar* errbuf = g_strdup_printf("Invalid port supplied. Must be between %d and %d",
                                    OPIE_SYNC_MIN_PORT, OPIE_SYNC_MAX_PORT);
    
    opie_ui_error(errbuf);
    return; 
  } 
  
  active_protocol = 
      gtk_menu_get_active(GTK_MENU(gtk_option_menu_get_menu(GTK_OPTION_MENU(lookup_widget(opie_config, "protocol_entry")))));
  
  option_menu = lookup_widget(opie_config, "protocol_entry");
  menu = GTK_OPTION_MENU(option_menu)->menu;
  
  if(1 == g_list_index(GTK_MENU_SHELL (menu)->children, active_protocol))
  {
    conn->conn_type = SCP_CONN;
  }
  else
  {
    conn->conn_type = FTP_CONN;
  }
  
  active_device = 
      gtk_menu_get_active(GTK_MENU(gtk_option_menu_get_menu(GTK_OPTION_MENU(lookup_widget(opie_config, "device_type_entry")))));
  option_menu = lookup_widget(opie_config, "device_type_entry");
  menu = GTK_OPTION_MENU(option_menu)->menu;
  
  if(1 == g_list_index(GTK_MENU_SHELL (menu)->children, active_device))
  {
    conn->device_type = DEVICE_ZAURUS;
  }
  else
  {
    conn->device_type = DEVICE_OPIE_OPENZAURUS;
  }
  
  
  if(!opie_save_config(conn))
  {
    opie_ui_error("Unable to save configuration.");
  }
  
  gtk_widget_destroy(opie_config);
  opie_window_closed();
}


/*
 * open_option_window
 */
GtkWidget* open_option_window(sync_pair *pair, connection_type type)
{
  char* port_str;

  if(!opie_config)
  {
    opie_config = create_opie_config();  
    
    conn = g_malloc0(sizeof(opie_conn));
    g_assert(conn);
    conn->sync_pair = pair;
    
    /* load the existing config into the window */
    if(opie_load_config(conn))
    {
      /* set the values in the window accordingly */
      gtk_entry_set_text(GTK_ENTRY(lookup_widget(opie_config, "device_ip_entry")), 
                         conn->device_addr);
      gtk_entry_set_text(GTK_ENTRY(lookup_widget(opie_config, "username_entry")), 
                         conn->username);
      gtk_entry_set_text(GTK_ENTRY(lookup_widget(opie_config, "password_entry")), 
                         conn->password);
      port_str = g_strdup_printf("%u", conn->device_port);
      gtk_entry_set_text(GTK_ENTRY(lookup_widget(opie_config, "port_entry")), 
                         port_str);
      g_free(port_str);                   
      
      switch (conn->conn_type)
      {
        case FTP_CONN:
          gtk_option_menu_set_history(GTK_OPTION_MENU(lookup_widget(opie_config, "protocol_entry")), 0);
          break;
        case SCP_CONN:
          gtk_option_menu_set_history(GTK_OPTION_MENU(lookup_widget(opie_config, "protocol_entry")), 1);
          break;
        default:
          break;  
      }
      
      switch(conn->device_type)
      {
        case DEVICE_OPIE_OPENZAURUS:
          gtk_option_menu_set_history(GTK_OPTION_MENU(lookup_widget(opie_config, "device_type_entry")), 0);
          break;
        case DEVICE_ZAURUS:
          gtk_option_menu_set_history(GTK_OPTION_MENU(lookup_widget(opie_config, "device_type_entry")), 1);
          break;
        default:
          break;           
      }
      
      gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(lookup_widget(opie_config, "enable_qcop")), conn->enable_qcop);  
      
    }
    else
    {
      /* could not load config file */
      opie_ui_error("Unable to load configuration.");
    }
    
    gtk_widget_show(opie_config); 
  }
  
  return opie_config;
}



/*
 * opie_ui_error
 */
void opie_ui_error(gchar* message)
{
  /* provide message in a dialog to the  user with an "ok" button */
  GtkWidget *dialog, *label;

  /* create the widgets */
  dialog = gtk_dialog_new_with_buttons ("Error",
                                        GTK_WINDOW(opie_config),
                                        GTK_DIALOG_MODAL | GTK_DIALOG_DESTROY_WITH_PARENT,
                                        GTK_STOCK_OK,
                                        GTK_RESPONSE_NONE,
                                        NULL);
  
  gtk_dialog_set_has_separator(GTK_DIALOG(dialog), FALSE);
  
  label = gtk_label_new (message);

  /* Ensure that the dialog box is destroyed when the user responds. */
  g_signal_connect_swapped (GTK_OBJECT (dialog), 
                            "response", 
                            G_CALLBACK (gtk_widget_destroy),
                            GTK_OBJECT (dialog));

  /* Add the label, and show everything we've added to the dialog. */
  gtk_container_add (GTK_CONTAINER (GTK_DIALOG(dialog)->vbox), label);
  
  gtk_widget_show_all (dialog);  
  
}
