# Note that this is NOT a relocatable package
%define ver      	1.6.2
%define RELEASE		1
%define rel      	%{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define localstatedir   /var/lib
%define _prefix         /usr/local

Summary:         The Enhanced GNOME Terminal.
Name: 	         multi-gnome-terminal	 
Version: 	 %ver
Release: 	 %rel
Copyright: 	 GPL
Group: 		 Applications/Emulators 
Source:          http://multignometerm.sourceforge.net/multi-gnome-terminal-%{ver}.tar.gz
BuildRoot: 	 /var/tmp/%{name}-%{version}-root
URL: 		  http://multignometerm.sourceforge.net
Prefix:          %{_prefix} 
#Prereq: 	 /sbin/install-info
#Requires:        gtk+ >= 1.2.5, gdk-pixbuf >= 0.7.0
#Requires:        libglade >= 0.14, libxml
#Requires:        gnome-libs >= 1.0.59
#Requires:        ORBit >= 0.5.0
#BuildRequires:   gtk+-devel >= 1.2.5, libxml-devel
#BuildRequires:   gdk-pixbuf-devel >= 0.7.0
#BuildRequires:   libglade-devel >= 0.14
#BuildRequires:   scrollkeeper >= 0.1.4
#BuildRequires:   gnome-libs-devel >= 1.0.59
#BuildRequires:   ORBit-devel >= 0.5.0


%description
Multi Gnome Terminal is an enhanced  version of gnome-terminal which has
the following features added:
- Multiple terminals in each window
- Switch between terminals using shortcuts
- Execution of user defined commands in new terminals (Customizable menus)
- Notification of terminals states using customizable colors for tabs text.
- Split terminal windows horizontally or vertically
- User definable keybindings for MGT functions and other uses
- Various other enhancements
 
These extensions are inspired by screen and konsole (the KDE2 terminal)
and should be useful to all users.

%prep
%setup -q

%build
./configure --prefix=%{_prefix} \
    --bindir=%{_bindir} --mandir=%{_mandir} \
    --localstatedir=%{localstatedir} --libdir=%{_libdir} \
    --datadir=%{_datadir} --includedir=%{_includedir} \
    --sysconfdir=%{_sysconfdir}

CFLAGS="$RPM_OPT_FLAGS" make


%install
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

make prefix=$RPM_BUILD_ROOT%{_prefix} bindir=$RPM_BUILD_ROOT%{_bindir} \
    mandir=$RPM_BUILD_ROOT%{_mandir} libdir=$RPM_BUILD_ROOT%{_libdir} \
    localstatedir=$RPM_BUILD_ROOT%{localstatedir} \
    datadir=$RPM_BUILD_ROOT%{_datadir} \
    includedir=$RPM_BUILD_ROOT%{_includedir} \
    sysconfdir=$RPM_BUILD_ROOT%{_sysconfdir} install

 
%clean
[ -n "$RPM_BUILD_ROOT" -a "$RPM_BUILD_ROOT" != / ] && rm -rf $RPM_BUILD_ROOT

%post
/sbin/ldconfig
if which scrollkeeper-update>/dev/null 2>&1; then scrollkeeper-update; fi
chown root.tty %{_sbindir}/mgt-pty-helper
chmod g+s %{_sbindir}/mgt-pty-helper

%postun
/sbin/ldconfig
if which scrollkeeper-update>/dev/null 2>&1; then scrollkeeper-update; fi

%files
%doc AUTHORS COPYING ChangeLog NEWS README
%defattr (-, root, root)
%{_bindir}/*
%attr(6755,root,tty) %{_sbindir}/mgt-pty-helper
%{_datadir}/mgt/*
%{_sysconfdir}/*
%{_mandir}/*/*
%{_datadir}/pixmaps/*
%{_datadir}/gnome/apps/System/*
%{_datadir}/gnome/help/multi-gnome-terminal/*
%changelog
* Mon Jun 24 2002 Hal Burgiss <hal@foobox.net>
- Add multi-gnome-terminal.desktop.
* Thu Nov 01 2001 De Michele Cristiano <demichel@na.infn.it>
- Built 1.3.4 Release which fixes keybindings bug and adds some minor enhancements
* Thu Oct 11 2001 De Michele Cristiano <demichel@na.infn.it>
- Built 1.3.0 Release	
* Sun Oct 01 2001 De Michele Cristiano <demichel@na.infn.it>
- Built 1.2.4 Release
