#define NO
#include <config.h>
#include <unistd.h>
#include <string.h>
#include <sys/types.h>
#include <sys/wait.h>
#include <fcntl.h>
#include <errno.h>
#include <signal.h>
#if defined(HAVE_KVM_H) /* SUNOS */
#include <kvm.h>
#elif defined(HAVE_PROCINFO_H) /* AIX */
#include <procinfo.h>  
#endif
#include <gdk/gdk.h>
#include <gdk/gdkx.h>
#include <gdk/gdkprivate.h>
#include "mgtnotebook.h"
#include <gnome.h>
/*#include <zvt/zvtterm.h>*/
#include "zvtterm.h"
#include <orb/orbit.h>
#include <libgnorba/gnorba.h>
#include <libgnomeui/gnome-window-icon.h>
#include <glade/glade.h>

#include <X11/Xatom.h>

#include "gnome-terminal.h"

#define  GT_DIR_TREE
/*#define MGT_DEBUG*/
#define COPY_CMD

#define DEFAULT_BUTTONBAR_ITEMS 20
#define DEFAULT_POPUPCMDS_ITEMS 19 
#define IRES(x) gtk_container_set_resize_mode(GTK_CONTAINER(x), GTK_RESIZE_IMMEDIATE)
#define QRES(x) gtk_container_set_resize_mode(GTK_CONTAINER(x), GTK_RESIZE_QUEUE)

#define XZVT_TERM(obj)          GTK_CHECK_CAST (obj, xzvt_term_get_type (), xZvtTerm)
#define XZVT_TERM_CLASS(klass)  GTK_CHECK_CLASS_CAST (klass, xzvt_term_get_type (), xZvtTermClass)
#define XZVT_IS_TERM(obj)       GTK_CHECK_TYPE (obj, xzvt_term_get_type ())

#define DEFAULT_FONT "-misc-fixed-medium-r-normal--12-200-75-75-c-100-iso8859-1"
#define EXTRA 6
#define NUM_HARDSET 6 

/* Insert an item with an inline xpm icon */
#define GNOMEUIINFO_ITEM_FILE(label, tooltip, callback, icon_file) \
        { GNOME_APP_UI_ITEM, label, tooltip, (gpointer)callback, NULL, NULL, \
                GNOME_APP_PIXMAP_FILENAME, icon_file, 0, (GdkModifierType) 0, NULL}

enum scrollbar_position_enum {
	SCROLLBAR_LEFT   = 0,
	SCROLLBAR_RIGHT  = 1,
	SCROLLBAR_HIDDEN = 2
};

enum targets_enum {
        TARGET_STRING,
	TARGET_COLOR,
	TARGET_BGIMAGE
};

enum new_term_types 
{
  MGT_HORIZ_SPLIT,
  MGT_VERT_SPLIT,
  MGT_NEW_WIN,
  MGT_NEW_TAB,
  MGT_TPREV,
  MGT_TNEXT,
  MGT_NEW_WINWT
};

/* nautilus uses this UTTER HACK to reset backgrounds, ugly ugly ugly,
 * broken, ugly ugly, but whatever */
#define RESET_IMAGE_NAME "/nautilus/backgrounds/reset.png"

/* The color set */
enum color_set_enum {
	COLORS_WHITE_ON_BLACK,
	COLORS_BLACK_ON_WHITE,
	COLORS_GREEN_ON_BLACK,
	COLORS_BLACK_ON_LIGHT_YELLOW,
	COLORS_CUSTOM
};

enum palette_enum {
	PALETTE_LINUX,
	PALETTE_XTERM,
	PALETTE_RXVT,
	PALETTE_CUSTOM
};

typedef struct {
 gchar* class;
 GtkWidget *class_box;
 GtkWidget *prop_win;
 GtkWidget *login_checkbox;
 GtkWidget *menubar_checkbox;
 /* ADDED 2 FIELDS */
 GtkWidget *win_title;
 GtkWidget *toolbar_checkbox;
 GtkWidget *buttonbar_checkbox; 	
 GtkWidget *chk_restorecmds;
 GtkWidget *chk_reopentabs; 
 GtkWidget *autosavetabs;
 GtkWidget *chk_restorepaths;
 GtkWidget *chk_restoreclasses;
 GtkWidget *close_dialog_checkbox; 
 GtkWidget *no_numprefix; 
 GtkWidget *tab_position;
 GtkWidget *no_nbborder;
 GtkWidget *lbl_termchgd;
 GtkWidget *lbl_termchgn;	
 GtkWidget *maxch;
 GtkWidget *lbl_maxch;
 GtkWidget *titled_tabs;	
 GtkWidget *but_default; 
 GtkWidget *palette[2];
 int changed;
} winprefs_t;

struct app_config_t {
  gint hardset_entries[NUM_HARDSET+1];
  char **cmds; 
  char **cmds_names;
  char **cmds_paths;
  char **cmds_classes;
  char **actions;
  char **keybinds;
  char **strings;
  GSList *kbinds_list;
  int kbinds_reload;
  int popupmod;
  int disable_keybind;
}; 
typedef struct {
  gchar* class;
  GtkWidget *prop_win;
  GtkWidget *blink_checkbox;
  GtkWidget *scroll_kbd_checkbox;
  GtkWidget *scroll_out_checkbox;
  GtkWidget *swapkeys_checkbox;
#ifdef HAVE_ZVT_DEL_IS_DEL
  GtkWidget *del_is_del_checkbox;
#endif
  GtkWidget *use_bold_checkbox;
  GtkWidget *use_boldfont;
  GtkWidget *bold_color_checkbox;
  GtkWidget *use_im_checkbox;
  GtkWidget *use_fontset_checkbox;
  GtkWidget *wordclass_entry;
  GtkWidget *back_none;
  GtkWidget *utmp_checkbox;
  GtkWidget *wtmp_checkbox;
  GtkWidget *lastlog_checkbox;
  GtkWidget *pixmap_checkbox;
  GtkWidget *pixmap_file_entry;
  GtkWidget *pixmap_label;
  GtkWidget *pixmap_entry;
  GtkWidget *transparent_checkbox;
  GtkWidget *shaded_checkbox;
#ifdef ZVT_BACKGROUND_SCROLL
  GtkWidget *pixmap_scrollable_checkbox;
#endif
  GtkWidget *no_border;
  GtkWidget *font_shadow;
  GtkWidget *perclbl;
  /* ================= */
#ifdef SHADING
  GtkWidget* shaded_hscale;
  GtkWidget* tinted_checkbox;
  GtkWidget* contrast_checkbox;
  GtkWidget* contrast_hscale;
  GtkWidget* gamma_checkbox;
  GtkWidget* gamma_hscale;
  GtkWidget* tinted_colorpicker; 
  GtkWidget* om_imgmode;
#endif  
  GtkWidget *bell_checkbox;
  GtkWidget *font_entry;
  GtkWidget *picker; 
  GtkWidget *boldpicker;
  GtkWidget *boldfont_entry;
  GtkWidget *boldfont_label;
  GtkWidget *color_scheme;
  GtkWidget *def_fore_back;
  GtkWidget *scrollbar;
  GtkWidget *scrollback_spin;
  GtkWidget *class_box;
  GtkWidget *fore_label;
  GtkWidget *back_label;
  GtkWidget *palette_label;

  GtkWidget *lbl_boldcolor;
  GtkWidget *lbl_shadow;
  /* MODIFIED 18->20->21 */
  GtkWidget *palette[20];
  int changed;
} preferences_t;

struct win_config
{
  char *class;
  int disable_keybind  :1;
  int login_shell      :1;                /* do --login for hardset shells */
  int restore_tabs     :1;
  int restorepaths     :1;
  int restore_commands :1;
  int restore_classes  :1;
  int autosavetabs     :1;
  int no_nbborder      :1;
  int no_numprefix     :1;
  int titled_tabs      :1;
  int no_startuptabs   :1; 
  int menubar_hidden; 			/* Whether to show the menubar */
  /* ADDED 2 FIELDS */
  int toolbar_hidden;
  int buttonbar_hidden;
  int tab_hidden;
  GtkPositionType tab_position;
  int close_confirm;
  int maxch;
  char *window_title;                     /* the window title */
  char *window_icon;                      /* the window icon */
  int window_id;			/* terminal id for this terminal */
  GdkColor palette[2];			/* the full palette */
};
struct terminal_config {
  int keyboard_secured :1;		/* Does this terminal have the keyboard secured? */
  int tintback: 1;
  int adj_contrast: 1;
  int gamma_correction: 1;
  int bell             :1;                /* Do we want the bell? */
  int blink            :1; 		/* Do we want blinking cursor? */
  int scroll_key       :1;       		/* Scroll on input? */
  int scroll_out       :1;       		/* Scroll on output? */
  int swap_keys        :1;       		/* Swap Delete/Backspace? */
  int no_border        :1;
  int font_shadow      :1;
  int use_im           :1;                /* Open XInput Method */         
  int use_fontset      :1;                /* Use gdk_fontset_load */
  int bold_color       :1;
#ifdef ZVT_BACKGROUND_SCROLL
  int scroll_background:1; 		/* background will scroll */
#endif
  int use_bold         :1;		/* Use bold on bright colours */
  int use_boldfont     :1;
#ifdef HAVE_ZVT_DEL_IS_DEL
  int del_is_del       :1; 		/* Generates Delete DEL/^H? */
#endif
  enum palette_enum color_type; 			/* The color mode */
  enum color_set_enum color_set;
  char *font; 				/* Font used by the terminals */
  char *boldfont;                        /* font used by terminals for 
					    for bold text */
  int scrollback; 			/* Number of scrollbacklines */
  char *class;
  enum scrollbar_position_enum scrollbar_position;
  int update_records;
  int update_records_and, update_records_xor;
  const char *user_back_str, *user_fore_str;
  /* ============== */
  int transparent;
  int have_user_background;		/* Only used for command line parsing */
#ifdef ZVT_BACKGROUND_SCROLL
  int have_user_scroll_bg; 		/* Only used for command line parsing */
#endif
  int shaded;
#ifdef SHADING
  int shading;
  int contrast;
  int gamma;
  int rtint;
  int gtint;
  int btint;
  int image_mode;
#endif
  int have_user_shaded;			/* Only used for command line parsing */
  int background_pixmap;
  char *pixmap_file;
  char *wordclass;			/* select-by-word character class */
  char *termname;			/* TERM variable setting, store as TERM=xxx */
  /* MODIFIED 18->20->21 */
  GdkColor palette[20];			/* the full palette */
};


struct search_data_struct
{
  GSList** ptl;
  GtkWidget* wrap_around;
  GtkWidget* back;
  GtkWidget* case_sensitive;
  GtkWidget* text;
  int start_line;
  int start_x;
};

struct stored_sdata 
{
  gboolean back;
  gboolean case_sensitive;
  gboolean wrap_around;
  char* text;
  int start_line;
  int start_x;
};

enum term_state { 
  CHANGING,
  CHANGED,
  UNCHANGED,
  VISIBLE,
  UNDEFINED
};

enum act_list_types  
{
  MGT_SHELL_NEWTAB, MGT_SHELL_HSPLIT, MGT_SHELL_VSPLIT, MGT_SHELL_NEWWINDOW,
  MGT_ROOT_NEWTAB, MGT_ROOT_HSPLIT, MGT_ROOT_VSPLIT, MGT_ROOT_NEWWINDOW,
  MGT_MC_NEWTAB, MGT_MC_HSPLIT, MGT_MC_VSPLIT, MGT_MC_NEWWINDOW,
  MGT_SWITCH_TO, MGT_GO_RIGHT, MGT_GO_LEFT, MGT_REMOVE_TERM, MGT_TAB_RIGHT, MGT_TAB_LEFT,
  MGT_CHANGE_TITLE, MGT_SEARCH, MGT_SEARCH_AGAIN, MGT_RESET_TERMINAL, MGT_RESET_AND_CLEAR,
  MGT_NEW_WINDOW, MGT_COMMAND_NEWTAB, MGT_COMMAND_HSPLIT, MGT_COMMAND_VSPLIT,
  MGT_COMMAND_NEWWINDOW, MGT_NEWTAB_WITH, MGT_HSPLIT_WITH, MGT_VSPLIT_WITH,
  MGT_HVIEW_OF, MGT_VVIEW_OF, MGT_ALL_BONDED, MGT_ALL_UNBONDED, MGT_SAVE_TERMINALS,
  MGT_NEXT_TERM_IN_TAB, MGT_PREV_TERM_IN_TAB, MGT_ESCAPE_SEQUENCE, MGT_ADJUST_SIZE,
  MGT_CMDMENU, MGT_RCMENU, MGT_SMOFF, MGT_HELP
};

/* WARNING: there should be a correspondence between act_list_types and
   actions_list */


#define GTK_TYPE_MYCTREE            (gtk_myctree_get_type ())
#define GTK_MYCTREE(obj)            (GTK_CHECK_CAST ((obj), GTK_TYPE_MYCTREE, GtkMyCTree))
#define GTK_MYCTREE_CLASS(klass)    (GTK_CHECK_CLASS_CAST ((klass), GTK_TYPE_MYCTREE, GtkMyCTreeClass))
#define GTK_IS_MYCTREE(obj)         (GTK_CHECK_TYPE ((obj), GTK_TYPE_MYCTREE))
#define GTK_IS_MYCTREE_CLASS(klass) (GTK_CHECK_CLASS_TYPE ((klass), GTK_TYPE_MYCTREE))
#define PM_SIZE                    8
#define TAB_SIZE                   (PM_SIZE + 6)
#define CELL_SPACING               1
#define CLIST_OPTIMUM_SIZE         64
#define COLUMN_INSET               3
#define DRAG_WIDTH                 6
#define ROW_TOP_YPIXEL(clist, row) (((clist)->row_height * (row)) + \
                                    (((row) + 1) * CELL_SPACING) + \
                                    (clist)->voffset)
#define ROW_FROM_YPIXEL(clist, y)  (((y) - (clist)->voffset) / \
                                    ((clist)->row_height + CELL_SPACING))
#define COLUMN_LEFT_XPIXEL(clist, col)  ((clist)->column[(col)].area.x \
                                    + (clist)->hoffset)


/*
 * These are the indices for the toggle items in the file menu. If
 * you change the file menus, these macros MUST be updated to reflect
 * the changes.
 */
#define FILE_MENU_TOGGLE_INDEX_MENUBAR 8 
#define FILE_MENU_TOGGLE_INDEX_TOOLBAR 9
#define FILE_MENU_TOGGLE_INDEX_BUTTONBAR 10
