/* $Id: channels.c,v 1.5 2000/03/18 12:55:41 zap Exp $
 * -------------------------------------------------------
 * Copyright (c) 1998-2000 Sebastian Kienzl <zap@riot.org>
 * -------------------------------------------------------
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include "muh.h"
#include "channels.h"
#include "table.h"

channellist_type channels;

void add_channel( char *s )
{
    int i, index;
    for( i = 0; i < channels.amount; i++ )
        if( channels.data[ i ] && strcmp( channels.data[ i ], s ) == 0 ) return;
    /* ay? channel is already in list! */
    
    channels.data = ( char ** )add_item( ( void ** )channels.data, strlen( s ) + 1, &channels.amount, &index );
    strcpy( channels.data[ index ], s );
}

void rem_channel( char *s )
{
    int i;
    for( i = 0; i < channels.amount; i++ )
        if( channels.data[ i ] && strcmp( channels.data[ i ], s ) == 0 )
            channels.data = ( char ** )rem_item( ( void ** )channels.data, i, &channels.amount );
}

void drop_channels()
{
    channels.data = ( char ** )free_table( ( void ** )channels.data, &channels.amount );
}

char * list_channels()
{
    int i;
    char *temp;

    if( !channels.amount ) return NULL;
    temp = malloc( 1 );
    temp[ 0 ] = 0;
    for( i = 0; i < channels.amount; i++ ) {
        if( channels.data[ i ] ) {
            temp = realloc( temp, strlen( temp ) + strlen( channels.data[ i ] ) + 2 );
            strcat( temp, channels.data[ i ] );
            strcat( temp, "," );
        }
    }
    temp[ strlen( temp ) - 1 ] = 0; /* remove last ',' */
    return temp;
}
