/*
 *   Written by Bradley Broom (2002).
 *
 *   Copyright (c) 2002 Bradley Broom
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2, or (at your option)
 *   any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */
#include <stdlib.h>
#include <stdio.h>

#include "MRW_Private.h"

char *progname;

void
Usage ()
{
	fprintf (stderr, "Usage: %s < mrwfile\n", progname);
	exit (1);
}

int
main (int argc, char *argv[])
{
	mrw_header	hdr;
	char		*errmsg;
	int		i, offset, length;

	progname = argv[0];
	if (!LoadMRW (&hdr, stdin, &errmsg)) {
		fprintf (stderr, "%s: Error: Unable to load MRW file from stdin\n", progname);
		fprintf (stderr, "    %s\n", errmsg);
		Usage();
	}
	offset = IFD_GetUndefined (hdr.manu_ifd, MANUTAG_UNKNOWN);
	length = IFD_GetUndefinedLength (hdr.manu_ifd, MANUTAG_UNKNOWN);
	printf ("Length = %d\n", length);

	for (i = 0; i < length; i+=4)
		printf ("0x%03x=%d\n", i, mrw_val (hdr.ttw.data+offset, i, 4));

	exit (0);
}
