/* +---------------------------------------------------------------------------+
   |                     Mobile Robot Programming Toolkit (MRPT)               |
   |                          http://www.mrpt.org/                             |
   |                                                                           |
   | Copyright (c) 2005-2014, Individual contributors, see AUTHORS file        |
   | See: http://www.mrpt.org/Authors - All rights reserved.                   |
   | Released under BSD License. See details in http://www.mrpt.org/License    |
   +---------------------------------------------------------------------------+ */


/** \defgroup mrpt_reactivenav_grp [mrpt-reactivenav]

<small> <a href="index.html#libs">Back to list of all libraries</a> | <a href="modules.html" >See all modules</a> </small>
<br>

<h2>Library <code>mrpt-reactivenav</code></h2>
<hr>

This library implements:

<ul>

<li>Holonomic navigation algorithms:  
   Virtual Force Fields (VFF), Nearness Diagram (ND), ... 
   See mrpt::reactivenav::CAbstractHolonomicReactiveMethod </li>


<li>A complex reactive navigator: Using space transformations (PTGs) to drive
  a robot using an internal simpler holonomic algorithm. See mrpt::reactivenav::CReactiveNavigationSystem </li>

<li>A number of different PTGs: See mrpt::reactivenav::CParameterizedTrajectoryGenerator</li>

</ul>

See the full list of classes in mrpt::reactivenav, or the online
page http://www.mrpt.org/Application:ReactiveNavigationDemo for a discussion
of a working application (see MRPT/apps/ReactiveNavigationDemo).


*/

