/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001  CodeFactory AB
 * Copyright (C) 2001  Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult <rhult@codefactory.se>
 */

#ifndef __FILE_FILTER_H__
#define __FILE_FILTER_H__

#include <gtk/gtk.h>
#include <bonobo/bonobo-xobject.h>
#include "util/corba-utils.h"
#include "libmrproject/GNOME_MrProject.h"

#define TYPE_FILE_FILTER		(file_filter_get_type ())
#define FILE_FILTER(obj)		(GTK_CHECK_CAST ((obj), TYPE_FILE_FILTER, FileFilter))
#define FILE_FILTER_CLASS(klass)	(GTK_CHECK_CLASS_CAST ((klass), TYPE_FILE_FILTER, FileFilterClass))
#define IS_FILE_FILTER(obj)		(GTK_CHECK_TYPE ((obj), TYPE_FILE_FILTER))
#define IS_FILE_FILTER_CLASS(klass)	(GTK_CHECK_CLASS_TYPE ((obj), TYPE_FILE_FILTER))


typedef struct _FileFilter       FileFilter;
typedef struct _FileFilterClass  FileFilterClass;

struct _FileFilter
{
	BonoboXObject   parent;

	GM_Project             project;
	GM_TaskManager         task_mgr;
	GM_ResourceManager     resource_mgr;
	GM_AllocationManager   allocation_mgr;
};

struct _FileFilterClass
{
	BonoboXObjectClass                  parent_class;
	POA_GNOME_MrProject_FileFilter__epv epv;

	/* Methods. */
	gboolean (*probe)	(FileFilter        *filter,
				 const gchar       *uri,
				 CORBA_Environment *ev);

	gboolean (*parse)       (FileFilter        *filter,
				 const gchar       *buffer,
				 CORBA_Environment *ev);

	void (*load)		(FileFilter        *filter,
				 const gchar       *uri,
				 const GM_Project   project,
				 CORBA_Environment *ev);

	void (*load_summary)	(FileFilter        *filter,
				 const gchar       *uri,
				 GNOME_MrProject_FileSummary **summary,
				 CORBA_Environment *ev);

	void (*save)		(FileFilter        *filter,
				 const gchar       *uri,
				 const GM_Project   project,
				 CORBA_Environment *ev);
};


GtkType     file_filter_get_type (void);
FileFilter *file_filter_new      (void);




#endif /* __FILE_FILTER_H__ */
