/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 Richard Hult <rhult@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gal/e-paned/e-hpaned.h>
#include "util/type-utils.h"
#include "mr-hpaned.h"

static void mr_hpaned_init		(MrHPaned	 *paned);
static void mr_hpaned_class_init	(MrHPanedClass	 *klass);

GNOME_CLASS_BOILERPLATE (MrHPaned, mr_hpaned, EHPaned, e_hpaned);

#define BAR_WIDTH 6

static void
draw_resize_bar (GtkWidget		*widget,
		 GdkWindow		*window,
		 const GdkRectangle	*area)
{
	GtkStyle	*style;

	g_assert (widget != NULL);
	g_assert (window != NULL);
	g_assert (area != NULL);

	style = widget->style;
	g_assert (style != NULL);

	gtk_draw_box (style,
		      window,
		      GTK_STATE_NORMAL,
		      GTK_SHADOW_OUT,
		      area->x,
		      area->y,
		      area->x + area->width,
		      area->y + area->height);

}

static void
mr_hpaned_draw (GtkWidget    *widget,
		GdkRectangle *area)
{
	EPaned        *paned;
	GdkRectangle   handle_area, child_area;
	guint16        border_width;
	
	g_return_if_fail (widget != NULL);
	g_return_if_fail (IS_MR_HPANED (widget));

	if (GTK_WIDGET_VISIBLE (widget) && GTK_WIDGET_MAPPED (widget)) {
		paned = E_PANED (widget);
		border_width = GTK_CONTAINER (paned)->border_width;
		
		gdk_window_clear_area (widget->window,
				       area->x, area->y, area->width,
				       area->height);
		
		if (e_paned_handle_shown (paned)) {
			handle_area.x = paned->handle_xpos;
			handle_area.y = paned->handle_ypos;
			handle_area.width = paned->handle_size;
			handle_area.height = paned->handle_height;
			
			if (gdk_rectangle_intersect (&handle_area, area, &child_area)) {
				child_area.x -= paned->handle_xpos;
				child_area.y -= paned->handle_ypos;
				
				/* Simplify things by always drawing the full width and height of the bar. */
				child_area.y = 0;
				child_area.height = paned->handle_height;
				child_area.x = 0;
				child_area.width = BAR_WIDTH;
				
				draw_resize_bar (widget, paned->handle, &child_area);
			}
		}
		
		/* Redraw the children
		 */
		if (paned->child1 && gtk_widget_intersect (paned->child1, area, &child_area))
			gtk_widget_draw(paned->child1, &child_area);
		if (paned->child2 && gtk_widget_intersect(paned->child2, area, &child_area))
			gtk_widget_draw(paned->child2, &child_area);
	}
}


static void
mr_hpaned_class_init (MrHPanedClass *klass)
{
	GtkWidgetClass *widget_class;
	
	widget_class = (GtkWidgetClass*) klass;
	widget_class->draw = mr_hpaned_draw;
}


static void
mr_hpaned_init (MrHPaned *paned)
{
	e_paned_set_handle_size (E_PANED (paned), BAR_WIDTH);
}

GtkWidget *
mr_hpaned_new (void)
{
	return gtk_type_new (TYPE_MR_HPANED);
}
