/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
 * Copyright (C) 2001 CodeFactory AB
 * Copyright (C) 2001 Mikael Hallendal <micke@codefactory.se>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Mikael Hallendal <micke@codefactory.se>
 */

#ifndef __MANAGER_CLIENT_H__
#define __MANAGER_CLIENT_H__

#include <gtk/gtkobject.h>
#include <gtk/gtktypeutils.h>
#include <bonobo.h>
#include "util/corba-utils.h"

#define MANAGER_CLIENT_TYPE        (manager_client_get_type ())
#define MANAGER_CLIENT(o)          (GTK_CHECK_CAST ((o), MANAGER_CLIENT_TYPE, ManagerClient))
#define MANAGER_CLIENT_CLASS(k)    (GTK_CHECK_CLASS_CAST((k), MANAGER_CLIENT_TYPE, ManagerClientClass))
#define IS_MANAGER_CLIENT(o)       (GTK_CHECK_TYPE ((o), MANAGER_CLIENT_TYPE))
#define IS_MANAGER_CLIENT_CLASS(k) (GTK_CHECK_CLASS_TYPE ((k), MANAGER_CLIENT_TYPE))

typedef struct _ManagerClient      ManagerClient;
typedef struct _ManagerClientClass ManagerClientClass;
typedef struct _ManagerClientPriv  ManagerClientPriv;

struct _ManagerClient {
        GtkObject            parent;

        GM_Shell             shell;

        ManagerClientPriv   *priv;
};

struct _ManagerClientClass 
{
        GtkObjectClass               parent_class;

        /* Virtual functions */
        void (*listener)            (ManagerClient       *mc,
				     gchar               *subtype,
                                     CORBA_any           *any);

	/* Signals */
	void (*items_clear)         (ManagerClient       *mc);
        void (*project_set)         (ManagerClient       *mc);
        void (*project_unset)       (ManagerClient       *mc);
        void (*load_begin)          (ManagerClient       *mc);
        void (*load_end)            (ManagerClient       *mc);
};

GtkType  manager_client_get_type    (void);
void     manager_client_set_shell   (ManagerClient       *mc,
                                     GM_Shell             shell, 
                                     gchar               *eventname_subtype,
                                     CORBA_Environment   *ev);

#endif /* __MANGER_CLIENT_H__ */
