/*
 * Copyright (C) 2001  CodeFactory AB
 * Copyright (C) 2001  Richard Hult
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 *
 * Author: Richard Hult <rhult@codefactory.se>
 *         Mikael Hallendal <micke@codefactory.se>
 */
#ifndef __NETWORK_ITEM_H__
#define __NETWORK_ITEM_H__

#include <gtk/gtk.h>
#include <libgnomeui/gnome-canvas.h>
#include "util/corba-utils.h"

#define TYPE_NETWORK_ITEM			(network_item_get_type ())
#define NETWORK_ITEM(obj)			(GTK_CHECK_CAST ((obj), TYPE_NETWORK_ITEM, NetworkItem))
#define NETWORK_ITEM_CLASS(klass)		(GTK_CHECK_CLASS_CAST ((klass), TYPE_NETWORK_ITEM, NetworkItemClass))
#define IS_NETWORK_ITEM(obj)			(GTK_CHECK_TYPE ((obj), TYPE_NETWORK_ITEM))
#define IS_NETWORK_ITEM_CLASS(klass)		(GTK_CHECK_CLASS_TYPE ((obj), TYPE_NETWORK_ITEM))

typedef struct _NetworkItem       NetworkItem;
typedef struct _NetworkItemClass  NetworkItemClass;
typedef struct _NetworkItemPriv   NetworkItemPriv;

struct _NetworkItem {
	GnomeCanvasGroup  parent;
	NetworkItem      *parent_item;
	GM_Task          *task;

	GSList           *predecessors;

	guint             col;
};

struct _NetworkItemClass {
	GnomeCanvasGroupClass parent_class;

	/* Methods. */
	void (*set_task)	(NetworkItem *item);
        void (*update_task)     (NetworkItem *item);
	void (*reflow)          (NetworkItem *item);
	void (*layout)          (NetworkItem *item);
};

GtkType    network_item_get_type     (void);
void       network_item_update_task  (NetworkItem      *item,
                                      GM_Task          *task);
void       network_item_link         (NetworkItem      *item,
				      NetworkItem      *predecessor);
void       network_item_unlink       (NetworkItem      *item,
				      NetworkItem      *predecessor);
void       network_item_layout       (NetworkItem      *item);
void       network_item_sort_predecessors (NetworkItem *item);
void       network_item_move         (NetworkItem      *item,
				      gdouble           x,
				      gdouble           y);


#endif /* __NETWORK_ITEM_H__ */


