/*
 * Decompiled with CFR 0.152.
 */
package base.topology;

import base.drawable.CoordPixelXform;
import base.statistics.CategoryTimeBox;
import base.statistics.TimeAveBox;
import base.topology.Line;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Stroke;
import java.util.Arrays;

public class SummaryArrow {
    private static long Arrow_Log_Base = 10L;
    private static Stroke[] Line_Strokes = new Stroke[10];

    private static int drawForward(Graphics2D graphics2D, Color color, Stroke stroke, CoordPixelXform coordPixelXform, double d, float f, double d2, float f2) {
        int n;
        int n2;
        int n3;
        int n4;
        int n5 = coordPixelXform.convertTimeToPixel(d);
        int n6 = coordPixelXform.convertTimeToPixel(d2);
        int n7 = coordPixelXform.convertRowToPixel(f);
        int n8 = coordPixelXform.convertRowToPixel(f2);
        boolean bl = n5 > 0;
        boolean bl2 = n6 < coordPixelXform.getImageWidth();
        double d3 = 0.0;
        if (!bl || !bl2) {
            if (n5 != n6) {
                d3 = (double)(n8 - n7) / (double)(n6 - n5);
            } else {
                return 0;
            }
        }
        if (bl) {
            n4 = n5;
            n3 = n7;
        } else {
            n4 = 0;
            n3 = (int)Math.rint((double)n7 - d3 * (double)n5);
        }
        if (bl2) {
            n2 = n6;
            n = n8;
        } else {
            n2 = coordPixelXform.getImageWidth();
            n = (int)Math.rint((double)n8 + d3 * (double)(n2 - n6));
        }
        Stroke stroke2 = null;
        if (stroke != null) {
            stroke2 = graphics2D.getStroke();
            graphics2D.setStroke(stroke);
        }
        graphics2D.setColor(color);
        graphics2D.drawLine(n4, n3, n2, n);
        if (stroke != null) {
            graphics2D.setStroke(stroke2);
        }
        return 1;
    }

    public static void setTimeBoundingBox(TimeAveBox timeAveBox, double d, double d2) {
        CategoryTimeBox[] categoryTimeBoxArray = timeAveBox.arrayOfCategoryTimeBoxes();
        Arrays.sort(categoryTimeBoxArray, CategoryTimeBox.INCL_RATIO_ORDER);
        boolean bl = true;
        double d3 = d2 - d;
        for (int i = categoryTimeBoxArray.length - 1; i >= 0; --i) {
            CategoryTimeBox categoryTimeBox = categoryTimeBoxArray[i];
            double d4 = d3 * (double)categoryTimeBox.getCategoryRatio(bl);
            categoryTimeBox.setEarliestTime(d);
            categoryTimeBox.setLatestFromEarliest(d4);
        }
    }

    public static void setBaseOfLogOfObjectNumToArrowWidth(int n) {
        Arrow_Log_Base = n;
    }

    private static Stroke getArrowStroke(double d) {
        int n;
        long l = Math.round(d);
        for (n = 0; n < Line_Strokes.length && (l /= Arrow_Log_Base) != 0L; ++n) {
        }
        if (n < Line_Strokes.length) {
            return Line_Strokes[n];
        }
        return Line_Strokes[Line_Strokes.length - 1];
    }

    public static int draw(Graphics2D graphics2D, TimeAveBox timeAveBox, CoordPixelXform coordPixelXform, float f, float f2) {
        float f3 = f;
        float f4 = f2;
        CategoryTimeBox[] categoryTimeBoxArray = timeAveBox.arrayOfCategoryTimeBoxes();
        int n = 0;
        Stroke stroke = SummaryArrow.getArrowStroke(timeAveBox.getAveNumOfRealObjects());
        CategoryTimeBox categoryTimeBox = categoryTimeBoxArray[categoryTimeBoxArray.length - 1];
        double d = categoryTimeBox.getEarliestTime();
        double d2 = categoryTimeBox.getLatestTime();
        double d3 = (double)(f4 - f3) / (d2 - d);
        double d4 = (double)f3 - d3 * d;
        for (int i = categoryTimeBoxArray.length - 1; i >= 0; --i) {
            categoryTimeBox = categoryTimeBoxArray[i];
            Color color = categoryTimeBox.getCategoryColor();
            d = categoryTimeBox.getEarliestTime();
            d2 = categoryTimeBox.getLatestTime();
            f4 = (float)(d3 * d2 + d4);
            n += SummaryArrow.drawForward(graphics2D, color, stroke, coordPixelXform, d, f3, d2, f4);
        }
        return n;
    }

    public static Object containsPixel(TimeAveBox timeAveBox, CoordPixelXform coordPixelXform, Point point, float f, float f2) {
        float f3 = f;
        float f4 = f2;
        CategoryTimeBox[] categoryTimeBoxArray = timeAveBox.arrayOfCategoryTimeBoxes();
        CategoryTimeBox categoryTimeBox = categoryTimeBoxArray[categoryTimeBoxArray.length - 1];
        double d = categoryTimeBox.getEarliestTime();
        double d2 = categoryTimeBox.getLatestTime();
        double d3 = (double)(f4 - f3) / (d2 - d);
        double d4 = (double)f3 - d3 * d;
        for (int i = 0; i < categoryTimeBoxArray.length; ++i) {
            categoryTimeBox = categoryTimeBoxArray[i];
            d = categoryTimeBox.getEarliestTime();
            if (!Line.containsPixel(coordPixelXform, point, d, f3, d2 = categoryTimeBox.getLatestTime(), f4 = (float)(d3 * d2 + d4))) continue;
            return timeAveBox;
        }
        return null;
    }

    static {
        for (int i = Line_Strokes.length - 1; i >= 0; --i) {
            SummaryArrow.Line_Strokes[i] = new BasicStroke(i + 1);
        }
    }
}

