/*
 * Decompiled with CFR 0.152.
 */
package viewer.legends;

import base.drawable.Category;
import java.util.Comparator;
import viewer.common.Parameters;

public class LegendComparators {
    public static final Comparator INDEX_ORDER = new IndexOrder();
    private static final Comparator PREVIEW_ORDER = new PreviewOrder();
    private static final Comparator TOPOLOGY_ORDER = new TopologyOrder();
    public static final Comparator CASE_SENSITIVE_ORDER = new CaseSensitiveOrder();
    public static final Comparator CASE_INSENSITIVE_ORDER = new CaseInsensitiveOrder();
    public static final Comparator LONG_NAME_ORDER = new LongNameOrder();
    public static final Comparator COUNT_ORDER = new CountOrder();
    public static final Comparator INCL_RATIO_ORDER = new InclusiveRatioOrder();
    public static final Comparator EXCL_RATIO_ORDER = new ExclusiveRatioOrder();

    public static class ExclusiveRatioOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            float f = category.getSummary().getRatio(false) - category2.getSummary().getRatio(false);
            return f < 0.0f ? -1 : (f == 0.0f ? 0 : 1);
        }
    }

    public static class InclusiveRatioOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            float f = category.getSummary().getRatio(true) - category2.getSummary().getRatio(true);
            return f < 0.0f ? -1 : (f == 0.0f ? 0 : 1);
        }
    }

    public static class CountOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            long l = category.getSummary().getDrawableCount() - category2.getSummary().getDrawableCount();
            return l < 0L ? -1 : (l == 0L ? 0 : 1);
        }
    }

    public static class LongNameOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            return category.getName().length() - category2.getName().length();
        }
    }

    public static class CaseInsensitiveOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            int n = 0;
            if (Parameters.LEGEND_TOPOLOGY_ORDER && (n = TOPOLOGY_ORDER.compare(category, category2)) != 0) {
                return n;
            }
            if (Parameters.LEGEND_PREVIEW_ORDER && (n = PREVIEW_ORDER.compare(category, category2)) != 0) {
                return n;
            }
            return category.getName().compareToIgnoreCase(category2.getName());
        }
    }

    public static class CaseSensitiveOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            int n = 0;
            if (Parameters.LEGEND_TOPOLOGY_ORDER && (n = TOPOLOGY_ORDER.compare(category, category2)) != 0) {
                return n;
            }
            if (Parameters.LEGEND_PREVIEW_ORDER && (n = PREVIEW_ORDER.compare(category, category2)) != 0) {
                return n;
            }
            return category.getName().compareTo(category2.getName());
        }
    }

    public static class TopologyOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            return category2.getTopology().hashCode() - category.getTopology().hashCode();
        }
    }

    public static class PreviewOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            int n = category.getIndex() < 0 ? 0 : 1;
            int n2 = category2.getIndex() < 0 ? 0 : 1;
            return n - n2;
        }
    }

    public static class IndexOrder
    implements Comparator {
        public int compare(Object object, Object object2) {
            Category category = (Category)object;
            Category category2 = (Category)object2;
            return category.getIndex() - category2.getIndex();
        }
    }
}

