/*
 * Decompiled with CFR 0.152.
 */
package viewer.convertor;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import viewer.convertor.ConvertorPanel;

public class ConvertorFrame
extends JFrame {
    private static final long serialVersionUID = 11300L;
    private static String in_filename;
    private ConvertorPanel top_panel;
    private static String help_msg;

    public ConvertorFrame() {
        super("Logfile Convertor");
        super.setDefaultCloseOperation(0);
        this.top_panel = new ConvertorPanel(null);
        this.top_panel.addActionListenerForOkayButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConvertorFrame.this.setVisible(false);
                ConvertorFrame.this.dispose();
                System.exit(0);
            }
        });
        this.top_panel.addActionListenerForCancelButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ConvertorFrame.this.setVisible(false);
                ConvertorFrame.this.dispose();
                System.exit(0);
            }
        });
        super.setContentPane(this.top_panel);
        super.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ConvertorFrame.this.setVisible(false);
                ConvertorFrame.this.dispose();
                System.exit(0);
            }
        });
    }

    public void init(String string) {
        this.top_panel.init(string);
    }

    public static void main(String[] stringArray) {
        ConvertorFrame.checkVersion();
        ConvertorFrame.parseCmdLineArgs(stringArray);
        ConvertorFrame convertorFrame = new ConvertorFrame();
        convertorFrame.pack();
        convertorFrame.setVisible(true);
        convertorFrame.init(in_filename);
    }

    public static void checkVersion() {
        String string = System.getProperty("java.version");
        System.out.println("Java is version " + string + ".");
        if (string.compareTo("1.2.0") < 0) {
            System.err.println("WARNING: Java is version " + string + ". \n" + "\t It is too old to run this prototype.");
        }
    }

    private static void parseCmdLineArgs(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        try {
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("-")) {
                    if (stringArray[n].equals("-h") || stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    System.err.println("Unrecognized option, " + stringArray[n] + ", at " + ConvertorFrame.indexOrderStr(n + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = stringArray[n];
                ++n;
            }
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + ConvertorFrame.indexOrderStr(n) + " command line argument.  It needs a number.");
            numberFormatException.printStackTrace();
        }
    }

    private static String indexOrderStr(int n) {
        switch (n) {
            case 1: {
                return Integer.toString(n) + "st";
            }
            case 2: {
                return Integer.toString(n) + "nd";
            }
            case 3: {
                return Integer.toString(n) + "rd";
            }
        }
        return Integer.toString(n) + "th";
    }

    static {
        help_msg = "Usage: java viewer.convertor.ConvertorFrame [options] trace_filename.\nOptions: \n\t [-h|-help|--help]                 \t Display this message.\n";
    }
}

