/*
 * Decompiled with CFR 0.152.
 */
package logformat.slog2.update;

import base.drawable.Category;
import base.drawable.Composite;
import base.drawable.Drawable;
import base.drawable.Kind;
import base.drawable.Primitive;
import base.drawable.Topology;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.StringTokenizer;
import logformat.slog2.CategoryMap;
import logformat.slog2.LineIDMap;
import logformat.slog2.LineIDMapList;
import logformat.slog2.TraceName;
import logformat.slog2.output.OutputLog;
import logformat.slog2.output.TreeTrunk;
import logformat.slog2.update.WrappedInputLog;

public class UpdateToLatest {
    private static short num_children_per_node = 0;
    private static int leaf_bytesize = 0;
    private static String in_filename;
    private static String out_filename;
    private static boolean enable_endtime_check;
    private static boolean continue_when_violation;
    private static int[] del_iobjdefs;
    private static String help_msg;

    public static final void main(String[] stringArray) {
        Kind kind;
        String string;
        double d = Double.NEGATIVE_INFINITY;
        long l = Integer.MIN_VALUE;
        Drawable drawable = null;
        out_filename = null;
        del_iobjdefs = null;
        UpdateToLatest.parseCmdLineArgs(stringArray);
        if (out_filename == null) {
            out_filename = TraceName.getDefaultSLOG2Name(in_filename);
        }
        CategoryMap categoryMap = new CategoryMap();
        HashMap<Topology, Category> hashMap = new HashMap<Topology, Category>();
        LineIDMapList lineIDMapList = new LineIDMapList();
        long l2 = 0L;
        WrappedInputLog wrappedInputLog = new WrappedInputLog(in_filename);
        if (wrappedInputLog == null) {
            System.err.println("Null input logfile!");
            System.exit(1);
        }
        if (!wrappedInputLog.isSLOG2()) {
            System.err.println(in_filename + " is NOT SLOG-2 file!.");
            System.exit(1);
        }
        if ((string = wrappedInputLog.getCompatibleHeader()) != null) {
            System.err.print(string);
            WrappedInputLog.stdoutConfirmation();
        }
        wrappedInputLog.initialize();
        Date date = new Date();
        OutputLog outputLog = new OutputLog(out_filename);
        if (leaf_bytesize > 0) {
            outputLog.setTreeLeafByteSize(leaf_bytesize);
        } else {
            outputLog.setTreeLeafByteSize(wrappedInputLog.getTreeLeafByteSize());
        }
        if (num_children_per_node > 0) {
            outputLog.setNumChildrenPerNode(num_children_per_node);
        } else {
            outputLog.setNumChildrenPerNode(wrappedInputLog.getNumChildrenPerNode());
        }
        TreeTrunk treeTrunk = new TreeTrunk(outputLog, hashMap);
        Date date2 = new Date();
        while ((kind = wrappedInputLog.peekNextKind()) != Kind.EOF) {
            double d2;
            Category category;
            if (kind == Kind.TOPOLOGY) {
                Topology topology = wrappedInputLog.getNextTopology();
                category = Category.getShadowCategory(topology);
                categoryMap.put(new Integer(category.getIndex()), category);
                hashMap.put(topology, category);
                continue;
            }
            if (kind == Kind.YCOORDMAP) {
                LineIDMap lineIDMap = new LineIDMap(wrappedInputLog.getNextYCoordMap());
                lineIDMapList.add(lineIDMap);
                continue;
            }
            if (kind == Kind.CATEGORY) {
                category = wrappedInputLog.getNextCategory();
                if (category.isShadowCategory()) {
                    categoryMap.put(new Integer(category.getIndex()), category);
                    hashMap.put(category.getTopology(), category);
                }
                categoryMap.put(new Integer(category.getIndex()), category);
                category.setUsed(false);
                continue;
            }
            if (kind == Kind.PRIMITIVE) {
                Primitive primitive = wrappedInputLog.getNextPrimitive();
                primitive.releaseCategory();
                if (UpdateToLatest.isCategoryToBeRemoved(primitive.getCategoryIndex())) continue;
                primitive.resolveCategory(categoryMap);
                ++l2;
                if (enable_endtime_check) {
                    if (!primitive.isTimeOrdered()) {
                        System.out.println("**** Primitive Time Error ****");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    if (d > (d2 = primitive.getLatestTime())) {
                        System.err.println("**** Violation of Increasing Endtime Order ****\n\t Offended Drawable -> " + l + " : " + drawable + "\n" + "\t Offending Primitive -> " + l2 + " : " + primitive + "\n" + "   previous drawable endtime ( " + d + " ) " + " > current drawable endtiime ( " + d2 + " ) ");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    l = l2;
                    drawable = primitive;
                    d = d2;
                }
                treeTrunk.addDrawable(primitive);
                continue;
            }
            if (kind == Kind.COMPOSITE) {
                Composite composite = wrappedInputLog.getNextComposite();
                composite.releaseCategory();
                if (UpdateToLatest.isCategoryToBeRemoved(composite.getCategoryIndex())) continue;
                composite.resolveCategory(categoryMap);
                ++l2;
                if (enable_endtime_check) {
                    if (!composite.isTimeOrdered()) {
                        System.out.println("**** Composite Time Error ****");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    if (d > (d2 = composite.getLatestTime())) {
                        System.err.println("***** Violation of Increasing Endtime Order! *****\n\t Offended Drawable -> " + l + " : " + drawable + "\n" + "\t Offending Composite -> " + l2 + " : " + composite + "\n" + "   previous drawable endtime ( " + d + " ) " + " > current drawable endtiime ( " + d2 + " ) ");
                        if (!continue_when_violation) {
                            System.exit(1);
                        }
                    }
                    l = l2;
                    drawable = composite;
                    d = d2;
                }
                treeTrunk.addDrawable(composite);
                continue;
            }
            System.err.println("Slog2ToSlog2: Unrecognized return from peekNextKind() = " + kind);
        }
        treeTrunk.flushToFile();
        categoryMap.removeUnusedCategories();
        outputLog.writeCategoryMap(categoryMap);
        outputLog.writeLineIDMapList(lineIDMapList);
        outputLog.close();
        wrappedInputLog.close();
        Date date3 = new Date();
        System.out.println("\n");
        System.out.println("Number of Drawables = " + l2);
        System.out.println("timeElapsed between 1 & 2 = " + (date2.getTime() - date.getTime()) + " msec");
        System.out.println("timeElapsed between 2 & 3 = " + (date3.getTime() - date2.getTime()) + " msec");
    }

    private static int parseByteSize(String string) {
        int n = Math.max(string.indexOf(107), string.indexOf(75));
        int n2 = Math.max(string.indexOf(109), string.indexOf(77));
        if (n > 0) {
            return Integer.parseInt(string.substring(0, n)) * 1024;
        }
        if (n2 > 0) {
            return Integer.parseInt(string.substring(0, n2)) * 1024 * 1024;
        }
        return Integer.parseInt(string);
    }

    private static void parseCmdLineArgs(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        in_filename = null;
        enable_endtime_check = false;
        continue_when_violation = false;
        int n = 0;
        try {
            while (n < stringArray.length) {
                if (stringArray[n].startsWith("-")) {
                    String string;
                    if (stringArray[n].equals("-h") || stringArray[n].equals("--h") || stringArray[n].equals("-help") || stringArray[n].equals("--help")) {
                        System.out.println(help_msg);
                        System.out.flush();
                        System.exit(0);
                        continue;
                    }
                    if (stringArray[n].equals("-tc")) {
                        enable_endtime_check = true;
                        continue_when_violation = false;
                        stringBuffer.append("\n endtime_order_check_exit = true");
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-tcc")) {
                        enable_endtime_check = true;
                        continue_when_violation = true;
                        stringBuffer.append("\n endtime_order_check_stay = true");
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-nc")) {
                        string = stringArray[++n];
                        num_children_per_node = Short.parseShort(string);
                        stringBuffer.append("\n number_of_children_per_node = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-ls")) {
                        string = stringArray[++n];
                        leaf_bytesize = UpdateToLatest.parseByteSize(string);
                        stringBuffer.append("\n max_byte_size_of_leaf_node = " + string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-r")) {
                        string = stringArray[++n];
                        UpdateToLatest.parseRemovalCategoryIndexes(string);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equals("-o")) {
                        out_filename = stringArray[++n].trim();
                        stringBuffer.append("\n output_filename = " + out_filename);
                        ++n;
                        if (out_filename.endsWith(".slog2")) continue;
                        System.err.println("Warning: The suffix of the output filename is NOT \".slog2\".");
                        continue;
                    }
                    System.err.println("Unrecognized option, " + stringArray[n] + ", at " + UpdateToLatest.indexOrderStr(n + 1) + " command line argument");
                    System.out.flush();
                    System.exit(1);
                    continue;
                }
                in_filename = stringArray[n];
                ++n;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + UpdateToLatest.indexOrderStr(n) + " command line argument.");
            arrayIndexOutOfBoundsException.printStackTrace();
        }
        catch (NumberFormatException numberFormatException) {
            if (stringBuffer.length() > 0) {
                System.err.println(stringBuffer.toString());
            }
            String string = UpdateToLatest.indexOrderStr(n);
            System.err.println("Error occurs after option " + stringArray[n - 1] + ", " + UpdateToLatest.indexOrderStr(n) + " command line argument.  It needs a number.");
            numberFormatException.printStackTrace();
        }
        if (in_filename == null) {
            System.err.println("This program needs a SLOG2 filename as part of the command line arguments.");
            System.err.println(help_msg);
            System.exit(1);
        }
    }

    private static String indexOrderStr(int n) {
        switch (n) {
            case 1: {
                return Integer.toString(n) + "st";
            }
            case 2: {
                return Integer.toString(n) + "nd";
            }
            case 3: {
                return Integer.toString(n) + "rd";
            }
        }
        return Integer.toString(n) + "th";
    }

    private static void parseRemovalCategoryIndexes(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.trim(), ",");
        del_iobjdefs = new int[stringTokenizer.countTokens()];
        int n = 0;
        while (stringTokenizer.hasMoreTokens()) {
            UpdateToLatest.del_iobjdefs[n] = Integer.parseInt(stringTokenizer.nextToken());
            ++n;
        }
        Arrays.sort(del_iobjdefs);
    }

    private static boolean isCategoryToBeRemoved(int n) {
        return del_iobjdefs != null && Arrays.binarySearch(del_iobjdefs, n) >= 0;
    }

    static {
        help_msg = "Usage: java slog2.output.Slog2ToSlog2 [options] slog2_filename.\n options: \n\t [-h|--h|-help|--help]             \t Display HELP message.\n\t [-tc]                             \t Check increasing endtime order,\n\t                                   \t exit when 1st violation occurs.\n\t [-tcc]                            \t Check increasing endtime order,\n\t                                   \t continue when violations occur.\n\t [-nc number_of_children_per_node] \t Default value is taken from the\n\t                                   \t input slog2 file.\n\t [-ls max_byte_size_of_leaf_node]  \t Default value is taken from the\n\t                                   \t input slog2 file.\n\t [-r id1,id2,...,idN]              \t Remove drawable categories of  \n\t                                   \t indexes, id1,id2,...,idN.\n\t [-o output_filename_with_slog2_suffix]\n\n note: \"max_byte_size_of_leaf_node\" can be specified with suffix k, K, m or M,\n       where k or K stands for kilobyte, m or M stands for megabyte.\n       e.g. 64k means 65536 bytes.\n";
    }
}

