/* -*- Mode: C; c-basic-offset:4 ; -*- */
/*
 *  (C) 2014 by Argonne National Laboratory.
 *      See COPYRIGHT in top-level directory.
 *
 * This file is automatically generated by buildiface
 * DO NOT EDIT
 */

/*
 * This file is created for the sole purpose of referencing all the symbols
 * in ROMIO.
 *
 * All ROMIO public symbols are being added into the libromio convenience
 * library, which is LIBADD'ed into libmpi.  The correct behavior would
 * be for libtool to add -Wl,--whole-archive to the link line, thus
 * forcing all symbols in libromio to end up in libmpi.  However, in some
 * cases, this is not working out correctly.  For example, with the
 * Absoft compiler, the linker flags were being reordered thus causing
 * the -Wl,--whole-archive flag to not correspond to libromio.
 * Consequently, only symbols that were used from within the other
 * functions of libmpi were being included.
 *
 * In the past, we got lucky in two ways:
 *
 * 1. We were including all the Fortran 77 symbols into libmpi.  Since
 * the Fortran symbols were calling the C ROMIO symbols, those ROMIO
 * symbols were pulled in even without -Wl,--whole-archive.
 *
 * 2. The problem only showed up with absoft and nag, both of which are
 * Fortran-only compilers.  If a C compiler has this issue, it should
 * have shown up when Fortran support is disabled.
 */

#include "mpiimpl.h"

#include <stdio.h>

void MPIR_All_romio_symbols(void);
void MPIR_All_romio_symbols(void)
{
#ifdef MPI_MODE_RDONLY
    {
        MPI_Comm comm = MPI_COMM_NULL;
        const char* filename = NULL;
        int amode = 0;
        MPI_Info info = MPI_INFO_NULL;
        MPI_File* fh = NULL;

        MPI_File_open(comm, filename, amode, info, fh);
    }

    {
        MPI_File* fh = NULL;

        MPI_File_close(fh);
    }

    {
        const char* filename = NULL;
        MPI_Info info = MPI_INFO_NULL;

        MPI_File_delete(filename, info);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset size = 0;

        MPI_File_set_size(fh, size);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset size = 0;

        MPI_File_preallocate(fh, size);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset* size = NULL;

        MPI_File_get_size(fh, size);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Group* group = NULL;

        MPI_File_get_group(fh, group);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        int* amode = NULL;

        MPI_File_get_amode(fh, amode);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Info info = MPI_INFO_NULL;

        MPI_File_set_info(fh, info);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Info* info_used = NULL;

        MPI_File_get_info(fh, info_used);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset disp = 0;
        MPI_Datatype etype = MPI_DATATYPE_NULL;
        MPI_Datatype filetype = MPI_DATATYPE_NULL;
        const char* datarep = NULL;
        MPI_Info info = MPI_INFO_NULL;

        MPI_File_set_view(fh, disp, etype, filetype, datarep, info);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset* disp = NULL;
        MPI_Datatype* etype = NULL;
        MPI_Datatype* filetype = NULL;
        char* datarep = NULL;

        MPI_File_get_view(fh, disp, etype, filetype, datarep);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset offset = 0;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Status* status = NULL;

        MPI_File_read_at(fh, offset, buf, count, datatype, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset offset = 0;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Status* status = NULL;

        MPI_File_read_at_all(fh, offset, buf, count, datatype, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset offset = 0;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Status* status = NULL;

        MPI_File_write_at(fh, offset, buf, count, datatype, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset offset = 0;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Status* status = NULL;

        MPI_File_write_at_all(fh, offset, buf, count, datatype, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset offset = 0;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPIO_Request* request = NULL;

        MPI_File_iread_at(fh, offset, buf, count, datatype, request);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset offset = 0;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPIO_Request* request = NULL;

        MPI_File_iwrite_at(fh, offset, buf, count, datatype, request);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Status* status = NULL;

        MPI_File_read(fh, buf, count, datatype, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Status* status = NULL;

        MPI_File_read_all(fh, buf, count, datatype, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Status* status = NULL;

        MPI_File_write(fh, buf, count, datatype, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Status* status = NULL;

        MPI_File_write_all(fh, buf, count, datatype, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPIO_Request* request = NULL;

        MPI_File_iread(fh, buf, count, datatype, request);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPIO_Request* request = NULL;

        MPI_File_iwrite(fh, buf, count, datatype, request);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset offset = 0;
        int whence = 0;

        MPI_File_seek(fh, offset, whence);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset* offset = NULL;

        MPI_File_get_position(fh, offset);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset offset = 0;
        MPI_Offset* disp = NULL;

        MPI_File_get_byte_offset(fh, offset, disp);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Status* status = NULL;

        MPI_File_read_shared(fh, buf, count, datatype, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Status* status = NULL;

        MPI_File_write_shared(fh, buf, count, datatype, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPIO_Request* request = NULL;

        MPI_File_iread_shared(fh, buf, count, datatype, request);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPIO_Request* request = NULL;

        MPI_File_iwrite_shared(fh, buf, count, datatype, request);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Status* status = NULL;

        MPI_File_read_ordered(fh, buf, count, datatype, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Status* status = NULL;

        MPI_File_write_ordered(fh, buf, count, datatype, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset offset = 0;
        int whence = 0;

        MPI_File_seek_shared(fh, offset, whence);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset* offset = NULL;

        MPI_File_get_position_shared(fh, offset);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset offset = 0;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;

        MPI_File_read_at_all_begin(fh, offset, buf, count, datatype);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        void* buf = NULL;
        MPI_Status* status = NULL;

        MPI_File_read_at_all_end(fh, buf, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset offset = 0;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;

        MPI_File_write_at_all_begin(fh, offset, buf, count, datatype);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        const void* buf = NULL;
        MPI_Status* status = NULL;

        MPI_File_write_at_all_end(fh, buf, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;

        MPI_File_read_all_begin(fh, buf, count, datatype);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        void* buf = NULL;
        MPI_Status* status = NULL;

        MPI_File_read_all_end(fh, buf, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;

        MPI_File_write_all_begin(fh, buf, count, datatype);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        const void* buf = NULL;
        MPI_Status* status = NULL;

        MPI_File_write_all_end(fh, buf, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;

        MPI_File_read_ordered_begin(fh, buf, count, datatype);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        void* buf = NULL;
        MPI_Status* status = NULL;

        MPI_File_read_ordered_end(fh, buf, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;

        MPI_File_write_ordered_begin(fh, buf, count, datatype);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        const void* buf = NULL;
        MPI_Status* status = NULL;

        MPI_File_write_ordered_end(fh, buf, status);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Aint* extent = NULL;

        MPI_File_get_type_extent(fh, datatype, extent);
    }

    {
        const char* datarep = NULL;
        MPI_Datarep_conversion_function* read_conversion_fn = NULL;
        MPI_Datarep_conversion_function* write_conversion_fn = NULL;
        MPI_Datarep_extent_function* dtype_file_extent_fn = NULL;
        void* extra_state = NULL;

        MPI_Register_datarep(datarep, read_conversion_fn, write_conversion_fn, dtype_file_extent_fn, extra_state);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        int flag = 0;

        MPI_File_set_atomicity(fh, flag);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        int* flag = NULL;

        MPI_File_get_atomicity(fh, flag);
    }

    {
        MPI_File fh = MPI_FILE_NULL;

        MPI_File_sync(fh);
    }

    {
        MPI_File file = MPI_FILE_NULL;
        MPI_Errhandler errhandler = MPI_ERRHANDLER_NULL;

        MPI_File_set_errhandler(file, errhandler);
    }

    {
        MPI_File file = MPI_FILE_NULL;
        MPI_Errhandler* errhandler = NULL;

        MPI_File_get_errhandler(file, errhandler);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset offset = 0;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Request* request = NULL;

        MPI_File_iread_at_all(fh, offset, buf, count, datatype, request);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        MPI_Offset offset = 0;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Request* request = NULL;

        MPI_File_iwrite_at_all(fh, offset, buf, count, datatype, request);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Request* request = NULL;

        MPI_File_iread_all(fh, buf, count, datatype, request);
    }

    {
        MPI_File fh = MPI_FILE_NULL;
        const void* buf = NULL;
        int count = 0;
        MPI_Datatype datatype = MPI_DATATYPE_NULL;
        MPI_Request* request = NULL;

        MPI_File_iwrite_all(fh, buf, count, datatype, request);
    }

    {
        MPI_Fint fh = 0;

        MPI_File_f2c(fh);
    }

    {
        MPI_File fh = MPI_FILE_NULL;

        MPI_File_c2f(fh);
    }

    MPIR_Comm_split_filesystem(MPI_COMM_NULL, 0, NULL, NULL);
#endif /* MPI_MODE_RDONLY */
}
