/***************************************************************************
                          ogginfo.cpp  -  description
                             -------------------
    begin                : Sat Feb 9 2002
    copyright            : (C) 2002 by Stefano Brustia
    email                : hio@lombardiacom.it
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include "ogginfo.h"
#include <qstring.h>
#include <sys/stat.h>

#ifdef HAVE_ICONV_OPEN
#include <iconv.h>
#endif

#include <errno.h>

#ifdef HAVE_CODESET
#include <langinfo.h>
#endif

#define GENRE_MAX 148

static const char *genre_list[] = {
     "Blues",                 "Classic Rock",          "Country",
     "Dance",                 "Disco",                 "Funk",
     "Grunge",                "Hip-Hop",               "Jazz",
     "Metal",                 "New Age",               "Oldies",
     "Other",                 "Pop",                   "R&B",
     "Rap",                   "Reggae",                "Rock",
     "Techno",                "Industrial",            "Alternative",
     "Ska",                   "Death Metal",           "Pranks",
     "Soundtrack",            "Euro-Techno",           "Ambient",
     "Trip-Hop",              "Vocal",                 "Jazz+Funk",
     "Fusion",                "Trance",                "Classical",
     "Instrumental",          "Acid",                  "House",
     "Game",                  "Sound Clip",            "Gospel",
     "Noise",                 "Alt. Rock",             "Bass",
     "Soul",                  "Punk",                  "Space",
     "Meditative",            "Instrum. Pop",          "Instrum. Rock",
     "Ethnic",                "Gothic",                "Darkwave",
     "Techno-Indust.",        "Electronic",            "Pop-Folk",
     "Eurodance",             "Dream",                 "Southern Rock",
     "Comedy",                "Cult",                  "Gangsta",
     "Top 40",                "Christian Rap",         "Pop/Funk",
     "Jungle",                "Native American",       "Cabaret",
     "New Wave",              "Psychadelic",           "Rave",
     "Showtunes",             "Trailer",               "Lo-Fi",
     "Tribal",                "Acid Punk",             "Acid Jazz",
     "Polka",                 "Retro",                 "Musical",
     "Rock & Roll",           "Hard Rock",             "Folk",
     "Folk/Rock",             "National Folk",         "Swing",
     "Fusion",                "Bebob",                 "Latin",
     "Revival",               "Celtic",                "Bluegrass",
     "Avantgarde",            "Gothic Rock",           "Progress. Rock",
     "Psychadel. Rock",       "Symphonic Rock",        "Slow Rock",
     "Big Band",              "Chorus",                "Easy Listening",
     "Acoustic",              "Humour",                "Speech",
     "Chanson",               "Opera",                 "Chamber Music",
     "Sonata",                "Symphony",              "Booty Bass",
     "Primus",                "Porn Groove",           "Satire",
     "Slow Jam",              "Club",                  "Tango",
     "Samba",                 "Folklore",              "Ballad",
     "Power Ballad",          "Rhythmic Soul",         "Freestyle",
     "Duet",                  "Punk Rock",             "Drum Solo",
     "A Capella",             "Euro-House",            "Dance Hall",
     "Goa",                   "Drum & Bass",           "Club-House",
     "Hardcore",              "Terror",                "Indie",
     "BritPop",               "Negerpunk",             "Polsk Punk",
     "Beat",                  "Christian Gangsta Rap", "Heavy Metal",
     "Black Metal",           "Crossover",             "Contemporary Christian",
     "Christian Rock",        "Merengue",              "Salsa",
     "Trash Metal",           "Anime",                 "Jpop",
     "Synthpop"};

static const char *mode_names[7] =
{"0 Chan", "1 Chan", "2 Chan", "3 Chan", "4 Chan", "5 Chan", "6 Chan"};


OggInfo::OggInfo(const char* filein)
{
	success =false;
	fileglob = strdup(filein);
	if ((file = fopen(filein, "r")))
	{
		success = true;
		if ((ov_open(file,&vf,NULL,0) == 0))
		{
			if ((vi=ov_info(&vf,0)) != NULL)
			{
				if ((vc=ov_comment(&vf,0)) == NULL)
					cerr << "No tag: " << fileglob << endl;
			}
			else
			{
				success = false;
				cerr << "Error reading Vorbis information  " << filein<<endl;
			}

		}
		else
		{
			cerr << "Error ! it isn't a Ogg file  " << filein<<endl;
			success =false;
		}
	}
	else
		success = false;
}

OggInfo::~OggInfo()
{
	fclose(file);
}

const char* OggInfo::getPath() {
     char* buf=new char [strlen(fileglob)+1];
     char* p, *path;
     strcpy (buf, fileglob);
     p=strrchr(buf, '/');
     *p='\0';
     path=strdup(buf);
     delete[] buf;
     return path;
}

const char* OggInfo::getName() {
	char* name;
	return name=(strdup(strrchr(fileglob, '/')+1));
}

int OggInfo::getSize()
{
	struct stat fi;

	fstat(fileno(file), &fi);
	return (fi.st_size);
}

int OggInfo::getBitrateNominal()
{
	if (vi)
		return(vi->bitrate_nominal);
	else
		return (0);
}

int OggInfo::getBitrateUpper()
{
	if (vi)
		return(vi->bitrate_upper);
	else
		return (0);
}

int OggInfo::getBitrateLower()
{
	if (vi)
		return(vi->bitrate_lower);
	else
		return (0);
}

int OggInfo::getBitrate()
{
	if (vi)
		return (getBitrateNominal()/1000);
	else
		return (0);
}

int OggInfo::getSamplerate()
{
	if (vi)
		return(vi->rate);
	else
		return (0);
}

int OggInfo::getMode()
{
	if (vi)
		return(vi->channels);
	else
		return (0);
}

const char* OggInfo::getMode(int mode)
{
	if ((mode >= 0) && (mode < 7))
	     return (mode_names[mode]);

     return "2 Chan";
}

int OggInfo::getLength()
{
	int len;
	len = (int)ov_time_total(&vf,-1);
		return len;
}

const char* OggInfo::getLengthChar()
{
	int min, sec;
	char buf[6];
	char* lengthchar;

	min=getLength()/60;
	sec=getLength()%60;
  /*   if (sec < 10)
          sprintf (buf, "%d:0%d", min, sec);
     else   */
	     sprintf (buf, "%d:%02d", min, sec);
	lengthchar=strdup (buf);
	return lengthchar;
}

const char* OggInfo::getTitle()
{
	const char* title;
	char tag[] = "title";

	/*title = vorbis_comment_query(vc, tag, 0);*/
	if (vc && (title = vorbis_comment_query(vc,tag,0)) != NULL )
		return convert_from_utf8(title);
	else
		return "";
}

const char* OggInfo::getArtist()
{
	char* artist;
	char tag[] = "artist";

	if (vc && (artist = vorbis_comment_query(vc, tag, 0)) != NULL )
		return convert_from_utf8(artist);
	else
		return "";
}

const char* OggInfo::getAlbum()
{
	char* album;
	char tag[] = "album";

	if (vc && (album = vorbis_comment_query(vc,tag,0)) != NULL )
		return convert_from_utf8(album);
	else
		return "";
}

const char* OggInfo::getYear()
{
	char* year;
	char tag[] = "date";

	if (vc && (year = vorbis_comment_query(vc, tag, 0)) != NULL )
		return convert_from_utf8(year);
	else
		return "";
}

const char* OggInfo::getTrack()
{
	char* track;
	char tag[] = "tracknumber";

	if (vc && (track = vorbis_comment_query(vc, tag, 0)) != NULL )
		return convert_from_utf8(track);
	else
		return "";
}

const char* OggInfo::getComment()
{
char* string=NULL, *string1=NULL;
char tag[] = "comment", tag1[] = "";

	if (vc && (string  = vorbis_comment_query(vc,tag,0)) != NULL   // Winamp format
      || (string1 = vorbis_comment_query(vc,tag1,0))        != NULL ) // Xmms format
    {
        if (string && strlen(string)>0/* && !string1*/)
        {
            string = convert_from_utf8(string);
						cerr << "Comment 1 " << string << endl;
						return string;
        }else if (/*!string && */string1 && strlen(string1)>0 )
        {
            string1 = convert_from_utf8(string1);
							cerr << "Comment 2 " << string << endl;
						return string1;
        }/*else
        {
            string = convert_from_utf8(string);
						cerr << "Comment 3 " << string << endl;
						return string;
        }*/
    }
	/*char* track;

	if ( (track = vorbis_comment_query(vc,"track",0)) != NULL )
		return track;
	else*/
		return "";
}

int OggInfo::getGenre()
{
	char* genre;
	int num = 255;
	char tag[] = "genre";

	if (vc && (genre = vorbis_comment_query(vc, tag, 0)) != NULL )
	{
		genre = convert_from_utf8(genre);
		cerr << "Genre: " << genre << endl;
		/*num = (((0xFF) < atoi(genre)) ? (0xFF) : atoi(genre));*/
		for (int i=0; i<GENRE_MAX; i++)
			if (strcmp(genre, genre_list[i])==0)
			{
				num = i;
				break;
			}
		cerr << "Num : " << num<< endl;
		return num;
	}

	return 255;
}

const char* OggInfo::getGenre(int numgen)
{
	if (numgen < GENRE_MAX && numgen>=0)
		return genre_list[numgen];

	return "";
}

const char* OggInfo::getGenreC()
{
	int genre;

	genre = getGenre();
    if (genre < GENRE_MAX && genre>=0)
        return genre_list[genre];
    return "";
}

char* OggInfo::get_current_charset(void)
{
	char *charset = getenv("CHARSET");

#ifdef HAVE_CODESET
	if (!charset)
		charset = nl_langinfo(CODESET);
#endif
	if (!charset)
		charset = strdup("ISO-8859-1");

	return charset;
}


#ifdef HAVE_ICONV_OPEN
char* OggInfo::convert_string(const char *string, char *from, char *to)
{
	size_t outleft, outsize, length;
	iconv_t cd;
	char *out, *outptr;
	const char *input = string;

	if (!string)
		return NULL;

	length = strlen(string);

	if ((cd = iconv_open(to, from)) == (iconv_t)-1)
	{
		cerr << "convert_string(): Conversion not supported. Charsets: " << from << " -> " << to << endl;
		return /*strdup(*/string/*)*/;
	}

	/* Due to a GLIBC bug, round outbuf_size up to a multiple of 4 */
	/* + 1 for nul in case len == 1 */
	outsize = ((length + 3) & ~3) + 1;
	out = malloc(outsize);
	outleft = outsize - 1;
	outptr = out;

 retry:
	if (iconv(cd, &input, &length, &outptr, &outleft) == -1)
	{
		int used;
		switch (errno)
		{
			case E2BIG:
				used = outptr - out;
				outsize = (outsize - 1) * 2 + 1;
				out = realloc(out, outsize);
				outptr = out + used;
				outleft = outsize - 1 - used;
				goto retry;
			case EINVAL:
				break;
			case EILSEQ:
				/* Invalid sequence, try to get the
                                   rest of the string */
				input++;
				length = strlen(input);
				goto retry;
			default:
				cerr << "convert_string(): Conversion failed. Inputstring: " << string << " " << strerror(errno);
				break;
		}
	}
	*outptr = '\0';

	iconv_close(cd);
	return out;
}

#else

char* OggInfo::convert_string(const char *string, char *from, char *to)
{
	from = to = NULL;
	return strdup(string);
}

#endif

char* OggInfo::convert_to_utf8(const char *string)
{
	char utf8[] = "UTF-8";
	char *charset = get_current_charset();

	return convert_string(string, charset, utf8);
}


char* OggInfo::convert_from_utf8(const char *string)
{
	char utf8[] = "UTF-8";
	char *charset = get_current_charset();

	return convert_string(string, utf8, charset);
}
