
/*
 * @(#)base.c 1.2 01/01/18
 *
 * Copyright (c) Rich Burridge. All rights reserved.
 *
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 *
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "mptool.h"
#include "interface.h"

char *filenames;              /* List of file(s) to print. */

static void get_main_vals(void);


void
Base (void)
{
    filenames = NULL;
}


void
do_print_files (void)
{
    char *names = get_str_value(F_MAIN, "filename");

    do_print_cmd(names);
}


void
do_reset_options (void)
{
    set_excl_value(F_MAIN, "file_type_mail");
    if (int_opt_val(O_ARTICLE)) {
        set_excl_value(F_MAIN, "file_type_news");
    } else if (int_opt_val(O_PRINT_PS)) {
        set_excl_value(F_MAIN, "file_type_post");
    } else if (int_opt_val(O_TEXTDOC)) {
        set_excl_value(F_MAIN, "file_type_text");
    }

    set_excl_value(F_MAIN, "output_port");
    if (int_opt_val(O_LANDSCAPE)) {
        set_excl_value(F_MAIN, "output_land");
    } else if (!EQUAL(ptype, PRO_NORMAL)) {
        set_excl_value(F_MAIN, "output_perorg");
    }

    set_excl_value(F_MAIN, "filofax");

    if (EQUAL(ptype, PRO_FRANKLIN)) {
        set_excl_value(F_MAIN, "franklin");
    } else if (EQUAL(ptype, PRO_PRO_PLAN)) {
        set_excl_value(F_MAIN, "proplan");
    } else if (EQUAL(ptype, PRO_TIME_MANAGER)) {
        set_excl_value(F_MAIN, "time_manager");
    } else if (EQUAL(ptype, PRO_TS_INTL)) {
        set_excl_value(F_MAIN, "time_system__intl_");
    } else if (EQUAL(ptype, PRO_TS_PARTNER)) {
        set_excl_value(F_MAIN, "time_system__partner_");
    }

    if (paper_size == P_A4) {
        set_excl_value(F_MAIN, "paper_size_a4");
    } else if (paper_size == P_US) {
        set_excl_value(F_MAIN, "paper_size_us");
    }
 
    set_str_value(F_MAIN, "subject",  str_opt_val(O_GSUBJECT));
    set_int_value(F_MAIN, "copies",   int_opt_val(O_COPIES));
    set_str_value(F_MAIN, "filename", filenames);
 
    if (int_opt_val(O_DUPLEX)) {
        set_excl_value(F_MAIN, "no_sides_single");
    } else {
        set_excl_value(F_MAIN, "no_sides_double");
    }
}


void
do_save_defaults(void)
{
    get_main_vals();
    write_resources();
}


void
do_show_file(void)
{
    if (file_widget == NULL) {
        file_widget = create_file_widget();
    }

    gtk_widget_show(file_widget);
}


static void
get_main_vals(void)
{
    set_int_opt_val(O_ARTICLE,   get_bool_value(F_MAIN, "file_type_news"));
    set_int_opt_val(O_PRINT_PS,  get_bool_value(F_MAIN, "file_type_post"));
    set_int_opt_val(O_TEXTDOC,   get_bool_value(F_MAIN, "file_type_text"));
    set_str_opt_val(O_GSUBJECT,  get_str_value(F_MAIN,  "subject"));
    set_int_opt_val(O_COPIES,    get_int_value(F_MAIN,  "copies"));
    set_int_opt_val(O_DUPLEX,    get_bool_value(F_MAIN, "no_sides_double"));
    set_int_opt_val(O_LANDSCAPE, get_bool_value(F_MAIN, "output_land"));

    if (int_opt_val(O_LANDSCAPE)) {
        ptype = PRO_LANDSCAPE;
    } else {
        ptype = PRO_NORMAL;
    }

    if (get_bool_value(F_MAIN, "output_perorg")) {
        if (get_bool_value(F_MAIN, "filofax")) {
            ptype = PRO_FILOFAX;
        } else if (get_bool_value(F_MAIN, "franklin")) {
            ptype = PRO_FRANKLIN;
        } else if (get_bool_value(F_MAIN, "proplan")) {
            ptype = PRO_PRO_PLAN;
        } else if (get_bool_value(F_MAIN, "time_manager")) {
            ptype = PRO_TIME_MANAGER;
        } else if (get_bool_value(F_MAIN, "time_system__intl_")) {
            ptype = PRO_TS_INTL;
        } else if (get_bool_value(F_MAIN, "time_system__partner_")) {
            ptype = PRO_TS_PARTNER;
        }
    }

    if (get_bool_value(F_MAIN, "paper_size_a4")) {
        paper_size = P_A4;
    } else if (get_bool_value(F_MAIN, "paper_size_us")) {
        paper_size = P_US;
    } else {
        paper_size = P_NONE;
    }
}
