
/*
 * @(#)print.h 1.2 01/01/23
 * 
 * Copyright (c) Steve Holden and Rich Burridge. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __MP_PRINT_H__
#define __MP_PRINT_H__

#define  EQUALN(a, b)   (*a == *b && !strncmp(a, b, strlen(b)))

#define  MAXTTYPES      4        /* Maximum number of text types. */

enum action_type {
    IS_COL, IS_FILE, IS_LINE, IS_PAGE
};
enum text_type {
    T_BOLD, T_MIXED, T_PLAIN, T_ROMAN
};

extern FILE *makecmd               (char *);

extern char *current_filename      (void);

extern void End                    (enum action_type);
extern void Print                  (void);
extern void print_extra            (void);
extern void set_column_count       (int);
extern void set_current_filename   (char *);
extern void set_line_count         (int);
extern void set_message_for        (char *);
extern void set_output             (FILE *);
extern void set_page_number        (int);
extern void show_prologue          (char *);
extern void show_text              (enum text_type, char *, char *);
extern void show_trailer           (void);
extern void Start                  (enum action_type);
extern void write_output           (char *);

#endif /* __MP_PRINT_H__ */
