
/*
 * @(#)text2latex.c 1.2 01/01/23
 * 
 * Copyright (c) Mikael Cam. All rights reserved.
 * 
 * This software is free software; you can redistribute it and/or modify it
 * under the terms of the GNU Library General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 * 
 * This software is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
 * License for more details.
 * 
 * You should have received a copy of the GNU Library General Public License
 * along with this software; if not, write to the Free Software Foundation,
 * Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

/*
 * if the source document contains the string:  \end{verbatimtab} converts it
 * into \end{verbatimtab }, which is not correct but doesn't fail with
 * LaTeX...
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "../../common/option.h"

static int _TRACE = 0;

#define T(toto) (void) fprintf(stderr, "%s\n", toto)
#define True    1
#define False   0

static char *usage = "Usage: text2latex [input_file] (else stdin)\n";

static int 
convert(char *filename)
{
    char *ERR[] = {
        "Erreur lors de l'ouverture du fichier source\n"
    };

    char *corresp[] = {
        "\\end{verbatimtab}", "\\end{verbatimtab }",
        NULL, NULL
    };

    FILE *fp;
    char carcour, buffer[256], Trouve;
    int  buf_ind = 0;
    int  ind = 0;

/*
 *  if (_TRACE) {
 *      for ( i = 0; corresp[i]; i++) {
 *          printf("%s\n", corresp[i]);
 *      }
 *  }
 */

    if (!strcmp(filename, "stdin")) {
        fp = stdin;
    } else if (!(fp = fopen(filename, "r"))) {
        FPRINTF(stderr, "%s", ERR[0]);
        return(1);
    }
    if (_TRACE) {
        T("Fichier ouvert!");
    }

    while ((fscanf(fp, "%c", &carcour)) != EOF) {
        if (buf_ind < 254) {
            *(buffer + buf_ind) = carcour;
            *(buffer + buf_ind + 1) = '\0';
            buf_ind++;
            if (_TRACE) {
                FPRINTF(stderr, "buffer: %s\n", buffer);
            }
        } else {
            (void) fprintf(stdout, "%s", buffer);
            buf_ind = 0;
            *buffer = carcour;
            *(buffer + 1) = '\0';
        }

        Trouve = False;
        if (_TRACE) {
            FPRINTF(stderr, "Indice: %d\n", ind);
        }

        if (!strncmp(corresp[ind], buffer, strlen(buffer))) {
            Trouve = True;
        } else {
            ind = 0;

            while ((corresp[ind]) && (!Trouve)) {
                if (!strncmp(corresp[ind], buffer, strlen(buffer))) {
                    Trouve = True;
                }
                if (!Trouve) {
                    ind += 2;
                }
            }
        }

        if (!Trouve) {
            FPRINTF(stdout, "%s", buffer);
            buf_ind = 0;
            ind = 0;
        }
        if ((Trouve) && (!strcmp(corresp[ind], buffer))) {
            FPRINTF(stdout, "%s", corresp[ind + 1]);
            buf_ind = 0;
        }
    }

    return(0);
}


int 
main(int argc, char *argv[])
{
    char fichier[50];

    switch (argc) {
        case 1:
            STRCPY(fichier, "stdin");
            break;
        case 2:
            STRCPY(fichier, argv[1]);
            break;
        default:
            FPRINTF(stderr, "%s", usage);
            exit(1);
    }

    return(convert(fichier));
}
