/*
 * Decompiled with CFR 0.152.
 */
package com.jclark.xsl.sax;

import com.jclark.xsl.sax.OutputStreamConverter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import org.xml.sax.AttributeList;
import org.xml.sax.DocumentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class NXMLOutputHandler
implements DocumentHandler,
OutputStreamConverter {
    Writer writer;
    private OutputStream out;
    private final char[] chBuf = new char[1];
    final String lineSeparator = System.getProperty("line.separator");
    String[] escapes = new String[128];
    private final EscapeCharacterHandler escapeCharacterHandler = new EscapeCharacterHandler();
    private final CharacterHandler ignoreCharacterHandler = new CharacterHandler();
    private final CharacterHandler dataCharacterHandler = new DataCharacterHandler();
    private CharacterHandler controlCharacterHandler;
    private CharacterHandler characterHandler;
    private int depth = 0;
    private CharacterHandler[] characterHandlers = new CharacterHandler[1];

    public void pop() {
        this.characterHandler = this.characterHandlers[this.depth += -1];
    }

    public void ignorableWhitespace(char[] cArray, int n, int n2) throws SAXException {
        this.characters(cArray, n, n2);
    }

    public void startElement(String string, AttributeList attributeList) throws SAXException {
        String string2;
        if (string.equals("control")) {
            this.push(this.controlCharacterHandler);
            return;
        }
        if (string.equals("data")) {
            this.push(this.dataCharacterHandler);
            return;
        }
        if (string.equals("escape")) {
            this.escapeCharacterHandler.setChar(attributeList.getValue("char"));
            this.push(this.escapeCharacterHandler);
            return;
        }
        if (string.equals("char")) {
            String string3 = attributeList.getValue("number");
            if (string3 != null) {
                try {
                    int n = Integer.parseInt(string3);
                    if (n >= 0 && n < 65536) {
                        this.chBuf[0] = (char)n;
                        this.characters(this.chBuf, 0, 1);
                        return;
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    return;
                }
            }
        } else if (string.equals("nxml") && (string2 = attributeList.getValue("encoding")) != null && this.writer == null) {
            try {
                this.writer = new BufferedWriter(new OutputStreamWriter(this.out, string2));
                return;
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new SAXException("unsupported encoding");
            }
        }
    }

    public void startDocument() {
    }

    public void endElement(String string) throws SAXException {
        if (string.equals("control") || string.equals("data")) {
            this.pop();
            return;
        }
        if (string.equals("escape")) {
            this.escapeCharacterHandler.endChar();
            this.pop();
        }
    }

    public NXMLOutputHandler() {
        this.characterHandler = this.ignoreCharacterHandler;
        if (!this.lineSeparator.equals("\n")) {
            this.escapes[10] = this.lineSeparator;
            this.controlCharacterHandler = new LineControlCharacterHandler();
            return;
        }
        this.controlCharacterHandler = new ControlCharacterHandler();
    }

    public void setOutputStream(OutputStream outputStream) {
        this.out = outputStream;
    }

    public void push(CharacterHandler characterHandler) {
        if (this.depth >= this.characterHandlers.length) {
            CharacterHandler[] characterHandlerArray = this.characterHandlers;
            this.characterHandlers = new CharacterHandler[characterHandlerArray.length * 2];
            System.arraycopy(characterHandlerArray, 0, this.characterHandlers, 0, characterHandlerArray.length);
        }
        this.characterHandlers[this.depth++] = this.characterHandler;
        this.characterHandler = characterHandler;
    }

    public void endDocument() throws SAXException {
        try {
            if (this.writer != null) {
                this.writer.close();
                return;
            }
            this.out.close();
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void characters(char[] cArray, int n, int n2) throws SAXException {
        if (this.writer == null) {
            this.writer = new BufferedWriter(new OutputStreamWriter(this.out));
        }
        try {
            this.characterHandler.characters(cArray, n, n2);
            return;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String string, String string2) {
    }

    class CharacterHandler {
        CharacterHandler() {
            NXMLOutputHandler.this.getClass();
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
        }
    }

    class EscapeCharacterHandler
    extends CharacterHandler {
        private int c;
        private StringBuffer buf;

        void setChar(String string) {
            this.buf.setLength(0);
            if (string.length() == 0) {
                this.c = -1;
                return;
            }
            this.c = string.charAt(0);
        }

        EscapeCharacterHandler() {
            NXMLOutputHandler.this.getClass();
            this.buf = new StringBuffer();
        }

        void endChar() {
            if (this.c >= 0) {
                if (this.c >= NXMLOutputHandler.this.escapes.length) {
                    int n = NXMLOutputHandler.this.escapes.length;
                    while ((n *= 2) <= this.c) {
                    }
                    String[] stringArray = NXMLOutputHandler.this.escapes;
                    NXMLOutputHandler.this.escapes = new String[n];
                    System.arraycopy(stringArray, 0, NXMLOutputHandler.this.escapes, 0, stringArray.length);
                }
                NXMLOutputHandler.this.escapes[this.c] = this.buf.toString();
            }
        }

        void characters(char[] cArray, int n, int n2) {
            while (n2 > 0) {
                if (cArray[n] == '\n') {
                    this.buf.append(NXMLOutputHandler.this.lineSeparator);
                } else {
                    this.buf.append(cArray[n]);
                }
                ++n;
                --n2;
            }
        }
    }

    class DataCharacterHandler
    extends CharacterHandler {
        DataCharacterHandler() {
            NXMLOutputHandler.this.getClass();
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            String[] stringArray = NXMLOutputHandler.this.escapes;
            int n3 = n;
            while (n2 > 0) {
                String string;
                char c = cArray[n];
                if (c < stringArray.length && (string = stringArray[c]) != null) {
                    if (n3 != n) {
                        NXMLOutputHandler.this.writer.write(cArray, n3, n - n3);
                    }
                    NXMLOutputHandler.this.writer.write(string);
                    n3 = n + 1;
                }
                ++n;
                --n2;
            }
            if (n3 != n) {
                NXMLOutputHandler.this.writer.write(cArray, n3, n - n3);
            }
        }
    }

    class LineControlCharacterHandler
    extends CharacterHandler {
        LineControlCharacterHandler() {
            NXMLOutputHandler.this.getClass();
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            int n3 = n;
            while (n2 > 0) {
                if (cArray[n] == '\n') {
                    if (n3 != n) {
                        NXMLOutputHandler.this.writer.write(cArray, n3, n - n3);
                    }
                    NXMLOutputHandler.this.writer.write(NXMLOutputHandler.this.lineSeparator);
                    n3 = n + 1;
                }
                ++n;
                --n2;
            }
            if (n3 != n) {
                NXMLOutputHandler.this.writer.write(cArray, n3, n - n3);
            }
        }
    }

    class ControlCharacterHandler
    extends CharacterHandler {
        ControlCharacterHandler() {
            NXMLOutputHandler.this.getClass();
        }

        void characters(char[] cArray, int n, int n2) throws IOException {
            NXMLOutputHandler.this.writer.write(cArray, n, n2);
        }
    }
}

