AC_DEFUN(AC_CHECK_MOWITZ,
[
AC_CHECK_LIB(m, ceil)
dnl We want to use gmatch where fnmatch is not available
AC_CHECK_FUNC(fnmatch, AC_DEFINE(HAVE_FNMATCH),
	[AC_CHECK_LIB(gen, gmatch)
	AC_CHECK_FUNC(gmatch, AC_DEFINE(HAVE_GMATCH))])

AC_CHECK_LIB(X11, XCreateIC, AC_DEFINE(HAVE_XCREATEIC), , $X_LIBS $x_libs)
AC_ARG_ENABLE(debugging,
	[  --enable-debugging      enable debugging],
	[ if test "$withval" != "no"; then
		CFLAGS="$CFLAGS -g"
	fi ])
AC_ARG_ENABLE(profiling,
	[  --enable-profiling      enable profiling],
	[ if test "$withval" != "no"; then
		CFLAGS="$CFLAGS -pg"
	fi ])
AC_ARG_WITH(xawm,
	[  --with-xawm             choose XawM compatible library (default XawM)],
	[ case $withval in
	yes | no )
		XAWLIB=-lXawM
		;;
	* )
		XAWLIB=-l$withval
		;;
	esac ])

if test "$XAWLIB" = ""; then
	XAWLIB="-lXawM"
fi
AC_SUBST(XAWLIB)
if test "$GCC" = "yes"; then
	CFLAGS="-Wall $CFLAGS"
fi
dnl Look for T1lib including its X part
AC_ARG_WITH(t1lib,
	[  --with-t1lib            enable t1lib],
	[ if test "$withval" != "no"; then
		AC_CHECK_LIB(t1, main, LIBT1="-lt1")
		if test "$LIBT1" != ""; then
			AC_DEFINE(HAVE_LIB_T1)
		fi
		AC_CHECK_LIB(t1x, main, LIBT1X="-lt1x", , $LIBT1 $X_LIBS -lX11)
		if test "$LIBT1X" != ""; then
			AC_DEFINE(HAVE_LIB_T1X)
		fi
	fi ])


AC_SUBST(CFLAGS_CFG)
AC_SUBST(LDFLAGS_CFG)
])
