#include "parserule.h"

#include <regex.h>

parserule::parserule() {
}

parserule::parserule(const string &atarget, const string &amask, messagekind akind = info) {
    string tmbuf;
    int npos;

    target = atarget;
    kind = akind;
    tmbuf = mask = amask;

    porder = getrword(mask);
    if(porder.find_first_not_of("INKLFDEW") != -1) {
	mask = tmbuf;
        porder = "";
    }

    while((npos = porder.find_first_of("EW")) != -1) {
	if(porder[npos] == 'E') kind = error; else
	if(porder[npos] == 'W') kind = warning;
	porder.erase(npos, 1);
    }
}

parserule::~parserule() {
}

bool parserule::exec(const string &buf) const {
    regex_t r;
    regmatch_t rm[10];
    bool ret = false;
    int i;

    if(!regcomp(&r, mask.c_str(), REG_EXTENDED)) {
	if(ret = !regexec(&r, buf.c_str(), 10, rm, 0)) {
            values.clear();
	    for(i = 1; (i < 10) && (rm[i].rm_so != -1); i++)
	        values.push_back(buf.substr(rm[i].rm_so,
                    rm[i].rm_eo-rm[i].rm_so));
        }

	regfree(&r);
    }

    return ret;
}

string parserule::getvalue(const string &n = "") const {
    string r;
    int npos = 0;

    if(!n.empty()) npos = porder.find(n);
    if(npos >= 0 && npos < values.size()) r = values[npos];

    return r;
}

parserule::messagekind parserule::getkind() const {
    return kind;
}

bool parserule::operator == (const pair<string, string> &ast) const {
    return ((target == ast.second) || target.empty()) && exec(ast.first);
}

bool parserule::operator != (const pair<string, string> &ast) const {
    return !(*this == ast);
}
