/***************************************************************************
 *   Copyright (C) 2005 by Dmitry Nezhevenko                               *
 *   dionua@users.sf.net                                                   *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#ifndef FILELISTVIEW_H
#define FILELISTVIEW_H

#include <qlistview.h>

class FileListViewItem : public QListViewItem
{
public:
	FileListViewItem(QListView * parent, QString name, int id = 0,
			unsigned long size = 0, unsigned char owner = 0, unsigned char attr = 0) :
		QListViewItem(parent, name.section('/', -1),
			(name.find('.') > 0 ? name.section('.', -1) : QString::null),
			QString::number(size), QString::number(owner, 16), QString::number(attr, 16),
			QString::number(id), name) { };

	int compare (QListViewItem * i, int col, bool ascending) const;
};

#endif
