/*
  **
  ** conf.h - function prototypes for the config handling routines
  **
  ** Originally written for the dproxy package by Matthew Pratt.
  **
  ** Copyright 2000 Jeroen Vreeken (pe1rxq@chello.nl)
  **
  ** This software is licensed under the terms of the GNU General
  ** Public License (GPL). Please see the file COPYING for details.
  **
  **
*/

#ifndef _INCLUDE_CONF_H
#define _INCLUDE_CONF_H

extern int deamon;
extern int alarmtime;

/* 
    more parameters may be added later.
 */
struct config {
        int width;
        int height;
	int quality;
	int max_changes;
	int always_diff;
	int new_img;
	int motion_img;
	int snap_overwrite;
	int gap;
	int maxmpegtime;
	int locate;
	int input;
	int norm;
	int frame_limit;
	int mpeg;
        int quiet;
	int ppm;
	int noise;
	int mingap;
	int lightswitch;
	int jpg_cleanup;
	int nightcomp;
	int adjustrate;
	int realmotion;
	int oldlayout;
	int low_cpu;
	int nochild;
	int autobright;
	char *device;
	char *vidpipe;
	char *mail_address;
	char *sms_nr;
	char *filepath;
	char *externcommand;
	char *mask_file;
	char *mysql_db;
	char *mysql_host;
	char *mysql_user;
	char *mysql_password;
	char *onsavecommand;
	char *onmpegcommand;
	char *axis;
	char *motionvidpipe;
	char *realconfig;
	char *netcam_userpass;
	char *netcam_path;
	int argc;
	char **argv;
};

extern struct config conf;

/** 
 * typedef for a param copy function. 
 */
typedef void (* conf_copy_func)(char *, void *) ;

/**
 * description for parameters in the config file
 */
typedef struct {
  char * param_name;         /* name for this parameter             */
  void * conf_value;         /* pointer to a field in struct config */
  conf_copy_func  copy;      /* a function to set the value in 'config'*/
} config_param; 


extern struct config config;
int conf_load (void);
void conf_process (FILE *fp);

#endif
