/*
 * Copyright (c) 2000, 2001, Amnon BARAK (amnon@cs.huji.ac.il).
 * All rights reserved.
 *
 *       MOSIX $Id: dadvise.c,v 1.9 2001/12/24 21:55:19 amnons Exp $
 *
 * THIS SOFTWARE IS PROVIDED IN ITS "AS IS" CONDITION, WITH NO WARRANTY
 * WHATSOEVER. NO LIABILITY OF ANY KIND FOR ANY DAMAGES WHATSOEVER RESULTING
 * FROM THE USE OF THIS SOFTWARE WILL BE ACCEPTED.
 */
/*
 * Author(s): Ariel Rosenblatt, Amnon Shiloh
 * Code derived from previous work by Amnon Shiloh and Oren Laadan.
 */

#include "mos.h"

int
dadvise(int advice, int interval, int keep) 
{
	int policy, opts;
	int res;

	policy = advice & DADV_POLICY;
	errno = EINVAL;

	switch (policy)
	{
		case DADV_CPU:
			res = msx_write("/proc/mosix/decay/cpujob", 1);
			break;
		case DADV_NOCPU:
			res = msx_write("/proc/mosix/decay/iojob", 1);
			break;
		case DADV_NODECAY: 
			res = msx_write2("/proc/mosix/decay/own",
							DECAY_QUOTIENT, 1);
			break;
		case DADV_SLOWDECAY:
			res = msx_write("/proc/mosix/decay/slow", 1);
			break;
		case DADV_FASTDECAY:
			res = msx_write("/proc/mosix/decay/fast", 1);
			break;
		case DADV_OWNDECAY: 
			if (keep < 0 || keep > DECAY_QUOTIENT ||
					interval <= 0 || interval > 65535)
				return -1;
			res = msx_write2("/proc/mosix/decay/own",
								keep, interval);
			break;
		case 0:
			res = 0;
			break;
		default: 
			return(-1);
	}
	
	if (res == -1)
		return(res);

	opts = advice & ~DADV_POLICY;

	if((opts & (DADV_INHERIT|DADV_NOINHERIT)) ==
						(DADV_INHERIT|DADV_NOINHERIT))
		return(-1);
	if((opts & (DADV_EXEC|DADV_NOEXEC)) == (DADV_EXEC|DADV_NOEXEC))
		return(-1);
	if((opts & (DADV_EXECONCE|DADV_NOEXECONCE)) ==
						(DADV_EXECONCE|DADV_NOEXECONCE))
		return(-1);

	if (opts & DADV_CLEAR && msx_write("/proc/mosix/decay/clear", 1) == -1)
		return -1;

	if ((opts & DADV_INHERIT) &&
				msx_write("/proc/mosix/decay/inherit", 1) == -1)
		return -1;
	if ((opts & DADV_NOINHERIT) &&
				msx_write("/proc/mosix/decay/inherit", 0) == -1)
		return -1;
	if ((opts & DADV_EXEC) && msx_write("/proc/mosix/decay/exec", 1) == -1)
		return -1;
	if ((opts & DADV_NOEXEC) &&
				msx_write("/proc/mosix/decay/exec", 0) == -1)
		return -1;
	if ((opts & DADV_EXECONCE) &&
			msx_write("/proc/mosix/decay/execonce", 1) == -1)
		return -1;
	if ((opts & DADV_NOEXECONCE) &&
			msx_write("/proc/mosix/decay/execonce", 1) == -1)
		return -1;

	return 0;
}
