# -*- coding: utf-8 -*-
# Moovida - Home multimedia server
# Copyright (C) 2006-2009 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Moovida with Fluendo's plugins.
#
# The GPL part of Moovida is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Moovida" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


class Singleton(object):

    """
    Implements the Singleton pattern.

    Every class inheriting from Singleton will have one and only one instance
    of its kind at any time.

    NOTE: uses __new__ which has been introduced in Python 2.2
    """

    __instance = None

    def __new__(cls, *args, **kwargs):
        if not cls.__instance:
            cls.__instance = object.__new__(cls, *args, **kwargs)

        return cls.__instance


#if __name__ == "__main__":
#    class ClassA(Singleton):
#        pass
#
#    class ClassB(ClassA):
#        pass
#
#    # There will be only one instance for ClassA and ClassB
#
#    class ClassC(Singleton):
#        pass
#
#    instance1 = ClassA()
#    instance2 = ClassA()
#    instance3 = ClassB()
#    instance4 = ClassB()
#
#    instance5 = ClassC()
#    instance6 = ClassC()
#
#    print "instance1 id=", id(instance1)
#    print "instance2 id=", id(instance2)
#    print "instance3 id=", id(instance3)
#    print "instance4 id=", id(instance4)
#
#    print "instance5 id=", id(instance5)
#    print "instance6 id=", id(instance6)
