/* sound.c - add esd-based sound support to moon-buggy
 *
 * Copyright (C) 2000  Jochen Voss.  */

static const  char  rcsid[] = "$Id$";

#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

#include <esd.h>

#include "moon-buggy.h"


static void
do_play (const char *file)
{
  esd_play_file (NULL, file, 0);
}

void
play_sound (enum event_type type)
{
  switch (type) {
  case mev_JUMP:
    do_play (SOUND_DIR "/jump.wav");
    break;
  case mev_LASER:
    do_play (SOUND_DIR "/laser.wav");
    break;
  case mev_CRASH:
    do_play (SOUND_DIR "/crash.wav");
    break;
  }
}
