# copyright (C) 1997-2001 Jean-Luc Fontaine (mailto:jfontain@free.fr)
# this program is free software: please read the COPYRIGHT file enclosed in this package or use the Help Copyright menu

set rcsId {$Id: myquery.tcl,v 2.5 2001/01/27 15:08:19 jfontain Exp $}


package provide myquery [lindex {$Revision: 2.5 $} 1]
if {[lsearch -exact $auto_path /usr/lib]<0} {                         ;# in case Tcl/Tk is somewhere else than in the /usr hierarchy
    lappend auto_path /usr/lib
}
if {[catch {package require Mytcl} message]} {
    error "$message\nMytcl package does not seem to be installed:\nget it at http://jfontain.free.fr/"
}


namespace eval myquery {

    array set data {
        updates 0
        0,label {} 0,type integer 0,message {row number in order of arrival}
        pollTimes {10 5 20 30 60 120 300}
        switches {--host 1 --password 1 --port 1 -q 1 --query 1 -t 1 --table 1 --user 1}
        sort {0 increasing}
    }
    set file [open myquery.htm]
    set data(helpText) [read $file]                                                           ;# initialize HTML help data from file
    close $file

    proc initialize {optionsName} {
        upvar $optionsName options
        variable host
        variable user
        variable connection
        variable data
        variable statement

        catch {set query $options(-q)}
        catch {set query $options(--query)}                                                                     ;# favor long option
        catch {set table $options(-t)}
        catch {set table $options(--table)}                                                                     ;# favor long option
        if {[info exists query]&&[info exists table]} {
            error {use either table or query option but not both}
        }
        if {[info exists query]} {
            set statement $query
        } elseif {[info exists table]} {
            set statement "select * from $table"
        } else {
            error {either query (-q (--query)) or table (-t (--table)) must be specified}
        }
        set arguments {}
        set host localhost                                                                                             ;# by default
        catch {set host $options(--host)}
        lappend arguments $host
        set user $::env(USER)                                                                                          ;# by default
        catch {set user $options(--user)}
        lappend arguments $user
        set password {}
        catch {set password $options(--password)}
        catch {lappend arguments $password}
        lappend arguments {}                                                                              ;# no preselected database
        set port 3306                                                                                                  ;# by default
        catch {set port $options(--port)}
        catch {lappend arguments $port}
        set data(identifier) myquery($host)
        set connection [eval sql connect $arguments]

        set query [sql query $connection $statement]
        set column 1
        foreach {name numeric type width decimals maximum} [sql fields $connection $query] {
            set data($column,label) $name
            if {$numeric} {
                set data($column,type) real                     ;# so that cell may be dropped in viewers that expect a numeric type
                if {$decimals>0} {
                    set data($column,message) "$name (${type}([expr {$width-$decimals}].$decimals))"
                } else {
                    set data($column,message) "$name (${type}($width))"
                }
            } else {
                set data($column,type) ascii
                set data($column,anchor) left
                set data($column,message) "$name (${type}($width))"
            }
            incr column
        }
        sql endquery $connection $query
    }

    proc update {} {
        variable connection
        variable statement
        variable data

        array unset data {[0-9]*,[0-9]*}                                                                    ;# clear data every time
        if {[catch {set query [sql query $connection $statement]} message]} {                             ;# problem reaching server
            flashMessage "myquery error: $message"
        } else {
            set row 0
            while {[llength [set list [sql fetchrow $connection $query]]]>0} {
                set data($row,0) $row
                set column 1
                foreach value $list {
                    set data($row,$column) $value
                    incr column
                }
                incr row
            }
            sql endquery $connection $query
        }
        incr data(updates)
    }

    proc terminate {} {
        variable connection
        catch {sql disconnect $connection}
    }

}
