/*
 * Decompiled with CFR 0.152.
 */
package sharpen.core;

import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.IBinding;
import sharpen.core.CSharpBuilder;
import sharpen.core.Configuration;
import sharpen.core.WarningHandler;
import sharpen.core.csharp.CSharpPrinter;
import sharpen.core.csharp.ast.CSCompilationUnit;
import sharpen.core.framework.ASTResolver;
import sharpen.core.framework.ASTUtility;
import sharpen.core.framework.Environment;
import sharpen.core.framework.Environments;

public class SharpenConversion {
    private CSharpPrinter _printer;
    protected ICompilationUnit _source;
    protected Writer _writer;
    protected final Configuration _configuration;
    private ASTResolver _resolver = new ASTResolver(){

        @Override
        public ASTNode findDeclaringNode(IBinding binding) {
            return null;
        }
    };

    public SharpenConversion(Configuration configuration) {
        this._configuration = configuration;
    }

    public void setSource(ICompilationUnit source) {
        this._source = source;
    }

    public void setTargetWriter(Writer writer) {
        this._writer = writer;
    }

    public Writer getTargetWriter() {
        return this._writer;
    }

    public void setPrinter(CSharpPrinter printer) {
        this._printer = printer;
    }

    private CSharpPrinter getPrinter() {
        if (this._printer == null) {
            this._printer = new CSharpPrinter();
        }
        return this._printer;
    }

    public Configuration getConfiguration() {
        return this._configuration;
    }

    protected void print(CSCompilationUnit unit) {
        this.printHeader();
        this.printTree(unit);
    }

    private void printHeader() {
        try {
            this._writer.write(this._configuration.header());
        }
        catch (IOException x) {
            throw new RuntimeException(x);
        }
    }

    private void printTree(CSCompilationUnit unit) {
        CSharpPrinter printer = this.getPrinter();
        printer.setWriter(this._writer);
        printer.print(unit);
    }

    protected CSCompilationUnit run(CompilationUnit ast) {
        this.processProblems(ast);
        this.prepareForConversion(ast);
        CSCompilationUnit cs = this.convert(ast);
        if (!cs.ignore() && !cs.types().isEmpty()) {
            this.print(cs);
        }
        return cs;
    }

    protected void processProblems(CompilationUnit ast) {
        ASTUtility.checkForProblems(ast, !this.ignoringErrors());
    }

    private CSCompilationUnit convert(CompilationUnit ast) {
        CSCompilationUnit compilationUnit = new CSCompilationUnit();
        Environment environment = Environments.newConventionBasedEnvironment(ast, this._configuration, this._resolver, compilationUnit);
        Environments.runWith(environment, new Runnable(){

            @Override
            public void run() {
                CSharpBuilder builder = new CSharpBuilder();
                builder.run();
            }
        });
        return compilationUnit;
    }

    private boolean ignoringErrors() {
        return this._configuration.getIgnoreErrors();
    }

    private void prepareForConversion(final CompilationUnit ast) {
        this.deleteProblemMarkers();
        WarningHandler warningHandler = new WarningHandler(){

            @Override
            public void warning(ASTNode node, String message) {
                SharpenConversion.this.createProblemMarker(ast, node, message);
                System.err.println(String.valueOf(SharpenConversion.this.getSourcePath()) + "(" + ASTUtility.lineNumber(ast, node) + "): " + message);
            }
        };
        this._configuration.setWarningHandler(warningHandler);
    }

    private void deleteProblemMarkers() {
        if (this.createProblemMarkers()) {
            try {
                this._source.getCorrespondingResource().deleteMarkers("sharpen.core.problem", false, 1);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        }
    }

    private void createProblemMarker(CompilationUnit ast, ASTNode node, String message) {
        if (!this.createProblemMarkers()) {
            return;
        }
        try {
            IMarker marker = this._source.getCorrespondingResource().createMarker("sharpen.core.problem");
            HashMap<String, Object> attributes = new HashMap<String, Object>();
            attributes.put("message", message);
            attributes.put("charStart", new Integer(node.getStartPosition()));
            attributes.put("charEnd", new Integer(node.getStartPosition() + node.getLength()));
            attributes.put("transient", Boolean.TRUE);
            attributes.put("severity", 1);
            attributes.put("lineNumber", ASTUtility.lineNumber(ast, node));
            marker.setAttributes(attributes);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
    }

    private boolean createProblemMarkers() {
        return this._configuration.createProblemMarkers();
    }

    private String getSourcePath() {
        try {
            return this._source.getCorrespondingResource().getFullPath().toString();
        }
        catch (JavaModelException e) {
            e.printStackTrace();
            return "";
        }
    }

    public ASTResolver getASTResolver() {
        return this._resolver;
    }

    public void setASTResolver(ASTResolver resolver) {
        this._resolver = resolver;
    }
}

