//
// Tests for System.Web.UI.WebControls.AutoGeneratedField.cs
//
// Author:
//	Yoni Klein (yonik@mainsoft.com)
//
//
// Copyright (C) 2005 Novell, Inc (http://www.novell.com)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.


#if NET_2_0


using System;
using System.Collections.Generic;
using System.Text;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.IO;
using System.Drawing;
using System.Collections;
using System.Collections.Specialized;
using NUnit.Framework;




namespace MonoTests.System.Web.UI.WebControls
{
	
	[TestFixture]
	public class AutoGeneratedFieldTest
	{
		[Test]
		public void AutoGeneratedField_DefaultProperty ()
		{
			AutoGeneratedField field = new AutoGeneratedField ("test");
			Assert.AreEqual (true, field.ConvertEmptyStringToNull, "ConvertEmptyStringToNull");
			Assert.AreEqual (string.Empty, field.DataFormatString, "DataFormatString");
			Assert.AreEqual (true, field.InsertVisible, "InsertVisible");
		}

		[Test]
		public void AutoGeneratedField_DefaultPropertyNotWorking ()
		{
			AutoGeneratedField field = new AutoGeneratedField ("test");
			Assert.AreEqual (typeof (String), field.DataType, "DataType");
		}

		[Test]
		public void AutoGeneratedField_AssignProperty ()
		{
			AutoGeneratedField field = new AutoGeneratedField ("test");
			Assert.AreEqual ("test", field.DataField, "DataField");
			field.DataType = typeof (bool);
			Assert.AreEqual (typeof (bool), field.DataType, "DataType");
		}

		[Test]
		public void AutoGeneratedField_ExtractValuesFromCell()
		{
			AutoGeneratedField field = new AutoGeneratedField ("field");
			OrderedDictionary dictionary = new OrderedDictionary ();
			DataControlFieldCell cell = new DataControlFieldCell (null);
			cell.Text = "cell";
			field.ExtractValuesFromCell (dictionary, cell, DataControlRowState.Normal, true);
			Assert.AreEqual (1, dictionary.Count, "ExtractValuesFromCellCount");
			Assert.AreEqual ("cell", dictionary[0].ToString (), "ExtractValuesFromCellValue");
		}

		[Test]
		public void AutoGeneratedField_ExtractValuesFromCellCheckbox ()
		{
			// Aditional implementation for bollean data type

			AutoGeneratedField field = new AutoGeneratedField ("field");
			field.DataType = typeof (bool);
			OrderedDictionary dictionary = new OrderedDictionary ();
			DataControlFieldCell cell = new DataControlFieldCell(null);
			cell.Controls.Add (new CheckBox ());
			field.ExtractValuesFromCell (dictionary, cell, DataControlRowState.Normal, true);
			Assert.AreEqual (1, dictionary.Count, "ExtractValuesFromCellCount");
			Assert.AreEqual ("False", dictionary[0].ToString (), "ExtractValuesFromCellValue");
			CheckBox cb = new CheckBox ();
			cb.Checked = true;
			cell.Controls.Clear ();
			cell.Controls.Add (cb);
			field.ExtractValuesFromCell (dictionary, cell, DataControlRowState.Normal, true);
			Assert.AreEqual (1, dictionary.Count, "ExtractValuesFromCellCount");
			Assert.AreEqual ("True", dictionary[0].ToString (), "ExtractValuesFromCellValue");
		}

		[Test]
		public void AutoGeneratedField_ValidateSupportsCallback ()
		{
			//This method has been implemented as an empty method  
		}

		[Test]
		public void AutoGeneratedField_BoolArray () {
			GridView GridView1 = new GridView ();
			GridView1.DataSource = new bool [] { true };
			GridView1.DataBind ();
		}

		[Test]
		[ExpectedException(typeof(NotSupportedException))]
		public void AutoGeneratedField_ConvertEmptyStringToNullExeption ()
		{
			AutoGeneratedField field = new AutoGeneratedField ("test");
			field.ConvertEmptyStringToNull = false;	

		}

		[Test]
		[ExpectedException (typeof (NotSupportedException))]
		public void AutoGeneratedField_DataFormatStringExeption ()
		{
			AutoGeneratedField field = new AutoGeneratedField ("test");
			field.DataFormatString = "test";
		}

		[Test]
		[ExpectedException (typeof (NotSupportedException))]
		public void AutoGeneratedField_InsertVisibleExeption ()
		{
			AutoGeneratedField field = new AutoGeneratedField ("test");
			field.InsertVisible = false;
		}

	}
}
#endif