/* my-stuff.h


03/21
- updated version# to 1.41

02/20
- added bkpinfo->using_cdstream

02/06
- added MONDO_VERSION

02/02
- added MONDO_CFG_FILE
- added SLICE_SIZE

01/31
- removed MINDI_HOME: it is unnecessary
- replaced MONDO_HOME with variable g_mondo_home

01/25
- added MONDO_HOME, MINDI_HOME

01/21
- added s_node{} structure

01/17
- added sys/shm.h, types.h, ipc.h

01/02
- added that groovy bkpinfo{} stuff

11/29
- added raidlist{} struct

08/27
- stuff
*/

#include <sys/shm.h>
#include <sys/ipc.h>
#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <fcntl.h>
#include <getopt.h>
#include <errno.h>
#include <stddef.h>
#include <sys/stat.h>
#include <sys/wait.h>
#include <time.h>
#include <unistd.h>
#include <curses.h>
#include <newt.h>
#include <ctype.h>
#include <string.h>

#define MONDO_VERSION "1.41"


#define MONDO_CFG_FILE		"/tmp/mondo-restore.cfg"

#define CRC_M16	0xA001		/* crc-16 mask */
#define	CRC_MTT	0x1021		/* crc-ccitt mask */

#define FALSE 0
#define TRUE 1

#define SCREEN_LENGTH 25
#define NOOF_ERR_LINES 6
#define ARBITRARY_MAXIMUM 512 /* max items in mountlist, filelist editor window */
#define MAX_STR_LEN 512
#define MAXIMUM_RAID_DEVS 32
#define MAXIMUM_ADDITIONAL_RAID_VARS 32
#define MAXIMUM_DISKS_PER_RAID_DEV 32

#define MOUNTLIST_FNAME "/tmp/mountlist.txt"
#define RAIDTAB_FNAME "/etc/raidtab"

#define BLK_START_OF_BACKUP     1
#define BLK_START_OF_TAPE       2
#define BLK_START_AFIOBALLS	10
#define BLK_STOP_AFIOBALLS	19
#define BLK_START_AN_AFIO_OR_SLICE    	20
#define BLK_STOP_AN_AFIO_OR_SLICE	29
#define BLK_START_BIGGIEFILES	30
#define BLK_STOP_BIGGIEFILES	39
#define BLK_START_A_BIGGIE	40
#define BLK_STOP_A_BIGGIE	59
#define BLK_START_FILE          80
#define BLK_STOP_FILE           89
#define BLK_END_OF_TAPE         100
#define BLK_END_OF_BACKUP       101
#define BLK_ABORTED_BACKUP      102
#define TAPE_BLOCK_SIZE 8192  /* don't increase beyond 32767 for now, just in case */
#define MONDO_LOGFILE           "/var/log/mondo-archive.log"
#define TAPE_BUF_SIZE           1*1024
#define NOOF_TAPE_BUFS          4


struct mountlist_line {
  char device[64];
  char mountpoint[64];
  char format[64];
  long size;
};

struct mountlist_itself {
  int entries;
  struct mountlist_line el[ARBITRARY_MAXIMUM];
};

struct raid_var_line {
  char label[64];
  char value[64];
};

struct additional_raid_variables {
  int entries;
  struct raid_var_line el[MAXIMUM_ADDITIONAL_RAID_VARS];
};


struct s_disk {
  char device[MAX_STR_LEN];
  int index;
};

struct list_of_disks {
  int entries;
  struct s_disk el[MAXIMUM_DISKS_PER_RAID_DEV];
};

struct raid_device_record {
  char raid_device[64];
  int raid_level;
  int persistent_superblock;
  int chunk_size;
  struct list_of_disks data_disks;
  struct list_of_disks spare_disks;
  struct list_of_disks parity_disks;
  struct list_of_disks failed_disks;
  struct additional_raid_variables additional_vars;
};

struct raidlist_itself {
  int entries;
  struct raid_device_record el[MAXIMUM_RAID_DEVS];
};

struct s_bkpinfo {
  char media_device[MAX_STR_LEN];
  long media_size; /* in MB */
  char boot_loader; /* G = GRUB, L = LILO */
  char boot_device[MAX_STR_LEN]; /* e.g. /dev/hda */
  char zip_exe[MAX_STR_LEN]; /* e.g. lzop or bzip2 */
  char zip_suffix[MAX_STR_LEN]; /* e.g. lzo or bz2 */
  char image_devs[MAX_STR_LEN];
  int compression_level;
  bool use_lzo;
  char do_not_compress_these[MAX_STR_LEN];
  bool verify_data;
  bool backup_data;
  char isodir[MAX_STR_LEN];
  char scratchdir[MAX_STR_LEN];
  char tmpdir[MAX_STR_LEN];
  long optimal_set_size;
  bool using_tape;
  bool using_cdstream;
  char include_paths[MAX_STR_LEN];
  char exclude_paths[MAX_STR_LEN];
  char call_before_iso[MAX_STR_LEN];
  char call_make_iso[MAX_STR_LEN];
  char call_burn_iso[MAX_STR_LEN];
  char call_after_iso[MAX_STR_LEN];
  char kernel_path[MAX_STR_LEN];
  char nfs_mount[MAX_STR_LEN];
  char nfs_remote_dir[MAX_STR_LEN];
  char postnuke_tarball[MAX_STR_LEN];
  bool wipe_media_first;
  bool differential;
  int cdrw_speed;
};





struct s_shared_use {
  bool lock, keepalive, yes_child_is_dead;
  char info_string[MAX_STR_LEN];
  bool please_open_tape, please_close_tape, is_tape_open;
  char tapedev[MAX_STR_LEN];
  char *buffer[NOOF_TAPE_BUFS];
  int load_to_buffer_number, save_from_buffer_number;
  bool please_open_actual_output, please_close_actual_output;
  int fd_in, fd_out;
};


struct s_node {
  char ch;
  struct s_node *right;
  struct s_node *down;
  bool selected;
  bool expanded;
};



#define BIGGIELIST_TXT "/tmp/biggielist.txt"
#define FILELIST_FULL "/tmp/filelist.full"
#define BIGGIELIST_POT "/tmp/tmpfs/biggielist.pot"
#define FILELIST_POTENTIAL "/tmp/tmpfs/filelist.potential"
#define FILELIST_IMAGEDEVS "/tmp/tmpfs/filelist.imagedevs"
#define FILELIST_RESTTHESE "/tmp/tmpfs/filelist.restore-these"
#define BIGGIELIST_RESTTHESE "/tmp/tmpfs/biggielist.restore-these"
#define IMAGEDEVS_POT "/tmp/tmpfs/imagedevs.pot"
#define IMAGEDEVS_RESTTHESE "/tmp/tmpfs/imagedevs.restore-these"


#define SLICE_SIZE 8192



