"use strict";

var helpers = require("../../helpers/helpers");

exports["Brazil/East"] = {

	"guess:by:offset" : helpers.makeTestGuess("Brazil/East", { offset: true, expect: "America/Sao_Paulo" }),

	"guess:by:abbr" : helpers.makeTestGuess("Brazil/East", { abbr: true, expect: "America/Sao_Paulo" }),

	"1931" : helpers.makeTestYear("Brazil/East", [
		["1931-10-03T13:59:59+00:00", "10:59:59", "-03", 180],
		["1931-10-03T14:00:00+00:00", "12:00:00", "-02", 120]
	]),

	"1932" : helpers.makeTestYear("Brazil/East", [
		["1932-04-01T01:59:59+00:00", "23:59:59", "-02", 120],
		["1932-04-01T02:00:00+00:00", "23:00:00", "-03", 180],
		["1932-10-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["1932-10-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1933" : helpers.makeTestYear("Brazil/East", [
		["1933-04-01T01:59:59+00:00", "23:59:59", "-02", 120],
		["1933-04-01T02:00:00+00:00", "23:00:00", "-03", 180]
	]),

	"1949" : helpers.makeTestYear("Brazil/East", [
		["1949-12-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1949-12-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1950" : helpers.makeTestYear("Brazil/East", [
		["1950-04-16T02:59:59+00:00", "00:59:59", "-02", 120],
		["1950-04-16T03:00:00+00:00", "00:00:00", "-03", 180],
		["1950-12-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1950-12-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1951" : helpers.makeTestYear("Brazil/East", [
		["1951-04-01T01:59:59+00:00", "23:59:59", "-02", 120],
		["1951-04-01T02:00:00+00:00", "23:00:00", "-03", 180],
		["1951-12-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1951-12-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1952" : helpers.makeTestYear("Brazil/East", [
		["1952-04-01T01:59:59+00:00", "23:59:59", "-02", 120],
		["1952-04-01T02:00:00+00:00", "23:00:00", "-03", 180],
		["1952-12-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1952-12-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1953" : helpers.makeTestYear("Brazil/East", [
		["1953-03-01T01:59:59+00:00", "23:59:59", "-02", 120],
		["1953-03-01T02:00:00+00:00", "23:00:00", "-03", 180]
	]),

	"1963" : helpers.makeTestYear("Brazil/East", [
		["1963-10-23T02:59:59+00:00", "23:59:59", "-03", 180],
		["1963-10-23T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1964" : helpers.makeTestYear("Brazil/East", [
		["1964-03-01T01:59:59+00:00", "23:59:59", "-02", 120],
		["1964-03-01T02:00:00+00:00", "23:00:00", "-03", 180]
	]),

	"1965" : helpers.makeTestYear("Brazil/East", [
		["1965-01-31T02:59:59+00:00", "23:59:59", "-03", 180],
		["1965-01-31T03:00:00+00:00", "01:00:00", "-02", 120],
		["1965-03-31T01:59:59+00:00", "23:59:59", "-02", 120],
		["1965-03-31T02:00:00+00:00", "23:00:00", "-03", 180],
		["1965-12-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1965-12-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1966" : helpers.makeTestYear("Brazil/East", [
		["1966-03-01T01:59:59+00:00", "23:59:59", "-02", 120],
		["1966-03-01T02:00:00+00:00", "23:00:00", "-03", 180],
		["1966-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1966-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1967" : helpers.makeTestYear("Brazil/East", [
		["1967-03-01T01:59:59+00:00", "23:59:59", "-02", 120],
		["1967-03-01T02:00:00+00:00", "23:00:00", "-03", 180],
		["1967-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["1967-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1968" : helpers.makeTestYear("Brazil/East", [
		["1968-03-01T01:59:59+00:00", "23:59:59", "-02", 120],
		["1968-03-01T02:00:00+00:00", "23:00:00", "-03", 180]
	]),

	"1985" : helpers.makeTestYear("Brazil/East", [
		["1985-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["1985-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1986" : helpers.makeTestYear("Brazil/East", [
		["1986-03-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["1986-03-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["1986-10-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["1986-10-25T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1987" : helpers.makeTestYear("Brazil/East", [
		["1987-02-14T01:59:59+00:00", "23:59:59", "-02", 120],
		["1987-02-14T02:00:00+00:00", "23:00:00", "-03", 180],
		["1987-10-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["1987-10-25T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1988" : helpers.makeTestYear("Brazil/East", [
		["1988-02-07T01:59:59+00:00", "23:59:59", "-02", 120],
		["1988-02-07T02:00:00+00:00", "23:00:00", "-03", 180],
		["1988-10-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["1988-10-16T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1989" : helpers.makeTestYear("Brazil/East", [
		["1989-01-29T01:59:59+00:00", "23:59:59", "-02", 120],
		["1989-01-29T02:00:00+00:00", "23:00:00", "-03", 180],
		["1989-10-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["1989-10-15T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1990" : helpers.makeTestYear("Brazil/East", [
		["1990-02-11T01:59:59+00:00", "23:59:59", "-02", 120],
		["1990-02-11T02:00:00+00:00", "23:00:00", "-03", 180],
		["1990-10-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["1990-10-21T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1991" : helpers.makeTestYear("Brazil/East", [
		["1991-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["1991-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["1991-10-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["1991-10-20T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1992" : helpers.makeTestYear("Brazil/East", [
		["1992-02-09T01:59:59+00:00", "23:59:59", "-02", 120],
		["1992-02-09T02:00:00+00:00", "23:00:00", "-03", 180],
		["1992-10-25T02:59:59+00:00", "23:59:59", "-03", 180],
		["1992-10-25T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1993" : helpers.makeTestYear("Brazil/East", [
		["1993-01-31T01:59:59+00:00", "23:59:59", "-02", 120],
		["1993-01-31T02:00:00+00:00", "23:00:00", "-03", 180],
		["1993-10-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["1993-10-17T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1994" : helpers.makeTestYear("Brazil/East", [
		["1994-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["1994-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["1994-10-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["1994-10-16T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1995" : helpers.makeTestYear("Brazil/East", [
		["1995-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["1995-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["1995-10-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["1995-10-15T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1996" : helpers.makeTestYear("Brazil/East", [
		["1996-02-11T01:59:59+00:00", "23:59:59", "-02", 120],
		["1996-02-11T02:00:00+00:00", "23:00:00", "-03", 180],
		["1996-10-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["1996-10-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1997" : helpers.makeTestYear("Brazil/East", [
		["1997-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["1997-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["1997-10-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["1997-10-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1998" : helpers.makeTestYear("Brazil/East", [
		["1998-03-01T01:59:59+00:00", "23:59:59", "-02", 120],
		["1998-03-01T02:00:00+00:00", "23:00:00", "-03", 180],
		["1998-10-11T02:59:59+00:00", "23:59:59", "-03", 180],
		["1998-10-11T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"1999" : helpers.makeTestYear("Brazil/East", [
		["1999-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["1999-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["1999-10-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["1999-10-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2000" : helpers.makeTestYear("Brazil/East", [
		["2000-02-27T01:59:59+00:00", "23:59:59", "-02", 120],
		["2000-02-27T02:00:00+00:00", "23:00:00", "-03", 180],
		["2000-10-08T02:59:59+00:00", "23:59:59", "-03", 180],
		["2000-10-08T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2001" : helpers.makeTestYear("Brazil/East", [
		["2001-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2001-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2001-10-14T02:59:59+00:00", "23:59:59", "-03", 180],
		["2001-10-14T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2002" : helpers.makeTestYear("Brazil/East", [
		["2002-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2002-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2002-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2002-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2003" : helpers.makeTestYear("Brazil/East", [
		["2003-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2003-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2003-10-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2003-10-19T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2004" : helpers.makeTestYear("Brazil/East", [
		["2004-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2004-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2004-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2004-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2005" : helpers.makeTestYear("Brazil/East", [
		["2005-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2005-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2005-10-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2005-10-16T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2006" : helpers.makeTestYear("Brazil/East", [
		["2006-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2006-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2006-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2006-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2007" : helpers.makeTestYear("Brazil/East", [
		["2007-02-25T01:59:59+00:00", "23:59:59", "-02", 120],
		["2007-02-25T02:00:00+00:00", "23:00:00", "-03", 180],
		["2007-10-14T02:59:59+00:00", "23:59:59", "-03", 180],
		["2007-10-14T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2008" : helpers.makeTestYear("Brazil/East", [
		["2008-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2008-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2008-10-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2008-10-19T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2009" : helpers.makeTestYear("Brazil/East", [
		["2009-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2009-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2009-10-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2009-10-18T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2010" : helpers.makeTestYear("Brazil/East", [
		["2010-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2010-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2010-10-17T02:59:59+00:00", "23:59:59", "-03", 180],
		["2010-10-17T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2011" : helpers.makeTestYear("Brazil/East", [
		["2011-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2011-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2011-10-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2011-10-16T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2012" : helpers.makeTestYear("Brazil/East", [
		["2012-02-26T01:59:59+00:00", "23:59:59", "-02", 120],
		["2012-02-26T02:00:00+00:00", "23:00:00", "-03", 180],
		["2012-10-21T02:59:59+00:00", "23:59:59", "-03", 180],
		["2012-10-21T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2013" : helpers.makeTestYear("Brazil/East", [
		["2013-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2013-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2013-10-20T02:59:59+00:00", "23:59:59", "-03", 180],
		["2013-10-20T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2014" : helpers.makeTestYear("Brazil/East", [
		["2014-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2014-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2014-10-19T02:59:59+00:00", "23:59:59", "-03", 180],
		["2014-10-19T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2015" : helpers.makeTestYear("Brazil/East", [
		["2015-02-22T01:59:59+00:00", "23:59:59", "-02", 120],
		["2015-02-22T02:00:00+00:00", "23:00:00", "-03", 180],
		["2015-10-18T02:59:59+00:00", "23:59:59", "-03", 180],
		["2015-10-18T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2016" : helpers.makeTestYear("Brazil/East", [
		["2016-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2016-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2016-10-16T02:59:59+00:00", "23:59:59", "-03", 180],
		["2016-10-16T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2017" : helpers.makeTestYear("Brazil/East", [
		["2017-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2017-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2017-10-15T02:59:59+00:00", "23:59:59", "-03", 180],
		["2017-10-15T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2018" : helpers.makeTestYear("Brazil/East", [
		["2018-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2018-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2018-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2018-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2019" : helpers.makeTestYear("Brazil/East", [
		["2019-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2019-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2019-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2019-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2020" : helpers.makeTestYear("Brazil/East", [
		["2020-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2020-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2020-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2020-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2021" : helpers.makeTestYear("Brazil/East", [
		["2021-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2021-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2021-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2021-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2022" : helpers.makeTestYear("Brazil/East", [
		["2022-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2022-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2022-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2022-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2023" : helpers.makeTestYear("Brazil/East", [
		["2023-02-26T01:59:59+00:00", "23:59:59", "-02", 120],
		["2023-02-26T02:00:00+00:00", "23:00:00", "-03", 180],
		["2023-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2023-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2024" : helpers.makeTestYear("Brazil/East", [
		["2024-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2024-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2024-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2024-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2025" : helpers.makeTestYear("Brazil/East", [
		["2025-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2025-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2025-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2025-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2026" : helpers.makeTestYear("Brazil/East", [
		["2026-02-22T01:59:59+00:00", "23:59:59", "-02", 120],
		["2026-02-22T02:00:00+00:00", "23:00:00", "-03", 180],
		["2026-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2026-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2027" : helpers.makeTestYear("Brazil/East", [
		["2027-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2027-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2027-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2027-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2028" : helpers.makeTestYear("Brazil/East", [
		["2028-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2028-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2028-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2028-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2029" : helpers.makeTestYear("Brazil/East", [
		["2029-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2029-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2029-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2029-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2030" : helpers.makeTestYear("Brazil/East", [
		["2030-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2030-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2030-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2030-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2031" : helpers.makeTestYear("Brazil/East", [
		["2031-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2031-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2031-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2031-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2032" : helpers.makeTestYear("Brazil/East", [
		["2032-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2032-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2032-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2032-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2033" : helpers.makeTestYear("Brazil/East", [
		["2033-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2033-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2033-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2033-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2034" : helpers.makeTestYear("Brazil/East", [
		["2034-02-26T01:59:59+00:00", "23:59:59", "-02", 120],
		["2034-02-26T02:00:00+00:00", "23:00:00", "-03", 180],
		["2034-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2034-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2035" : helpers.makeTestYear("Brazil/East", [
		["2035-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2035-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2035-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2035-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2036" : helpers.makeTestYear("Brazil/East", [
		["2036-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2036-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2036-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2036-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2037" : helpers.makeTestYear("Brazil/East", [
		["2037-02-22T01:59:59+00:00", "23:59:59", "-02", 120],
		["2037-02-22T02:00:00+00:00", "23:00:00", "-03", 180],
		["2037-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2037-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2038" : helpers.makeTestYear("Brazil/East", [
		["2038-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2038-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2038-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2038-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2039" : helpers.makeTestYear("Brazil/East", [
		["2039-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2039-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2039-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2039-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2040" : helpers.makeTestYear("Brazil/East", [
		["2040-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2040-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2040-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2040-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2041" : helpers.makeTestYear("Brazil/East", [
		["2041-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2041-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2041-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2041-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2042" : helpers.makeTestYear("Brazil/East", [
		["2042-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2042-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2042-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2042-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2043" : helpers.makeTestYear("Brazil/East", [
		["2043-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2043-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2043-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2043-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2044" : helpers.makeTestYear("Brazil/East", [
		["2044-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2044-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2044-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2044-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2045" : helpers.makeTestYear("Brazil/East", [
		["2045-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2045-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2045-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2045-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2046" : helpers.makeTestYear("Brazil/East", [
		["2046-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2046-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2046-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2046-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2047" : helpers.makeTestYear("Brazil/East", [
		["2047-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2047-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2047-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2047-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2048" : helpers.makeTestYear("Brazil/East", [
		["2048-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2048-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2048-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2048-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2049" : helpers.makeTestYear("Brazil/East", [
		["2049-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2049-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2049-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2049-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2050" : helpers.makeTestYear("Brazil/East", [
		["2050-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2050-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2050-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2050-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2051" : helpers.makeTestYear("Brazil/East", [
		["2051-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2051-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2051-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2051-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2052" : helpers.makeTestYear("Brazil/East", [
		["2052-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2052-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2052-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2052-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2053" : helpers.makeTestYear("Brazil/East", [
		["2053-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2053-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2053-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2053-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2054" : helpers.makeTestYear("Brazil/East", [
		["2054-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2054-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2054-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2054-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2055" : helpers.makeTestYear("Brazil/East", [
		["2055-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2055-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2055-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2055-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2056" : helpers.makeTestYear("Brazil/East", [
		["2056-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2056-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2056-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2056-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2057" : helpers.makeTestYear("Brazil/East", [
		["2057-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2057-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2057-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2057-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2058" : helpers.makeTestYear("Brazil/East", [
		["2058-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2058-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2058-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2058-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2059" : helpers.makeTestYear("Brazil/East", [
		["2059-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2059-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2059-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2059-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2060" : helpers.makeTestYear("Brazil/East", [
		["2060-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2060-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2060-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2060-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2061" : helpers.makeTestYear("Brazil/East", [
		["2061-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2061-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2061-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2061-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2062" : helpers.makeTestYear("Brazil/East", [
		["2062-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2062-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2062-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2062-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2063" : helpers.makeTestYear("Brazil/East", [
		["2063-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2063-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2063-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2063-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2064" : helpers.makeTestYear("Brazil/East", [
		["2064-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2064-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2064-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2064-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2065" : helpers.makeTestYear("Brazil/East", [
		["2065-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2065-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2065-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2065-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2066" : helpers.makeTestYear("Brazil/East", [
		["2066-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2066-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2066-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2066-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2067" : helpers.makeTestYear("Brazil/East", [
		["2067-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2067-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2067-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2067-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2068" : helpers.makeTestYear("Brazil/East", [
		["2068-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2068-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2068-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2068-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2069" : helpers.makeTestYear("Brazil/East", [
		["2069-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2069-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2069-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2069-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2070" : helpers.makeTestYear("Brazil/East", [
		["2070-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2070-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2070-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2070-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2071" : helpers.makeTestYear("Brazil/East", [
		["2071-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2071-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2071-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2071-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2072" : helpers.makeTestYear("Brazil/East", [
		["2072-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2072-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2072-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2072-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2073" : helpers.makeTestYear("Brazil/East", [
		["2073-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2073-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2073-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2073-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2074" : helpers.makeTestYear("Brazil/East", [
		["2074-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2074-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2074-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2074-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2075" : helpers.makeTestYear("Brazil/East", [
		["2075-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2075-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2075-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2075-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2076" : helpers.makeTestYear("Brazil/East", [
		["2076-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2076-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2076-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2076-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2077" : helpers.makeTestYear("Brazil/East", [
		["2077-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2077-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2077-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2077-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2078" : helpers.makeTestYear("Brazil/East", [
		["2078-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2078-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2078-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2078-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2079" : helpers.makeTestYear("Brazil/East", [
		["2079-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2079-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2079-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2079-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2080" : helpers.makeTestYear("Brazil/East", [
		["2080-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2080-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2080-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2080-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2081" : helpers.makeTestYear("Brazil/East", [
		["2081-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2081-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2081-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2081-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2082" : helpers.makeTestYear("Brazil/East", [
		["2082-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2082-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2082-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2082-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2083" : helpers.makeTestYear("Brazil/East", [
		["2083-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2083-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2083-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2083-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2084" : helpers.makeTestYear("Brazil/East", [
		["2084-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2084-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2084-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2084-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2085" : helpers.makeTestYear("Brazil/East", [
		["2085-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2085-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2085-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2085-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2086" : helpers.makeTestYear("Brazil/East", [
		["2086-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2086-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2086-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2086-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2087" : helpers.makeTestYear("Brazil/East", [
		["2087-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2087-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2087-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2087-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2088" : helpers.makeTestYear("Brazil/East", [
		["2088-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2088-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2088-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2088-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2089" : helpers.makeTestYear("Brazil/East", [
		["2089-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2089-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2089-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2089-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2090" : helpers.makeTestYear("Brazil/East", [
		["2090-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2090-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2090-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2090-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2091" : helpers.makeTestYear("Brazil/East", [
		["2091-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2091-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2091-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2091-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2092" : helpers.makeTestYear("Brazil/East", [
		["2092-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2092-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2092-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2092-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2093" : helpers.makeTestYear("Brazil/East", [
		["2093-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2093-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2093-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2093-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2094" : helpers.makeTestYear("Brazil/East", [
		["2094-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2094-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2094-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2094-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2095" : helpers.makeTestYear("Brazil/East", [
		["2095-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2095-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2095-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2095-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2096" : helpers.makeTestYear("Brazil/East", [
		["2096-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2096-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2096-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2096-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2097" : helpers.makeTestYear("Brazil/East", [
		["2097-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2097-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2097-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2097-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2098" : helpers.makeTestYear("Brazil/East", [
		["2098-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2098-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2098-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2098-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2099" : helpers.makeTestYear("Brazil/East", [
		["2099-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2099-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2099-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2099-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2100" : helpers.makeTestYear("Brazil/East", [
		["2100-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2100-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2100-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2100-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2101" : helpers.makeTestYear("Brazil/East", [
		["2101-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2101-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2101-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2101-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2102" : helpers.makeTestYear("Brazil/East", [
		["2102-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2102-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2102-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2102-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2103" : helpers.makeTestYear("Brazil/East", [
		["2103-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2103-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2103-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2103-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2104" : helpers.makeTestYear("Brazil/East", [
		["2104-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2104-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2104-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2104-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2105" : helpers.makeTestYear("Brazil/East", [
		["2105-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2105-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2105-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2105-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2106" : helpers.makeTestYear("Brazil/East", [
		["2106-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2106-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2106-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2106-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2107" : helpers.makeTestYear("Brazil/East", [
		["2107-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2107-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2107-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2107-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2108" : helpers.makeTestYear("Brazil/East", [
		["2108-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2108-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2108-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2108-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2109" : helpers.makeTestYear("Brazil/East", [
		["2109-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2109-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2109-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2109-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2110" : helpers.makeTestYear("Brazil/East", [
		["2110-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2110-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2110-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2110-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2111" : helpers.makeTestYear("Brazil/East", [
		["2111-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2111-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2111-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2111-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2112" : helpers.makeTestYear("Brazil/East", [
		["2112-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2112-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2112-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2112-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2113" : helpers.makeTestYear("Brazil/East", [
		["2113-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2113-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2113-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2113-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2114" : helpers.makeTestYear("Brazil/East", [
		["2114-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2114-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2114-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2114-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2115" : helpers.makeTestYear("Brazil/East", [
		["2115-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2115-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2115-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2115-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2116" : helpers.makeTestYear("Brazil/East", [
		["2116-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2116-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2116-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2116-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2117" : helpers.makeTestYear("Brazil/East", [
		["2117-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2117-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2117-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2117-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2118" : helpers.makeTestYear("Brazil/East", [
		["2118-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2118-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2118-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2118-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2119" : helpers.makeTestYear("Brazil/East", [
		["2119-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2119-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2119-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2119-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2120" : helpers.makeTestYear("Brazil/East", [
		["2120-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2120-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2120-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2120-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2121" : helpers.makeTestYear("Brazil/East", [
		["2121-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2121-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2121-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2121-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2122" : helpers.makeTestYear("Brazil/East", [
		["2122-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2122-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2122-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2122-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2123" : helpers.makeTestYear("Brazil/East", [
		["2123-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2123-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2123-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2123-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2124" : helpers.makeTestYear("Brazil/East", [
		["2124-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2124-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2124-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2124-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2125" : helpers.makeTestYear("Brazil/East", [
		["2125-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2125-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2125-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2125-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2126" : helpers.makeTestYear("Brazil/East", [
		["2126-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2126-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2126-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2126-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2127" : helpers.makeTestYear("Brazil/East", [
		["2127-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2127-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2127-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2127-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2128" : helpers.makeTestYear("Brazil/East", [
		["2128-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2128-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2128-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2128-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2129" : helpers.makeTestYear("Brazil/East", [
		["2129-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2129-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2129-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2129-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2130" : helpers.makeTestYear("Brazil/East", [
		["2130-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2130-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2130-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2130-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2131" : helpers.makeTestYear("Brazil/East", [
		["2131-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2131-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2131-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2131-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2132" : helpers.makeTestYear("Brazil/East", [
		["2132-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2132-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2132-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2132-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2133" : helpers.makeTestYear("Brazil/East", [
		["2133-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2133-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2133-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2133-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2134" : helpers.makeTestYear("Brazil/East", [
		["2134-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2134-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2134-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2134-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2135" : helpers.makeTestYear("Brazil/East", [
		["2135-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2135-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2135-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2135-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2136" : helpers.makeTestYear("Brazil/East", [
		["2136-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2136-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2136-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2136-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2137" : helpers.makeTestYear("Brazil/East", [
		["2137-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2137-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2137-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2137-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2138" : helpers.makeTestYear("Brazil/East", [
		["2138-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2138-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2138-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2138-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2139" : helpers.makeTestYear("Brazil/East", [
		["2139-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2139-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2139-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2139-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2140" : helpers.makeTestYear("Brazil/East", [
		["2140-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2140-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2140-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2140-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2141" : helpers.makeTestYear("Brazil/East", [
		["2141-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2141-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2141-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2141-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2142" : helpers.makeTestYear("Brazil/East", [
		["2142-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2142-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2142-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2142-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2143" : helpers.makeTestYear("Brazil/East", [
		["2143-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2143-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2143-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2143-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2144" : helpers.makeTestYear("Brazil/East", [
		["2144-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2144-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2144-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2144-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2145" : helpers.makeTestYear("Brazil/East", [
		["2145-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2145-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2145-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2145-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2146" : helpers.makeTestYear("Brazil/East", [
		["2146-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2146-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2146-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2146-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2147" : helpers.makeTestYear("Brazil/East", [
		["2147-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2147-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2147-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2147-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2148" : helpers.makeTestYear("Brazil/East", [
		["2148-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2148-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2148-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2148-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2149" : helpers.makeTestYear("Brazil/East", [
		["2149-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2149-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2149-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2149-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2150" : helpers.makeTestYear("Brazil/East", [
		["2150-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2150-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2150-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2150-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2151" : helpers.makeTestYear("Brazil/East", [
		["2151-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2151-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2151-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2151-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2152" : helpers.makeTestYear("Brazil/East", [
		["2152-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2152-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2152-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2152-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2153" : helpers.makeTestYear("Brazil/East", [
		["2153-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2153-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2153-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2153-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2154" : helpers.makeTestYear("Brazil/East", [
		["2154-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2154-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2154-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2154-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2155" : helpers.makeTestYear("Brazil/East", [
		["2155-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2155-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2155-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2155-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2156" : helpers.makeTestYear("Brazil/East", [
		["2156-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2156-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2156-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2156-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2157" : helpers.makeTestYear("Brazil/East", [
		["2157-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2157-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2157-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2157-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2158" : helpers.makeTestYear("Brazil/East", [
		["2158-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2158-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2158-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2158-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2159" : helpers.makeTestYear("Brazil/East", [
		["2159-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2159-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2159-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2159-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2160" : helpers.makeTestYear("Brazil/East", [
		["2160-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2160-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2160-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2160-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2161" : helpers.makeTestYear("Brazil/East", [
		["2161-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2161-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2161-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2161-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2162" : helpers.makeTestYear("Brazil/East", [
		["2162-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2162-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2162-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2162-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2163" : helpers.makeTestYear("Brazil/East", [
		["2163-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2163-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2163-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2163-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2164" : helpers.makeTestYear("Brazil/East", [
		["2164-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2164-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2164-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2164-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2165" : helpers.makeTestYear("Brazil/East", [
		["2165-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2165-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2165-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2165-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2166" : helpers.makeTestYear("Brazil/East", [
		["2166-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2166-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2166-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2166-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2167" : helpers.makeTestYear("Brazil/East", [
		["2167-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2167-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2167-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2167-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2168" : helpers.makeTestYear("Brazil/East", [
		["2168-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2168-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2168-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2168-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2169" : helpers.makeTestYear("Brazil/East", [
		["2169-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2169-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2169-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2169-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2170" : helpers.makeTestYear("Brazil/East", [
		["2170-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2170-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2170-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2170-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2171" : helpers.makeTestYear("Brazil/East", [
		["2171-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2171-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2171-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2171-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2172" : helpers.makeTestYear("Brazil/East", [
		["2172-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2172-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2172-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2172-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2173" : helpers.makeTestYear("Brazil/East", [
		["2173-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2173-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2173-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2173-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2174" : helpers.makeTestYear("Brazil/East", [
		["2174-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2174-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2174-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2174-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2175" : helpers.makeTestYear("Brazil/East", [
		["2175-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2175-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2175-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2175-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2176" : helpers.makeTestYear("Brazil/East", [
		["2176-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2176-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2176-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2176-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2177" : helpers.makeTestYear("Brazil/East", [
		["2177-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2177-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2177-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2177-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2178" : helpers.makeTestYear("Brazil/East", [
		["2178-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2178-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2178-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2178-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2179" : helpers.makeTestYear("Brazil/East", [
		["2179-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2179-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2179-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2179-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2180" : helpers.makeTestYear("Brazil/East", [
		["2180-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2180-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2180-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2180-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2181" : helpers.makeTestYear("Brazil/East", [
		["2181-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2181-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2181-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2181-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2182" : helpers.makeTestYear("Brazil/East", [
		["2182-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2182-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2182-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2182-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2183" : helpers.makeTestYear("Brazil/East", [
		["2183-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2183-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2183-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2183-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2184" : helpers.makeTestYear("Brazil/East", [
		["2184-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2184-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2184-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2184-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2185" : helpers.makeTestYear("Brazil/East", [
		["2185-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2185-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2185-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2185-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2186" : helpers.makeTestYear("Brazil/East", [
		["2186-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2186-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2186-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2186-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2187" : helpers.makeTestYear("Brazil/East", [
		["2187-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2187-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2187-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2187-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2188" : helpers.makeTestYear("Brazil/East", [
		["2188-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2188-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2188-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2188-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2189" : helpers.makeTestYear("Brazil/East", [
		["2189-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2189-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2189-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2189-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2190" : helpers.makeTestYear("Brazil/East", [
		["2190-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2190-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2190-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2190-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2191" : helpers.makeTestYear("Brazil/East", [
		["2191-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2191-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2191-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2191-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2192" : helpers.makeTestYear("Brazil/East", [
		["2192-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2192-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2192-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2192-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2193" : helpers.makeTestYear("Brazil/East", [
		["2193-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2193-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2193-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2193-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2194" : helpers.makeTestYear("Brazil/East", [
		["2194-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2194-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2194-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2194-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2195" : helpers.makeTestYear("Brazil/East", [
		["2195-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2195-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2195-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2195-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2196" : helpers.makeTestYear("Brazil/East", [
		["2196-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2196-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2196-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2196-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2197" : helpers.makeTestYear("Brazil/East", [
		["2197-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2197-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2197-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2197-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2198" : helpers.makeTestYear("Brazil/East", [
		["2198-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2198-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2198-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2198-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2199" : helpers.makeTestYear("Brazil/East", [
		["2199-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2199-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2199-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2199-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2200" : helpers.makeTestYear("Brazil/East", [
		["2200-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2200-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2200-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2200-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2201" : helpers.makeTestYear("Brazil/East", [
		["2201-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2201-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2201-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2201-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2202" : helpers.makeTestYear("Brazil/East", [
		["2202-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2202-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2202-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2202-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2203" : helpers.makeTestYear("Brazil/East", [
		["2203-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2203-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2203-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2203-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2204" : helpers.makeTestYear("Brazil/East", [
		["2204-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2204-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2204-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2204-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2205" : helpers.makeTestYear("Brazil/East", [
		["2205-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2205-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2205-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2205-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2206" : helpers.makeTestYear("Brazil/East", [
		["2206-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2206-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2206-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2206-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2207" : helpers.makeTestYear("Brazil/East", [
		["2207-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2207-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2207-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2207-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2208" : helpers.makeTestYear("Brazil/East", [
		["2208-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2208-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2208-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2208-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2209" : helpers.makeTestYear("Brazil/East", [
		["2209-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2209-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2209-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2209-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2210" : helpers.makeTestYear("Brazil/East", [
		["2210-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2210-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2210-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2210-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2211" : helpers.makeTestYear("Brazil/East", [
		["2211-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2211-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2211-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2211-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2212" : helpers.makeTestYear("Brazil/East", [
		["2212-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2212-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2212-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2212-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2213" : helpers.makeTestYear("Brazil/East", [
		["2213-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2213-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2213-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2213-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2214" : helpers.makeTestYear("Brazil/East", [
		["2214-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2214-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2214-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2214-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2215" : helpers.makeTestYear("Brazil/East", [
		["2215-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2215-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2215-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2215-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2216" : helpers.makeTestYear("Brazil/East", [
		["2216-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2216-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2216-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2216-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2217" : helpers.makeTestYear("Brazil/East", [
		["2217-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2217-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2217-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2217-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2218" : helpers.makeTestYear("Brazil/East", [
		["2218-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2218-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2218-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2218-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2219" : helpers.makeTestYear("Brazil/East", [
		["2219-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2219-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2219-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2219-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2220" : helpers.makeTestYear("Brazil/East", [
		["2220-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2220-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2220-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2220-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2221" : helpers.makeTestYear("Brazil/East", [
		["2221-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2221-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2221-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2221-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2222" : helpers.makeTestYear("Brazil/East", [
		["2222-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2222-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2222-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2222-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2223" : helpers.makeTestYear("Brazil/East", [
		["2223-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2223-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2223-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2223-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2224" : helpers.makeTestYear("Brazil/East", [
		["2224-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2224-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2224-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2224-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2225" : helpers.makeTestYear("Brazil/East", [
		["2225-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2225-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2225-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2225-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2226" : helpers.makeTestYear("Brazil/East", [
		["2226-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2226-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2226-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2226-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2227" : helpers.makeTestYear("Brazil/East", [
		["2227-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2227-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2227-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2227-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2228" : helpers.makeTestYear("Brazil/East", [
		["2228-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2228-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2228-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2228-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2229" : helpers.makeTestYear("Brazil/East", [
		["2229-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2229-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2229-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2229-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2230" : helpers.makeTestYear("Brazil/East", [
		["2230-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2230-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2230-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2230-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2231" : helpers.makeTestYear("Brazil/East", [
		["2231-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2231-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2231-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2231-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2232" : helpers.makeTestYear("Brazil/East", [
		["2232-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2232-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2232-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2232-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2233" : helpers.makeTestYear("Brazil/East", [
		["2233-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2233-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2233-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2233-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2234" : helpers.makeTestYear("Brazil/East", [
		["2234-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2234-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2234-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2234-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2235" : helpers.makeTestYear("Brazil/East", [
		["2235-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2235-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2235-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2235-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2236" : helpers.makeTestYear("Brazil/East", [
		["2236-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2236-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2236-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2236-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2237" : helpers.makeTestYear("Brazil/East", [
		["2237-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2237-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2237-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2237-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2238" : helpers.makeTestYear("Brazil/East", [
		["2238-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2238-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2238-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2238-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2239" : helpers.makeTestYear("Brazil/East", [
		["2239-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2239-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2239-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2239-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2240" : helpers.makeTestYear("Brazil/East", [
		["2240-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2240-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2240-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2240-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2241" : helpers.makeTestYear("Brazil/East", [
		["2241-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2241-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2241-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2241-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2242" : helpers.makeTestYear("Brazil/East", [
		["2242-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2242-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2242-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2242-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2243" : helpers.makeTestYear("Brazil/East", [
		["2243-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2243-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2243-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2243-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2244" : helpers.makeTestYear("Brazil/East", [
		["2244-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2244-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2244-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2244-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2245" : helpers.makeTestYear("Brazil/East", [
		["2245-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2245-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2245-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2245-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2246" : helpers.makeTestYear("Brazil/East", [
		["2246-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2246-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2246-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2246-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2247" : helpers.makeTestYear("Brazil/East", [
		["2247-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2247-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2247-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2247-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2248" : helpers.makeTestYear("Brazil/East", [
		["2248-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2248-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2248-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2248-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2249" : helpers.makeTestYear("Brazil/East", [
		["2249-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2249-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2249-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2249-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2250" : helpers.makeTestYear("Brazil/East", [
		["2250-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2250-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2250-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2250-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2251" : helpers.makeTestYear("Brazil/East", [
		["2251-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2251-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2251-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2251-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2252" : helpers.makeTestYear("Brazil/East", [
		["2252-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2252-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2252-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2252-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2253" : helpers.makeTestYear("Brazil/East", [
		["2253-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2253-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2253-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2253-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2254" : helpers.makeTestYear("Brazil/East", [
		["2254-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2254-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2254-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2254-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2255" : helpers.makeTestYear("Brazil/East", [
		["2255-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2255-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2255-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2255-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2256" : helpers.makeTestYear("Brazil/East", [
		["2256-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2256-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2256-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2256-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2257" : helpers.makeTestYear("Brazil/East", [
		["2257-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2257-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2257-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2257-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2258" : helpers.makeTestYear("Brazil/East", [
		["2258-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2258-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2258-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2258-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2259" : helpers.makeTestYear("Brazil/East", [
		["2259-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2259-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2259-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2259-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2260" : helpers.makeTestYear("Brazil/East", [
		["2260-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2260-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2260-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2260-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2261" : helpers.makeTestYear("Brazil/East", [
		["2261-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2261-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2261-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2261-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2262" : helpers.makeTestYear("Brazil/East", [
		["2262-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2262-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2262-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2262-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2263" : helpers.makeTestYear("Brazil/East", [
		["2263-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2263-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2263-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2263-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2264" : helpers.makeTestYear("Brazil/East", [
		["2264-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2264-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2264-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2264-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2265" : helpers.makeTestYear("Brazil/East", [
		["2265-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2265-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2265-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2265-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2266" : helpers.makeTestYear("Brazil/East", [
		["2266-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2266-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2266-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2266-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2267" : helpers.makeTestYear("Brazil/East", [
		["2267-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2267-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2267-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2267-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2268" : helpers.makeTestYear("Brazil/East", [
		["2268-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2268-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2268-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2268-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2269" : helpers.makeTestYear("Brazil/East", [
		["2269-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2269-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2269-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2269-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2270" : helpers.makeTestYear("Brazil/East", [
		["2270-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2270-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2270-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2270-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2271" : helpers.makeTestYear("Brazil/East", [
		["2271-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2271-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2271-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2271-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2272" : helpers.makeTestYear("Brazil/East", [
		["2272-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2272-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2272-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2272-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2273" : helpers.makeTestYear("Brazil/East", [
		["2273-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2273-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2273-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2273-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2274" : helpers.makeTestYear("Brazil/East", [
		["2274-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2274-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2274-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2274-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2275" : helpers.makeTestYear("Brazil/East", [
		["2275-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2275-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2275-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2275-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2276" : helpers.makeTestYear("Brazil/East", [
		["2276-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2276-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2276-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2276-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2277" : helpers.makeTestYear("Brazil/East", [
		["2277-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2277-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2277-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2277-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2278" : helpers.makeTestYear("Brazil/East", [
		["2278-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2278-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2278-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2278-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2279" : helpers.makeTestYear("Brazil/East", [
		["2279-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2279-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2279-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2279-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2280" : helpers.makeTestYear("Brazil/East", [
		["2280-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2280-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2280-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2280-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2281" : helpers.makeTestYear("Brazil/East", [
		["2281-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2281-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2281-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2281-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2282" : helpers.makeTestYear("Brazil/East", [
		["2282-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2282-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2282-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2282-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2283" : helpers.makeTestYear("Brazil/East", [
		["2283-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2283-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2283-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2283-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2284" : helpers.makeTestYear("Brazil/East", [
		["2284-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2284-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2284-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2284-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2285" : helpers.makeTestYear("Brazil/East", [
		["2285-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2285-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2285-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2285-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2286" : helpers.makeTestYear("Brazil/East", [
		["2286-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2286-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2286-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2286-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2287" : helpers.makeTestYear("Brazil/East", [
		["2287-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2287-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2287-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2287-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2288" : helpers.makeTestYear("Brazil/East", [
		["2288-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2288-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2288-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2288-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2289" : helpers.makeTestYear("Brazil/East", [
		["2289-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2289-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2289-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2289-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2290" : helpers.makeTestYear("Brazil/East", [
		["2290-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2290-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2290-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2290-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2291" : helpers.makeTestYear("Brazil/East", [
		["2291-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2291-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2291-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2291-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2292" : helpers.makeTestYear("Brazil/East", [
		["2292-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2292-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2292-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2292-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2293" : helpers.makeTestYear("Brazil/East", [
		["2293-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2293-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2293-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2293-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2294" : helpers.makeTestYear("Brazil/East", [
		["2294-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2294-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2294-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2294-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2295" : helpers.makeTestYear("Brazil/East", [
		["2295-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2295-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2295-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2295-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2296" : helpers.makeTestYear("Brazil/East", [
		["2296-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2296-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2296-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2296-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2297" : helpers.makeTestYear("Brazil/East", [
		["2297-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2297-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2297-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2297-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2298" : helpers.makeTestYear("Brazil/East", [
		["2298-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2298-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2298-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2298-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2299" : helpers.makeTestYear("Brazil/East", [
		["2299-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2299-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2299-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2299-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2300" : helpers.makeTestYear("Brazil/East", [
		["2300-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2300-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2300-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2300-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2301" : helpers.makeTestYear("Brazil/East", [
		["2301-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2301-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2301-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2301-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2302" : helpers.makeTestYear("Brazil/East", [
		["2302-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2302-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2302-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2302-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2303" : helpers.makeTestYear("Brazil/East", [
		["2303-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2303-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2303-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2303-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2304" : helpers.makeTestYear("Brazil/East", [
		["2304-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2304-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2304-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2304-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2305" : helpers.makeTestYear("Brazil/East", [
		["2305-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2305-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2305-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2305-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2306" : helpers.makeTestYear("Brazil/East", [
		["2306-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2306-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2306-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2306-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2307" : helpers.makeTestYear("Brazil/East", [
		["2307-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2307-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2307-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2307-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2308" : helpers.makeTestYear("Brazil/East", [
		["2308-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2308-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2308-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2308-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2309" : helpers.makeTestYear("Brazil/East", [
		["2309-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2309-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2309-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2309-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2310" : helpers.makeTestYear("Brazil/East", [
		["2310-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2310-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2310-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2310-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2311" : helpers.makeTestYear("Brazil/East", [
		["2311-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2311-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2311-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2311-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2312" : helpers.makeTestYear("Brazil/East", [
		["2312-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2312-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2312-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2312-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2313" : helpers.makeTestYear("Brazil/East", [
		["2313-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2313-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2313-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2313-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2314" : helpers.makeTestYear("Brazil/East", [
		["2314-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2314-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2314-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2314-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2315" : helpers.makeTestYear("Brazil/East", [
		["2315-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2315-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2315-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2315-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2316" : helpers.makeTestYear("Brazil/East", [
		["2316-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2316-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2316-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2316-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2317" : helpers.makeTestYear("Brazil/East", [
		["2317-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2317-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2317-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2317-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2318" : helpers.makeTestYear("Brazil/East", [
		["2318-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2318-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2318-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2318-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2319" : helpers.makeTestYear("Brazil/East", [
		["2319-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2319-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2319-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2319-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2320" : helpers.makeTestYear("Brazil/East", [
		["2320-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2320-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2320-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2320-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2321" : helpers.makeTestYear("Brazil/East", [
		["2321-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2321-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2321-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2321-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2322" : helpers.makeTestYear("Brazil/East", [
		["2322-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2322-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2322-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2322-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2323" : helpers.makeTestYear("Brazil/East", [
		["2323-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2323-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2323-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2323-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2324" : helpers.makeTestYear("Brazil/East", [
		["2324-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2324-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2324-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2324-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2325" : helpers.makeTestYear("Brazil/East", [
		["2325-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2325-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2325-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2325-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2326" : helpers.makeTestYear("Brazil/East", [
		["2326-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2326-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2326-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2326-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2327" : helpers.makeTestYear("Brazil/East", [
		["2327-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2327-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2327-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2327-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2328" : helpers.makeTestYear("Brazil/East", [
		["2328-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2328-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2328-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2328-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2329" : helpers.makeTestYear("Brazil/East", [
		["2329-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2329-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2329-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2329-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2330" : helpers.makeTestYear("Brazil/East", [
		["2330-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2330-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2330-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2330-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2331" : helpers.makeTestYear("Brazil/East", [
		["2331-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2331-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2331-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2331-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2332" : helpers.makeTestYear("Brazil/East", [
		["2332-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2332-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2332-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2332-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2333" : helpers.makeTestYear("Brazil/East", [
		["2333-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2333-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2333-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2333-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2334" : helpers.makeTestYear("Brazil/East", [
		["2334-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2334-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2334-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2334-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2335" : helpers.makeTestYear("Brazil/East", [
		["2335-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2335-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2335-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2335-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2336" : helpers.makeTestYear("Brazil/East", [
		["2336-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2336-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2336-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2336-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2337" : helpers.makeTestYear("Brazil/East", [
		["2337-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2337-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2337-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2337-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2338" : helpers.makeTestYear("Brazil/East", [
		["2338-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2338-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2338-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2338-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2339" : helpers.makeTestYear("Brazil/East", [
		["2339-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2339-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2339-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2339-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2340" : helpers.makeTestYear("Brazil/East", [
		["2340-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2340-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2340-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2340-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2341" : helpers.makeTestYear("Brazil/East", [
		["2341-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2341-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2341-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2341-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2342" : helpers.makeTestYear("Brazil/East", [
		["2342-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2342-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2342-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2342-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2343" : helpers.makeTestYear("Brazil/East", [
		["2343-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2343-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2343-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2343-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2344" : helpers.makeTestYear("Brazil/East", [
		["2344-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2344-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2344-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2344-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2345" : helpers.makeTestYear("Brazil/East", [
		["2345-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2345-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2345-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2345-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2346" : helpers.makeTestYear("Brazil/East", [
		["2346-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2346-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2346-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2346-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2347" : helpers.makeTestYear("Brazil/East", [
		["2347-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2347-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2347-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2347-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2348" : helpers.makeTestYear("Brazil/East", [
		["2348-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2348-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2348-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2348-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2349" : helpers.makeTestYear("Brazil/East", [
		["2349-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2349-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2349-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2349-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2350" : helpers.makeTestYear("Brazil/East", [
		["2350-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2350-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2350-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2350-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2351" : helpers.makeTestYear("Brazil/East", [
		["2351-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2351-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2351-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2351-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2352" : helpers.makeTestYear("Brazil/East", [
		["2352-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2352-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2352-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2352-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2353" : helpers.makeTestYear("Brazil/East", [
		["2353-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2353-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2353-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2353-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2354" : helpers.makeTestYear("Brazil/East", [
		["2354-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2354-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2354-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2354-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2355" : helpers.makeTestYear("Brazil/East", [
		["2355-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2355-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2355-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2355-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2356" : helpers.makeTestYear("Brazil/East", [
		["2356-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2356-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2356-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2356-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2357" : helpers.makeTestYear("Brazil/East", [
		["2357-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2357-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2357-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2357-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2358" : helpers.makeTestYear("Brazil/East", [
		["2358-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2358-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2358-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2358-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2359" : helpers.makeTestYear("Brazil/East", [
		["2359-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2359-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2359-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2359-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2360" : helpers.makeTestYear("Brazil/East", [
		["2360-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2360-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2360-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2360-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2361" : helpers.makeTestYear("Brazil/East", [
		["2361-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2361-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2361-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2361-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2362" : helpers.makeTestYear("Brazil/East", [
		["2362-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2362-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2362-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2362-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2363" : helpers.makeTestYear("Brazil/East", [
		["2363-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2363-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2363-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2363-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2364" : helpers.makeTestYear("Brazil/East", [
		["2364-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2364-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2364-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2364-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2365" : helpers.makeTestYear("Brazil/East", [
		["2365-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2365-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2365-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2365-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2366" : helpers.makeTestYear("Brazil/East", [
		["2366-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2366-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2366-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2366-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2367" : helpers.makeTestYear("Brazil/East", [
		["2367-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2367-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2367-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2367-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2368" : helpers.makeTestYear("Brazil/East", [
		["2368-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2368-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2368-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2368-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2369" : helpers.makeTestYear("Brazil/East", [
		["2369-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2369-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2369-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2369-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2370" : helpers.makeTestYear("Brazil/East", [
		["2370-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2370-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2370-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2370-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2371" : helpers.makeTestYear("Brazil/East", [
		["2371-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2371-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2371-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2371-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2372" : helpers.makeTestYear("Brazil/East", [
		["2372-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2372-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2372-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2372-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2373" : helpers.makeTestYear("Brazil/East", [
		["2373-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2373-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2373-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2373-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2374" : helpers.makeTestYear("Brazil/East", [
		["2374-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2374-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2374-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2374-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2375" : helpers.makeTestYear("Brazil/East", [
		["2375-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2375-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2375-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2375-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2376" : helpers.makeTestYear("Brazil/East", [
		["2376-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2376-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2376-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2376-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2377" : helpers.makeTestYear("Brazil/East", [
		["2377-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2377-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2377-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2377-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2378" : helpers.makeTestYear("Brazil/East", [
		["2378-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2378-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2378-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2378-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2379" : helpers.makeTestYear("Brazil/East", [
		["2379-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2379-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2379-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2379-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2380" : helpers.makeTestYear("Brazil/East", [
		["2380-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2380-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2380-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2380-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2381" : helpers.makeTestYear("Brazil/East", [
		["2381-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2381-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2381-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2381-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2382" : helpers.makeTestYear("Brazil/East", [
		["2382-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2382-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2382-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2382-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2383" : helpers.makeTestYear("Brazil/East", [
		["2383-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2383-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2383-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2383-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2384" : helpers.makeTestYear("Brazil/East", [
		["2384-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2384-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2384-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2384-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2385" : helpers.makeTestYear("Brazil/East", [
		["2385-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2385-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2385-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2385-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2386" : helpers.makeTestYear("Brazil/East", [
		["2386-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2386-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2386-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2386-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2387" : helpers.makeTestYear("Brazil/East", [
		["2387-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2387-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2387-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2387-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2388" : helpers.makeTestYear("Brazil/East", [
		["2388-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2388-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2388-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2388-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2389" : helpers.makeTestYear("Brazil/East", [
		["2389-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2389-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2389-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2389-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2390" : helpers.makeTestYear("Brazil/East", [
		["2390-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2390-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2390-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2390-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2391" : helpers.makeTestYear("Brazil/East", [
		["2391-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2391-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2391-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2391-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2392" : helpers.makeTestYear("Brazil/East", [
		["2392-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2392-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2392-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2392-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2393" : helpers.makeTestYear("Brazil/East", [
		["2393-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2393-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2393-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2393-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2394" : helpers.makeTestYear("Brazil/East", [
		["2394-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2394-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2394-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2394-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2395" : helpers.makeTestYear("Brazil/East", [
		["2395-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2395-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2395-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2395-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2396" : helpers.makeTestYear("Brazil/East", [
		["2396-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2396-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2396-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2396-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2397" : helpers.makeTestYear("Brazil/East", [
		["2397-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2397-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2397-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2397-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2398" : helpers.makeTestYear("Brazil/East", [
		["2398-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2398-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2398-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2398-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2399" : helpers.makeTestYear("Brazil/East", [
		["2399-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2399-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2399-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2399-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2400" : helpers.makeTestYear("Brazil/East", [
		["2400-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2400-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2400-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2400-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2401" : helpers.makeTestYear("Brazil/East", [
		["2401-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2401-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2401-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2401-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2402" : helpers.makeTestYear("Brazil/East", [
		["2402-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2402-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2402-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2402-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2403" : helpers.makeTestYear("Brazil/East", [
		["2403-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2403-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2403-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2403-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2404" : helpers.makeTestYear("Brazil/East", [
		["2404-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2404-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2404-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2404-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2405" : helpers.makeTestYear("Brazil/East", [
		["2405-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2405-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2405-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2405-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2406" : helpers.makeTestYear("Brazil/East", [
		["2406-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2406-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2406-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2406-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2407" : helpers.makeTestYear("Brazil/East", [
		["2407-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2407-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2407-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2407-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2408" : helpers.makeTestYear("Brazil/East", [
		["2408-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2408-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2408-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2408-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2409" : helpers.makeTestYear("Brazil/East", [
		["2409-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2409-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2409-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2409-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2410" : helpers.makeTestYear("Brazil/East", [
		["2410-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2410-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2410-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2410-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2411" : helpers.makeTestYear("Brazil/East", [
		["2411-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2411-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2411-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2411-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2412" : helpers.makeTestYear("Brazil/East", [
		["2412-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2412-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2412-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2412-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2413" : helpers.makeTestYear("Brazil/East", [
		["2413-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2413-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2413-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2413-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2414" : helpers.makeTestYear("Brazil/East", [
		["2414-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2414-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2414-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2414-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2415" : helpers.makeTestYear("Brazil/East", [
		["2415-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2415-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2415-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2415-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2416" : helpers.makeTestYear("Brazil/East", [
		["2416-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2416-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2416-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2416-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2417" : helpers.makeTestYear("Brazil/East", [
		["2417-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2417-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2417-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2417-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2418" : helpers.makeTestYear("Brazil/East", [
		["2418-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2418-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2418-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2418-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2419" : helpers.makeTestYear("Brazil/East", [
		["2419-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2419-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2419-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2419-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2420" : helpers.makeTestYear("Brazil/East", [
		["2420-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2420-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2420-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2420-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2421" : helpers.makeTestYear("Brazil/East", [
		["2421-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2421-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2421-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2421-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2422" : helpers.makeTestYear("Brazil/East", [
		["2422-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2422-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2422-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2422-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2423" : helpers.makeTestYear("Brazil/East", [
		["2423-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2423-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2423-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2423-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2424" : helpers.makeTestYear("Brazil/East", [
		["2424-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2424-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2424-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2424-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2425" : helpers.makeTestYear("Brazil/East", [
		["2425-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2425-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2425-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2425-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2426" : helpers.makeTestYear("Brazil/East", [
		["2426-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2426-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2426-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2426-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2427" : helpers.makeTestYear("Brazil/East", [
		["2427-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2427-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2427-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2427-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2428" : helpers.makeTestYear("Brazil/East", [
		["2428-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2428-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2428-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2428-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2429" : helpers.makeTestYear("Brazil/East", [
		["2429-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2429-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2429-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2429-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2430" : helpers.makeTestYear("Brazil/East", [
		["2430-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2430-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2430-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2430-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2431" : helpers.makeTestYear("Brazil/East", [
		["2431-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2431-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2431-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2431-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2432" : helpers.makeTestYear("Brazil/East", [
		["2432-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2432-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2432-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2432-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2433" : helpers.makeTestYear("Brazil/East", [
		["2433-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2433-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2433-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2433-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2434" : helpers.makeTestYear("Brazil/East", [
		["2434-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2434-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2434-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2434-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2435" : helpers.makeTestYear("Brazil/East", [
		["2435-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2435-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2435-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2435-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2436" : helpers.makeTestYear("Brazil/East", [
		["2436-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2436-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2436-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2436-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2437" : helpers.makeTestYear("Brazil/East", [
		["2437-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2437-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2437-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2437-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2438" : helpers.makeTestYear("Brazil/East", [
		["2438-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2438-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2438-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2438-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2439" : helpers.makeTestYear("Brazil/East", [
		["2439-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2439-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2439-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2439-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2440" : helpers.makeTestYear("Brazil/East", [
		["2440-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2440-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2440-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2440-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2441" : helpers.makeTestYear("Brazil/East", [
		["2441-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2441-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2441-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2441-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2442" : helpers.makeTestYear("Brazil/East", [
		["2442-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2442-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2442-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2442-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2443" : helpers.makeTestYear("Brazil/East", [
		["2443-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2443-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2443-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2443-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2444" : helpers.makeTestYear("Brazil/East", [
		["2444-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2444-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2444-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2444-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2445" : helpers.makeTestYear("Brazil/East", [
		["2445-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2445-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2445-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2445-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2446" : helpers.makeTestYear("Brazil/East", [
		["2446-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2446-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2446-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2446-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2447" : helpers.makeTestYear("Brazil/East", [
		["2447-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2447-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2447-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2447-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2448" : helpers.makeTestYear("Brazil/East", [
		["2448-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2448-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2448-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2448-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2449" : helpers.makeTestYear("Brazil/East", [
		["2449-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2449-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2449-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2449-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2450" : helpers.makeTestYear("Brazil/East", [
		["2450-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2450-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2450-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2450-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2451" : helpers.makeTestYear("Brazil/East", [
		["2451-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2451-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2451-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2451-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2452" : helpers.makeTestYear("Brazil/East", [
		["2452-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2452-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2452-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2452-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2453" : helpers.makeTestYear("Brazil/East", [
		["2453-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2453-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2453-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2453-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2454" : helpers.makeTestYear("Brazil/East", [
		["2454-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2454-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2454-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2454-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2455" : helpers.makeTestYear("Brazil/East", [
		["2455-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2455-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2455-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2455-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2456" : helpers.makeTestYear("Brazil/East", [
		["2456-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2456-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2456-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2456-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2457" : helpers.makeTestYear("Brazil/East", [
		["2457-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2457-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2457-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2457-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2458" : helpers.makeTestYear("Brazil/East", [
		["2458-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2458-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2458-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2458-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2459" : helpers.makeTestYear("Brazil/East", [
		["2459-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2459-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2459-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2459-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2460" : helpers.makeTestYear("Brazil/East", [
		["2460-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2460-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2460-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2460-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2461" : helpers.makeTestYear("Brazil/East", [
		["2461-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2461-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2461-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2461-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2462" : helpers.makeTestYear("Brazil/East", [
		["2462-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2462-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2462-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2462-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2463" : helpers.makeTestYear("Brazil/East", [
		["2463-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2463-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2463-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2463-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2464" : helpers.makeTestYear("Brazil/East", [
		["2464-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2464-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2464-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2464-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2465" : helpers.makeTestYear("Brazil/East", [
		["2465-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2465-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2465-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2465-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2466" : helpers.makeTestYear("Brazil/East", [
		["2466-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2466-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2466-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2466-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2467" : helpers.makeTestYear("Brazil/East", [
		["2467-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2467-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2467-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2467-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2468" : helpers.makeTestYear("Brazil/East", [
		["2468-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2468-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2468-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2468-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2469" : helpers.makeTestYear("Brazil/East", [
		["2469-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2469-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2469-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2469-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2470" : helpers.makeTestYear("Brazil/East", [
		["2470-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2470-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2470-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2470-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2471" : helpers.makeTestYear("Brazil/East", [
		["2471-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2471-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2471-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2471-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2472" : helpers.makeTestYear("Brazil/East", [
		["2472-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2472-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2472-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2472-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2473" : helpers.makeTestYear("Brazil/East", [
		["2473-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2473-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2473-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2473-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2474" : helpers.makeTestYear("Brazil/East", [
		["2474-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2474-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2474-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2474-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2475" : helpers.makeTestYear("Brazil/East", [
		["2475-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2475-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2475-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2475-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2476" : helpers.makeTestYear("Brazil/East", [
		["2476-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2476-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2476-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2476-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2477" : helpers.makeTestYear("Brazil/East", [
		["2477-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2477-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2477-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2477-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2478" : helpers.makeTestYear("Brazil/East", [
		["2478-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2478-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2478-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2478-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2479" : helpers.makeTestYear("Brazil/East", [
		["2479-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2479-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2479-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2479-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2480" : helpers.makeTestYear("Brazil/East", [
		["2480-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2480-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2480-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2480-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2481" : helpers.makeTestYear("Brazil/East", [
		["2481-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2481-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2481-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2481-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2482" : helpers.makeTestYear("Brazil/East", [
		["2482-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2482-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2482-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2482-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2483" : helpers.makeTestYear("Brazil/East", [
		["2483-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2483-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2483-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2483-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2484" : helpers.makeTestYear("Brazil/East", [
		["2484-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2484-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2484-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2484-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2485" : helpers.makeTestYear("Brazil/East", [
		["2485-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2485-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2485-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2485-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2486" : helpers.makeTestYear("Brazil/East", [
		["2486-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2486-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2486-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2486-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2487" : helpers.makeTestYear("Brazil/East", [
		["2487-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2487-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2487-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2487-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2488" : helpers.makeTestYear("Brazil/East", [
		["2488-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2488-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2488-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2488-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2489" : helpers.makeTestYear("Brazil/East", [
		["2489-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2489-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2489-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2489-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2490" : helpers.makeTestYear("Brazil/East", [
		["2490-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2490-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2490-11-05T02:59:59+00:00", "23:59:59", "-03", 180],
		["2490-11-05T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2491" : helpers.makeTestYear("Brazil/East", [
		["2491-02-18T01:59:59+00:00", "23:59:59", "-02", 120],
		["2491-02-18T02:00:00+00:00", "23:00:00", "-03", 180],
		["2491-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2491-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2492" : helpers.makeTestYear("Brazil/East", [
		["2492-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2492-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2492-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2492-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2493" : helpers.makeTestYear("Brazil/East", [
		["2493-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2493-02-15T02:00:00+00:00", "23:00:00", "-03", 180],
		["2493-11-01T02:59:59+00:00", "23:59:59", "-03", 180],
		["2493-11-01T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2494" : helpers.makeTestYear("Brazil/East", [
		["2494-02-21T01:59:59+00:00", "23:59:59", "-02", 120],
		["2494-02-21T02:00:00+00:00", "23:00:00", "-03", 180],
		["2494-11-07T02:59:59+00:00", "23:59:59", "-03", 180],
		["2494-11-07T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2495" : helpers.makeTestYear("Brazil/East", [
		["2495-02-20T01:59:59+00:00", "23:59:59", "-02", 120],
		["2495-02-20T02:00:00+00:00", "23:00:00", "-03", 180],
		["2495-11-06T02:59:59+00:00", "23:59:59", "-03", 180],
		["2495-11-06T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2496" : helpers.makeTestYear("Brazil/East", [
		["2496-02-19T01:59:59+00:00", "23:59:59", "-02", 120],
		["2496-02-19T02:00:00+00:00", "23:00:00", "-03", 180],
		["2496-11-04T02:59:59+00:00", "23:59:59", "-03", 180],
		["2496-11-04T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2497" : helpers.makeTestYear("Brazil/East", [
		["2497-02-17T01:59:59+00:00", "23:59:59", "-02", 120],
		["2497-02-17T02:00:00+00:00", "23:00:00", "-03", 180],
		["2497-11-03T02:59:59+00:00", "23:59:59", "-03", 180],
		["2497-11-03T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2498" : helpers.makeTestYear("Brazil/East", [
		["2498-02-16T01:59:59+00:00", "23:59:59", "-02", 120],
		["2498-02-16T02:00:00+00:00", "23:00:00", "-03", 180],
		["2498-11-02T02:59:59+00:00", "23:59:59", "-03", 180],
		["2498-11-02T03:00:00+00:00", "01:00:00", "-02", 120]
	]),

	"2499" : helpers.makeTestYear("Brazil/East", [
		["2499-02-15T01:59:59+00:00", "23:59:59", "-02", 120],
		["2499-02-15T02:00:00+00:00", "23:00:00", "-03", 180]
	])
};