"use strict";

var helpers = require("../../helpers/helpers");

exports["America/Bahia_Banderas"] = {

	"guess:by:offset" : helpers.makeTestGuess("America/Bahia_Banderas", { offset: true, expect: "America/Mexico_City" }),

	"guess:by:abbr" : helpers.makeTestGuess("America/Bahia_Banderas", { abbr: true, expect: "America/Mexico_City" }),

	"1927" : helpers.makeTestYear("America/Bahia_Banderas", [
		["1927-06-11T05:59:59+00:00", "22:59:59", "MST", 420],
		["1927-06-11T06:00:00+00:00", "00:00:00", "CST", 360]
	]),

	"1930" : helpers.makeTestYear("America/Bahia_Banderas", [
		["1930-11-15T05:59:59+00:00", "23:59:59", "CST", 360],
		["1930-11-15T06:00:00+00:00", "23:00:00", "MST", 420]
	]),

	"1931" : helpers.makeTestYear("America/Bahia_Banderas", [
		["1931-05-02T05:59:59+00:00", "22:59:59", "MST", 420],
		["1931-05-02T06:00:00+00:00", "00:00:00", "CST", 360],
		["1931-10-01T05:59:59+00:00", "23:59:59", "CST", 360],
		["1931-10-01T06:00:00+00:00", "23:00:00", "MST", 420]
	]),

	"1932" : helpers.makeTestYear("America/Bahia_Banderas", [
		["1932-04-01T06:59:59+00:00", "23:59:59", "MST", 420],
		["1932-04-01T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"1942" : helpers.makeTestYear("America/Bahia_Banderas", [
		["1942-04-24T05:59:59+00:00", "23:59:59", "CST", 360],
		["1942-04-24T06:00:00+00:00", "23:00:00", "MST", 420]
	]),

	"1949" : helpers.makeTestYear("America/Bahia_Banderas", [
		["1949-01-14T06:59:59+00:00", "23:59:59", "MST", 420],
		["1949-01-14T07:00:00+00:00", "23:00:00", "PST", 480]
	]),

	"1970" : helpers.makeTestYear("America/Bahia_Banderas", [
		["1970-01-01T07:59:59+00:00", "23:59:59", "PST", 480],
		["1970-01-01T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1996" : helpers.makeTestYear("America/Bahia_Banderas", [
		["1996-04-07T08:59:59+00:00", "01:59:59", "MST", 420],
		["1996-04-07T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1996-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1996-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1997" : helpers.makeTestYear("America/Bahia_Banderas", [
		["1997-04-06T08:59:59+00:00", "01:59:59", "MST", 420],
		["1997-04-06T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1997-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1997-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1998" : helpers.makeTestYear("America/Bahia_Banderas", [
		["1998-04-05T08:59:59+00:00", "01:59:59", "MST", 420],
		["1998-04-05T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1998-10-25T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1998-10-25T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"1999" : helpers.makeTestYear("America/Bahia_Banderas", [
		["1999-04-04T08:59:59+00:00", "01:59:59", "MST", 420],
		["1999-04-04T09:00:00+00:00", "03:00:00", "MDT", 360],
		["1999-10-31T07:59:59+00:00", "01:59:59", "MDT", 360],
		["1999-10-31T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2000" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2000-04-02T08:59:59+00:00", "01:59:59", "MST", 420],
		["2000-04-02T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2000-10-29T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2000-10-29T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2001" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2001-05-06T08:59:59+00:00", "01:59:59", "MST", 420],
		["2001-05-06T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2001-09-30T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2001-09-30T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2002" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2002-04-07T08:59:59+00:00", "01:59:59", "MST", 420],
		["2002-04-07T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2002-10-27T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2002-10-27T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2003" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2003-04-06T08:59:59+00:00", "01:59:59", "MST", 420],
		["2003-04-06T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2003-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2003-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2004" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2004-04-04T08:59:59+00:00", "01:59:59", "MST", 420],
		["2004-04-04T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2004-10-31T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2004-10-31T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2005" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2005-04-03T08:59:59+00:00", "01:59:59", "MST", 420],
		["2005-04-03T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2005-10-30T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2005-10-30T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2006" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2006-04-02T08:59:59+00:00", "01:59:59", "MST", 420],
		["2006-04-02T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2006-10-29T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2006-10-29T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2007" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2007-04-01T08:59:59+00:00", "01:59:59", "MST", 420],
		["2007-04-01T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2007-10-28T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2007-10-28T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2008" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2008-04-06T08:59:59+00:00", "01:59:59", "MST", 420],
		["2008-04-06T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2008-10-26T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2008-10-26T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2009" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2009-04-05T08:59:59+00:00", "01:59:59", "MST", 420],
		["2009-04-05T09:00:00+00:00", "03:00:00", "MDT", 360],
		["2009-10-25T07:59:59+00:00", "01:59:59", "MDT", 360],
		["2009-10-25T08:00:00+00:00", "01:00:00", "MST", 420]
	]),

	"2010" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2010-04-04T08:59:59+00:00", "01:59:59", "MST", 420],
		["2010-04-04T09:00:00+00:00", "04:00:00", "CDT", 300],
		["2010-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2010-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2011" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2011-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2011-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2011-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2011-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2012" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2012-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2012-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2012-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2012-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2013" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2013-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2013-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2013-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2013-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2014" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2014-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2014-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2014-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2014-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2015" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2015-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2015-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2015-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2015-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2016" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2016-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2016-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2016-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2016-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2017" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2017-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2017-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2017-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2017-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2018" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2018-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2018-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2018-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2018-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2019" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2019-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2019-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2019-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2019-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2020" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2020-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2020-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2020-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2020-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2021" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2021-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2021-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2021-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2021-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2022" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2022-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2022-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2022-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2022-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2023" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2023-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2023-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2023-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2023-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2024" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2024-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2024-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2024-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2024-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2025" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2025-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2025-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2025-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2025-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2026" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2026-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2026-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2026-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2026-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2027" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2027-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2027-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2027-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2027-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2028" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2028-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2028-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2028-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2028-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2029" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2029-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2029-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2029-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2029-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2030" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2030-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2030-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2030-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2030-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2031" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2031-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2031-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2031-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2031-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2032" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2032-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2032-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2032-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2032-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2033" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2033-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2033-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2033-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2033-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2034" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2034-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2034-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2034-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2034-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2035" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2035-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2035-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2035-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2035-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2036" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2036-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2036-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2036-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2036-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2037" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2037-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2037-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2037-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2037-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2038" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2038-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2038-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2038-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2038-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2039" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2039-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2039-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2039-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2039-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2040" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2040-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2040-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2040-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2040-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2041" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2041-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2041-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2041-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2041-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2042" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2042-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2042-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2042-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2042-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2043" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2043-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2043-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2043-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2043-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2044" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2044-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2044-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2044-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2044-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2045" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2045-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2045-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2045-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2045-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2046" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2046-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2046-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2046-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2046-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2047" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2047-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2047-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2047-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2047-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2048" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2048-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2048-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2048-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2048-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2049" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2049-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2049-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2049-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2049-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2050" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2050-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2050-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2050-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2050-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2051" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2051-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2051-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2051-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2051-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2052" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2052-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2052-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2052-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2052-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2053" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2053-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2053-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2053-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2053-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2054" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2054-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2054-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2054-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2054-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2055" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2055-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2055-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2055-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2055-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2056" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2056-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2056-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2056-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2056-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2057" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2057-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2057-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2057-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2057-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2058" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2058-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2058-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2058-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2058-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2059" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2059-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2059-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2059-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2059-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2060" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2060-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2060-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2060-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2060-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2061" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2061-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2061-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2061-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2061-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2062" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2062-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2062-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2062-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2062-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2063" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2063-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2063-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2063-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2063-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2064" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2064-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2064-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2064-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2064-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2065" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2065-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2065-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2065-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2065-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2066" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2066-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2066-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2066-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2066-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2067" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2067-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2067-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2067-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2067-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2068" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2068-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2068-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2068-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2068-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2069" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2069-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2069-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2069-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2069-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2070" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2070-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2070-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2070-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2070-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2071" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2071-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2071-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2071-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2071-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2072" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2072-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2072-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2072-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2072-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2073" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2073-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2073-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2073-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2073-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2074" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2074-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2074-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2074-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2074-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2075" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2075-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2075-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2075-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2075-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2076" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2076-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2076-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2076-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2076-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2077" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2077-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2077-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2077-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2077-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2078" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2078-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2078-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2078-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2078-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2079" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2079-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2079-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2079-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2079-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2080" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2080-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2080-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2080-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2080-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2081" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2081-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2081-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2081-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2081-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2082" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2082-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2082-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2082-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2082-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2083" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2083-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2083-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2083-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2083-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2084" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2084-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2084-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2084-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2084-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2085" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2085-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2085-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2085-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2085-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2086" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2086-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2086-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2086-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2086-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2087" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2087-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2087-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2087-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2087-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2088" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2088-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2088-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2088-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2088-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2089" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2089-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2089-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2089-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2089-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2090" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2090-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2090-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2090-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2090-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2091" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2091-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2091-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2091-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2091-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2092" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2092-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2092-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2092-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2092-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2093" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2093-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2093-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2093-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2093-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2094" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2094-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2094-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2094-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2094-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2095" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2095-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2095-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2095-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2095-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2096" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2096-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2096-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2096-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2096-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2097" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2097-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2097-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2097-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2097-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2098" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2098-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2098-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2098-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2098-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2099" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2099-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2099-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2099-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2099-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2100" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2100-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2100-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2100-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2100-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2101" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2101-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2101-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2101-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2101-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2102" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2102-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2102-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2102-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2102-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2103" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2103-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2103-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2103-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2103-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2104" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2104-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2104-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2104-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2104-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2105" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2105-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2105-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2105-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2105-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2106" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2106-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2106-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2106-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2106-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2107" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2107-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2107-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2107-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2107-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2108" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2108-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2108-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2108-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2108-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2109" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2109-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2109-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2109-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2109-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2110" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2110-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2110-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2110-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2110-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2111" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2111-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2111-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2111-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2111-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2112" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2112-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2112-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2112-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2112-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2113" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2113-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2113-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2113-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2113-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2114" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2114-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2114-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2114-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2114-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2115" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2115-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2115-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2115-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2115-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2116" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2116-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2116-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2116-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2116-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2117" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2117-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2117-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2117-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2117-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2118" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2118-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2118-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2118-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2118-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2119" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2119-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2119-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2119-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2119-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2120" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2120-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2120-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2120-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2120-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2121" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2121-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2121-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2121-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2121-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2122" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2122-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2122-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2122-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2122-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2123" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2123-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2123-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2123-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2123-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2124" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2124-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2124-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2124-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2124-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2125" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2125-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2125-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2125-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2125-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2126" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2126-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2126-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2126-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2126-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2127" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2127-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2127-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2127-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2127-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2128" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2128-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2128-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2128-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2128-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2129" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2129-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2129-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2129-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2129-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2130" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2130-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2130-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2130-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2130-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2131" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2131-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2131-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2131-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2131-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2132" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2132-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2132-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2132-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2132-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2133" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2133-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2133-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2133-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2133-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2134" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2134-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2134-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2134-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2134-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2135" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2135-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2135-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2135-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2135-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2136" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2136-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2136-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2136-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2136-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2137" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2137-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2137-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2137-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2137-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2138" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2138-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2138-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2138-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2138-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2139" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2139-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2139-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2139-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2139-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2140" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2140-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2140-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2140-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2140-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2141" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2141-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2141-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2141-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2141-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2142" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2142-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2142-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2142-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2142-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2143" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2143-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2143-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2143-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2143-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2144" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2144-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2144-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2144-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2144-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2145" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2145-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2145-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2145-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2145-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2146" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2146-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2146-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2146-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2146-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2147" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2147-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2147-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2147-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2147-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2148" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2148-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2148-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2148-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2148-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2149" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2149-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2149-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2149-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2149-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2150" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2150-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2150-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2150-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2150-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2151" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2151-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2151-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2151-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2151-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2152" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2152-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2152-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2152-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2152-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2153" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2153-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2153-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2153-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2153-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2154" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2154-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2154-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2154-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2154-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2155" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2155-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2155-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2155-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2155-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2156" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2156-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2156-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2156-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2156-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2157" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2157-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2157-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2157-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2157-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2158" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2158-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2158-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2158-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2158-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2159" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2159-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2159-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2159-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2159-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2160" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2160-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2160-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2160-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2160-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2161" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2161-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2161-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2161-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2161-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2162" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2162-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2162-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2162-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2162-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2163" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2163-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2163-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2163-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2163-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2164" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2164-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2164-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2164-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2164-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2165" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2165-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2165-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2165-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2165-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2166" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2166-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2166-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2166-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2166-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2167" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2167-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2167-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2167-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2167-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2168" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2168-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2168-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2168-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2168-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2169" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2169-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2169-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2169-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2169-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2170" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2170-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2170-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2170-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2170-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2171" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2171-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2171-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2171-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2171-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2172" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2172-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2172-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2172-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2172-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2173" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2173-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2173-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2173-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2173-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2174" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2174-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2174-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2174-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2174-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2175" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2175-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2175-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2175-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2175-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2176" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2176-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2176-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2176-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2176-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2177" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2177-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2177-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2177-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2177-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2178" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2178-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2178-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2178-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2178-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2179" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2179-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2179-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2179-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2179-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2180" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2180-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2180-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2180-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2180-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2181" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2181-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2181-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2181-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2181-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2182" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2182-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2182-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2182-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2182-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2183" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2183-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2183-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2183-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2183-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2184" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2184-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2184-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2184-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2184-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2185" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2185-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2185-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2185-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2185-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2186" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2186-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2186-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2186-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2186-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2187" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2187-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2187-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2187-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2187-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2188" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2188-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2188-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2188-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2188-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2189" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2189-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2189-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2189-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2189-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2190" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2190-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2190-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2190-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2190-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2191" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2191-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2191-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2191-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2191-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2192" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2192-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2192-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2192-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2192-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2193" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2193-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2193-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2193-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2193-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2194" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2194-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2194-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2194-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2194-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2195" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2195-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2195-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2195-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2195-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2196" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2196-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2196-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2196-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2196-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2197" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2197-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2197-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2197-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2197-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2198" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2198-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2198-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2198-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2198-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2199" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2199-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2199-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2199-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2199-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2200" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2200-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2200-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2200-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2200-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2201" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2201-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2201-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2201-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2201-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2202" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2202-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2202-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2202-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2202-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2203" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2203-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2203-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2203-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2203-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2204" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2204-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2204-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2204-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2204-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2205" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2205-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2205-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2205-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2205-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2206" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2206-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2206-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2206-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2206-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2207" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2207-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2207-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2207-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2207-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2208" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2208-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2208-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2208-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2208-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2209" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2209-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2209-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2209-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2209-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2210" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2210-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2210-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2210-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2210-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2211" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2211-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2211-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2211-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2211-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2212" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2212-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2212-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2212-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2212-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2213" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2213-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2213-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2213-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2213-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2214" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2214-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2214-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2214-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2214-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2215" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2215-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2215-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2215-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2215-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2216" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2216-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2216-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2216-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2216-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2217" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2217-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2217-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2217-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2217-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2218" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2218-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2218-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2218-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2218-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2219" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2219-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2219-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2219-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2219-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2220" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2220-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2220-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2220-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2220-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2221" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2221-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2221-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2221-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2221-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2222" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2222-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2222-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2222-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2222-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2223" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2223-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2223-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2223-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2223-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2224" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2224-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2224-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2224-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2224-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2225" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2225-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2225-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2225-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2225-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2226" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2226-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2226-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2226-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2226-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2227" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2227-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2227-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2227-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2227-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2228" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2228-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2228-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2228-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2228-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2229" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2229-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2229-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2229-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2229-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2230" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2230-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2230-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2230-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2230-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2231" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2231-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2231-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2231-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2231-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2232" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2232-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2232-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2232-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2232-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2233" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2233-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2233-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2233-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2233-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2234" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2234-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2234-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2234-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2234-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2235" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2235-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2235-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2235-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2235-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2236" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2236-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2236-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2236-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2236-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2237" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2237-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2237-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2237-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2237-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2238" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2238-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2238-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2238-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2238-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2239" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2239-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2239-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2239-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2239-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2240" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2240-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2240-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2240-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2240-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2241" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2241-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2241-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2241-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2241-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2242" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2242-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2242-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2242-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2242-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2243" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2243-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2243-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2243-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2243-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2244" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2244-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2244-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2244-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2244-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2245" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2245-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2245-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2245-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2245-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2246" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2246-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2246-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2246-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2246-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2247" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2247-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2247-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2247-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2247-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2248" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2248-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2248-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2248-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2248-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2249" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2249-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2249-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2249-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2249-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2250" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2250-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2250-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2250-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2250-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2251" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2251-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2251-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2251-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2251-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2252" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2252-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2252-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2252-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2252-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2253" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2253-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2253-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2253-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2253-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2254" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2254-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2254-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2254-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2254-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2255" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2255-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2255-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2255-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2255-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2256" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2256-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2256-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2256-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2256-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2257" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2257-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2257-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2257-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2257-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2258" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2258-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2258-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2258-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2258-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2259" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2259-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2259-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2259-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2259-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2260" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2260-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2260-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2260-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2260-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2261" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2261-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2261-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2261-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2261-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2262" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2262-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2262-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2262-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2262-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2263" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2263-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2263-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2263-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2263-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2264" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2264-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2264-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2264-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2264-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2265" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2265-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2265-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2265-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2265-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2266" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2266-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2266-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2266-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2266-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2267" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2267-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2267-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2267-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2267-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2268" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2268-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2268-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2268-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2268-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2269" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2269-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2269-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2269-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2269-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2270" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2270-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2270-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2270-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2270-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2271" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2271-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2271-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2271-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2271-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2272" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2272-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2272-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2272-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2272-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2273" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2273-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2273-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2273-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2273-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2274" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2274-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2274-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2274-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2274-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2275" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2275-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2275-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2275-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2275-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2276" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2276-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2276-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2276-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2276-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2277" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2277-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2277-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2277-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2277-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2278" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2278-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2278-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2278-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2278-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2279" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2279-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2279-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2279-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2279-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2280" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2280-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2280-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2280-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2280-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2281" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2281-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2281-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2281-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2281-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2282" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2282-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2282-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2282-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2282-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2283" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2283-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2283-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2283-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2283-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2284" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2284-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2284-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2284-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2284-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2285" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2285-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2285-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2285-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2285-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2286" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2286-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2286-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2286-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2286-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2287" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2287-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2287-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2287-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2287-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2288" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2288-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2288-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2288-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2288-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2289" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2289-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2289-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2289-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2289-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2290" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2290-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2290-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2290-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2290-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2291" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2291-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2291-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2291-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2291-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2292" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2292-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2292-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2292-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2292-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2293" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2293-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2293-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2293-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2293-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2294" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2294-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2294-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2294-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2294-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2295" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2295-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2295-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2295-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2295-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2296" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2296-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2296-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2296-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2296-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2297" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2297-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2297-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2297-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2297-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2298" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2298-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2298-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2298-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2298-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2299" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2299-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2299-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2299-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2299-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2300" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2300-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2300-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2300-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2300-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2301" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2301-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2301-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2301-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2301-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2302" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2302-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2302-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2302-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2302-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2303" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2303-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2303-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2303-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2303-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2304" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2304-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2304-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2304-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2304-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2305" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2305-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2305-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2305-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2305-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2306" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2306-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2306-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2306-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2306-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2307" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2307-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2307-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2307-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2307-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2308" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2308-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2308-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2308-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2308-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2309" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2309-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2309-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2309-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2309-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2310" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2310-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2310-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2310-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2310-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2311" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2311-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2311-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2311-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2311-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2312" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2312-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2312-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2312-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2312-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2313" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2313-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2313-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2313-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2313-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2314" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2314-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2314-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2314-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2314-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2315" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2315-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2315-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2315-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2315-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2316" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2316-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2316-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2316-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2316-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2317" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2317-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2317-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2317-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2317-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2318" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2318-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2318-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2318-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2318-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2319" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2319-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2319-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2319-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2319-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2320" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2320-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2320-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2320-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2320-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2321" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2321-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2321-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2321-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2321-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2322" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2322-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2322-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2322-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2322-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2323" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2323-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2323-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2323-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2323-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2324" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2324-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2324-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2324-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2324-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2325" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2325-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2325-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2325-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2325-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2326" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2326-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2326-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2326-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2326-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2327" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2327-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2327-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2327-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2327-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2328" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2328-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2328-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2328-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2328-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2329" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2329-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2329-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2329-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2329-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2330" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2330-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2330-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2330-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2330-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2331" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2331-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2331-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2331-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2331-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2332" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2332-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2332-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2332-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2332-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2333" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2333-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2333-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2333-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2333-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2334" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2334-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2334-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2334-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2334-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2335" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2335-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2335-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2335-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2335-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2336" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2336-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2336-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2336-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2336-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2337" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2337-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2337-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2337-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2337-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2338" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2338-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2338-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2338-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2338-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2339" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2339-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2339-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2339-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2339-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2340" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2340-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2340-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2340-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2340-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2341" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2341-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2341-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2341-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2341-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2342" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2342-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2342-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2342-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2342-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2343" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2343-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2343-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2343-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2343-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2344" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2344-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2344-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2344-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2344-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2345" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2345-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2345-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2345-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2345-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2346" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2346-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2346-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2346-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2346-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2347" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2347-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2347-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2347-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2347-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2348" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2348-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2348-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2348-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2348-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2349" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2349-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2349-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2349-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2349-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2350" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2350-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2350-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2350-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2350-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2351" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2351-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2351-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2351-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2351-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2352" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2352-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2352-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2352-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2352-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2353" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2353-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2353-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2353-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2353-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2354" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2354-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2354-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2354-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2354-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2355" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2355-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2355-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2355-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2355-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2356" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2356-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2356-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2356-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2356-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2357" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2357-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2357-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2357-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2357-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2358" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2358-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2358-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2358-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2358-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2359" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2359-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2359-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2359-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2359-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2360" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2360-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2360-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2360-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2360-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2361" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2361-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2361-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2361-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2361-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2362" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2362-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2362-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2362-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2362-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2363" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2363-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2363-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2363-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2363-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2364" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2364-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2364-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2364-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2364-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2365" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2365-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2365-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2365-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2365-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2366" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2366-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2366-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2366-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2366-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2367" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2367-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2367-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2367-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2367-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2368" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2368-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2368-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2368-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2368-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2369" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2369-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2369-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2369-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2369-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2370" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2370-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2370-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2370-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2370-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2371" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2371-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2371-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2371-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2371-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2372" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2372-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2372-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2372-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2372-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2373" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2373-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2373-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2373-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2373-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2374" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2374-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2374-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2374-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2374-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2375" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2375-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2375-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2375-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2375-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2376" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2376-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2376-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2376-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2376-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2377" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2377-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2377-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2377-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2377-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2378" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2378-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2378-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2378-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2378-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2379" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2379-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2379-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2379-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2379-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2380" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2380-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2380-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2380-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2380-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2381" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2381-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2381-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2381-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2381-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2382" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2382-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2382-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2382-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2382-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2383" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2383-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2383-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2383-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2383-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2384" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2384-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2384-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2384-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2384-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2385" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2385-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2385-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2385-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2385-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2386" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2386-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2386-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2386-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2386-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2387" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2387-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2387-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2387-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2387-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2388" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2388-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2388-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2388-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2388-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2389" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2389-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2389-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2389-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2389-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2390" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2390-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2390-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2390-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2390-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2391" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2391-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2391-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2391-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2391-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2392" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2392-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2392-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2392-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2392-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2393" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2393-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2393-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2393-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2393-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2394" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2394-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2394-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2394-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2394-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2395" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2395-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2395-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2395-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2395-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2396" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2396-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2396-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2396-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2396-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2397" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2397-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2397-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2397-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2397-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2398" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2398-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2398-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2398-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2398-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2399" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2399-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2399-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2399-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2399-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2400" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2400-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2400-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2400-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2400-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2401" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2401-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2401-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2401-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2401-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2402" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2402-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2402-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2402-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2402-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2403" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2403-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2403-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2403-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2403-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2404" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2404-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2404-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2404-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2404-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2405" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2405-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2405-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2405-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2405-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2406" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2406-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2406-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2406-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2406-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2407" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2407-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2407-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2407-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2407-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2408" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2408-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2408-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2408-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2408-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2409" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2409-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2409-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2409-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2409-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2410" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2410-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2410-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2410-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2410-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2411" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2411-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2411-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2411-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2411-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2412" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2412-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2412-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2412-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2412-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2413" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2413-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2413-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2413-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2413-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2414" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2414-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2414-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2414-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2414-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2415" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2415-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2415-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2415-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2415-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2416" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2416-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2416-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2416-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2416-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2417" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2417-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2417-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2417-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2417-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2418" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2418-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2418-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2418-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2418-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2419" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2419-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2419-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2419-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2419-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2420" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2420-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2420-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2420-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2420-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2421" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2421-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2421-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2421-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2421-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2422" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2422-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2422-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2422-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2422-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2423" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2423-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2423-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2423-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2423-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2424" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2424-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2424-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2424-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2424-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2425" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2425-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2425-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2425-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2425-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2426" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2426-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2426-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2426-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2426-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2427" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2427-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2427-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2427-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2427-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2428" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2428-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2428-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2428-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2428-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2429" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2429-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2429-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2429-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2429-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2430" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2430-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2430-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2430-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2430-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2431" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2431-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2431-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2431-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2431-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2432" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2432-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2432-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2432-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2432-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2433" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2433-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2433-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2433-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2433-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2434" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2434-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2434-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2434-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2434-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2435" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2435-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2435-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2435-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2435-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2436" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2436-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2436-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2436-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2436-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2437" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2437-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2437-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2437-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2437-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2438" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2438-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2438-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2438-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2438-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2439" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2439-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2439-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2439-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2439-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2440" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2440-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2440-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2440-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2440-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2441" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2441-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2441-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2441-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2441-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2442" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2442-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2442-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2442-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2442-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2443" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2443-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2443-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2443-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2443-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2444" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2444-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2444-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2444-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2444-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2445" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2445-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2445-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2445-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2445-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2446" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2446-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2446-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2446-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2446-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2447" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2447-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2447-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2447-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2447-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2448" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2448-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2448-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2448-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2448-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2449" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2449-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2449-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2449-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2449-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2450" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2450-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2450-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2450-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2450-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2451" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2451-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2451-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2451-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2451-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2452" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2452-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2452-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2452-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2452-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2453" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2453-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2453-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2453-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2453-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2454" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2454-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2454-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2454-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2454-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2455" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2455-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2455-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2455-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2455-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2456" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2456-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2456-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2456-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2456-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2457" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2457-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2457-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2457-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2457-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2458" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2458-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2458-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2458-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2458-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2459" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2459-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2459-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2459-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2459-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2460" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2460-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2460-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2460-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2460-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2461" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2461-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2461-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2461-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2461-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2462" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2462-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2462-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2462-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2462-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2463" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2463-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2463-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2463-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2463-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2464" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2464-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2464-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2464-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2464-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2465" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2465-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2465-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2465-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2465-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2466" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2466-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2466-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2466-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2466-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2467" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2467-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2467-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2467-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2467-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2468" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2468-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2468-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2468-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2468-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2469" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2469-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2469-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2469-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2469-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2470" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2470-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2470-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2470-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2470-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2471" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2471-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2471-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2471-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2471-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2472" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2472-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2472-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2472-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2472-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2473" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2473-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2473-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2473-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2473-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2474" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2474-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2474-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2474-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2474-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2475" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2475-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2475-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2475-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2475-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2476" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2476-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2476-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2476-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2476-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2477" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2477-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2477-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2477-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2477-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2478" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2478-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2478-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2478-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2478-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2479" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2479-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2479-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2479-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2479-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2480" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2480-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2480-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2480-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2480-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2481" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2481-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2481-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2481-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2481-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2482" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2482-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2482-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2482-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2482-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2483" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2483-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2483-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2483-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2483-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2484" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2484-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2484-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2484-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2484-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2485" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2485-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2485-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2485-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2485-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2486" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2486-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2486-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2486-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2486-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2487" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2487-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2487-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2487-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2487-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2488" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2488-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2488-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2488-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2488-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2489" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2489-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2489-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2489-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2489-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2490" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2490-04-02T07:59:59+00:00", "01:59:59", "CST", 360],
		["2490-04-02T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2490-10-29T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2490-10-29T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2491" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2491-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2491-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2491-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2491-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2492" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2492-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2492-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2492-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2492-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2493" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2493-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2493-04-05T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2493-10-25T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2493-10-25T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2494" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2494-04-04T07:59:59+00:00", "01:59:59", "CST", 360],
		["2494-04-04T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2494-10-31T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2494-10-31T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2495" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2495-04-03T07:59:59+00:00", "01:59:59", "CST", 360],
		["2495-04-03T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2495-10-30T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2495-10-30T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2496" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2496-04-01T07:59:59+00:00", "01:59:59", "CST", 360],
		["2496-04-01T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2496-10-28T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2496-10-28T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2497" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2497-04-07T07:59:59+00:00", "01:59:59", "CST", 360],
		["2497-04-07T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2497-10-27T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2497-10-27T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2498" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2498-04-06T07:59:59+00:00", "01:59:59", "CST", 360],
		["2498-04-06T08:00:00+00:00", "03:00:00", "CDT", 300],
		["2498-10-26T06:59:59+00:00", "01:59:59", "CDT", 300],
		["2498-10-26T07:00:00+00:00", "01:00:00", "CST", 360]
	]),

	"2499" : helpers.makeTestYear("America/Bahia_Banderas", [
		["2499-04-05T07:59:59+00:00", "01:59:59", "CST", 360],
		["2499-04-05T08:00:00+00:00", "03:00:00", "CDT", 300]
	])
};