/*
** Modular Logfile Analyzer
** Copyright 2000 Jan Kneschke <jan@kneschke.de>
**
** Homepage: http://www.modlogan.org
**

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version, and provided that the above
    copyright and permission notice is included with all distributed
    copies of this or derived software.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA

**
** $Id: plugin_config.h,v 1.6 2003/04/18 18:40:42 ostborn Exp $
*/
#ifndef _INPUT_PLUGIN_CONFIG_H_
#define _INPUT_PLUGIN_CONFIG_H_

#include <pcre.h>

#include "mlist.h"
#include "mio.h"
#include "mconfig.h"
#include "mrecord.h"

typedef struct {
	mlist	*match_ua;
	mlist	*match_os;
	char	*inputfilename;
	
	mfile	inputfile;
	buffer	*buf;


	pcre	*match_clf;
	pcre_extra	*match_clf_extra;
	pcre		*match_timestamp;
	pcre_extra	*match_timestamp_extra;
	pcre		*match_url;
	pcre_extra	*match_url_extra;
} config_input;

int mplugins_input_realserver_get_next_record(mconfig *ext_conf, mlogrec *record);

#endif
