/*
 *  mod_bt - Making Things Better For Seeders
 *  Copyright 2004 Tyler MacDonald <tyler@yi.org>
 *
 *  Licensed under the Apache License, Version 2.0 (the "License");
 *  you may not use this file except in compliance with the License.
 *  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing, software
 *  distributed under the License is distributed on an "AS IS" BASIS,
 *  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 *  See the License for the specific language governing permissions and
 *  limitations under the License.
 */

/* libc */
#include <string.h>
#include <stdio.h>

/* APR */
#include <apr.h>
#include <apr_pools.h>

/* local */
#include <libbtutil.h>

bt_form_pair bt_next_form_pair_unesc(char* str) {
    bt_form_pair rv = bt_next_form_pair(str);
    apr_size_t nv;

    if(rv.value[0]) {
        if((nv = bt_uri_unescape(rv.value))) {
            rv.value_len = nv;
        } else {
            fprintf(stderr, "next_form_pair_unesc: uri_unescape() failed\n");
            fflush(stderr);
        }
    }
 
    return rv;
}

bt_form_pair bt_next_form_pair(char* str) {
    bt_form_pair rv;
    char *eop = NULL;
    char oeop = '\0';
    char *eeq;
 
    if(!str || !*str) {
        rv.key[0] = '\0';
        rv.value[0] = '\0';
        rv.value_len = 0;
        rv.eop = NULL;
        return rv;
    }

    if((eop = index(str, '&')) || (eop = index(str, ';'))) {
        oeop = *eop;
        *eop = '\0';
    }
 
    if((eeq = index(str, '='))) {
        *eeq = '\0';
        strncpy(rv.key, str, 32);
        rv.key[32] = '\0';
        eeq++;
        if(*eeq == '&' || *eeq == ';' || *eeq == '\0') {
            rv.value[0] = '\0';
            rv.value_len = 0;
        } else {
            strncpy(rv.value, eeq, 128);
            rv.value[128] = '\0';
            rv.value_len = strlen(rv.value);
        }
        eeq--;
        *eeq = '=';
    } else {
        rv.key[0] = '\0';
        rv.value[0] = '\0';
        rv.value_len = 0;
    }

    if(oeop != '\0')
        *eop = oeop;

    rv.eop = eop;
 
    return rv;
}

char* bt_uri_escape(apr_pool_t*p, char*str, int len) {
    char* rv = apr_pcalloc(p, (len*3)+1);
    int i;
    for(i=0;i<len;i++)
        sprintf(&(rv[i*3]), "%%%02hhx", str[i]);
    return rv;
}

/* overwrites original string!! */
apr_size_t bt_uri_unescape(char* p) {
    apr_size_t rv;
    char* c;
    char* rc;
    short unsigned int rep;

    if(!p || !*p)
        return 0;
  
    rc = p;
    rv = 0;
 
    for(c=p;*c;c++) {
        if(*c == '%') {
            if(sscanf(c, "%%%2hx", &rep)>0) {
                *rc = rep;
                rc++;
                c++;
                c++;
                rv++;
            } else {
                *rc = *c;
                rc++;
                rv++;
            }
        } else if(*c == '+') {
            *rc = ' ';
            rc++;
            rv++;
        } else {
            *rc = *c;
            rc++;
            rv++;
        }
    }
  
    *rc = '\0';
    return rv;
}
