#ifndef BTT_TYPES_INFOHASH_H
#define BTT_TYPES_INFOHASH_H

/* libc */
#include <sys/types.h>
#include <stdint.h>
/* other libs */
#include <apr.h>
#include <apr_pools.h>
/* local */
#include <libbtutil.h>
#include <libbttracker/config.h>
#include <libbttracker/btt_xml.h>

typedef struct btt_infohash_s {
    char        infohash[BT_INFOHASH_LEN];
    char        filename[BT_FILE_LEN];
    
    bt_size_t   filesize;       /* length of file in bytes */
    bt_off_t    max_uploaded;   /* highest "uploaded" value we've gotten */
    bt_off_t    max_downloaded; /* highest "downloaded" value we've gotten */
    bt_size_t   max_left;       /* highest "left" value we've gotten */
    bt_size_t   min_left;       /* lowest "left" value we've gotten (aside from 0) */
    uint64_t    hits;           /* how many /announce requests we've gotten total */

    uint32_t    peers;          /* current # of peers, including seeds */
    uint32_t    seeds;          /* current # of seeds, including shields */
    uint32_t    shields;        /* current # of shields */
 
    uint32_t    starts;         /* # of "started" events */
    uint32_t    stops;          /* # of "stopped" events */
    uint32_t    completes;      /* # of "complete" events */

    time_t      first_t;        /* time this hash was added to db */
    time_t      last_t;         /* last time this hash or it's peers was written to */
    time_t      register_t;     /* last time this hash was registered */

    time_t      first_peer_t;   /* first time we heard a peer */
    time_t      last_peer_t;    /* last time we heard a peer */
    time_t      first_seed_t;   /* first time we heard a seed */
    time_t      last_seed_t;    /* last time we heard a seed */
} btt_infohash;

#define btt_infohash_downloaders(h)     (h.seeds - h.peers)
#define btt_infohash_seeds(h)           ( \
    h.shields < h.seeds ? h.seeds - h.shields : h.seeds \
)

extern const btt_infohash new_btt_infohash;
extern int btt_infohash2scrape_verbose(
    apr_pool_t* p, btt_infohash* infohash, char** result
);
extern int btt_infohash2scrape(
    apr_pool_t* p, btt_infohash* infohash, char** result
);
extern int btt_infohash2table(
    apr_pool_t* p, btt_infohash* infohash, char** result
);
extern int btt_infohash2text(
    apr_pool_t* p, btt_infohash* infohash, char** result
);
extern int btt_infohash2tr(
    apr_pool_t* p, btt_infohash* infohash, char* detail_url, char** result
);
#ifdef BTT_WITH_LIBXML2
extern btt_xml_node infohash_nodes[];
extern int btt_infohash2xml(
    apr_pool_t* p, btt_infohash* infohash, char** result
);
extern xmlDocPtr btt_infohash2xmlDoc(apr_pool_t* p, btt_infohash *infohash);
extern xmlNodePtr btt_infohash2nodes(
    apr_pool_t* p, xmlDocPtr document, btt_infohash *infohash
);
extern btt_infohash btt_xml2infohash(apr_pool_t* p, xmlNodePtr top);
#endif

#endif /* BTT_TYPES_INFOHASH_H */
