#ifndef LIBBTT_CXN_CXN_H
#define LIBBTT_CXN_CXN_H

/* other libs */
#include <db.h>
#include <apr.h>
#include <apr_pools.h>
/* local */
#include <libbttracker/types/btt_tracker.h>
#include <libbttracker/iter.h>

/* bt_cxn_scrape.c */

#define BTT_SCRAPE_XML	1
#define BTT_SCRAPE_HTML	2

typedef struct btt_cxn_scrape_config_s
{
 unsigned char          full;
 unsigned char          verbose;
 unsigned char          xml;
 char*                 hashlist;
 u_int16_t              hashes;
 int                   status;
 btt_iter_content      rv;
 u_int32_t              t_downloaders;
 u_int32_t              t_seeds;
 u_int32_t              t_shields;
 u_int32_t              t_completed;
 u_int32_t              t_hashes;
 btt_tracker*          tracker;
 void*                 document;
} btt_cxn_scrape_config;

extern btt_cxn_scrape_config btt_make_cxn_scrape_config(const char* args, apr_pool_t* p);
extern int btt_cxn_scrape(btt_tracker* tracker, apr_pool_t* p, DB_TXN* ptxn, const char* args, struct sockaddr_in in_address, char** content, int* content_length);

/* bt_cxn_announce.c */
extern int btt_cxn_announce(btt_tracker* tracker, apr_pool_t* p, DB_TXN* ptxn, const char* args, const char* user_agent, struct sockaddr_in address, char** content, int* content_length);

/* bt_cxn_register.c */
extern int btt_cxn_register(btt_tracker* tracker, apr_pool_t* p, DB_TXN* ptxn, const char* args, struct sockaddr_in address, char** content, int* content_length);

/* bt_cxn_details.c */
extern int btt_cxn_details(btt_tracker* tracker, apr_pool_t* p, DB_TXN* ptxn, const char* args, struct sockaddr_in in_address, char** content, int* content_length);

#endif /* __BT_CXN_H */
