#ifndef SDLMIXERCALLS_H
#define SDLMIXERCALLS_H

#include <SDL_mixer.h>


//----------------------------------------------------------------------------
#define ZAP_CHUNK(c) \
    SDL_MIXER_CALLS::FreeChunk(c); \
    c = NULL;

//----------------------------------------------------------------------------
#define ZAP_MUSIC(m) \
    SDL_MIXER_CALLS::FreeMusic(m); \
    m = NULL;


//----------------------------------------------------------------------------
/**
 * This namespace contains wrappers to most needed SDL mixer calls.
 * Each wrapper will call the related SDL function
 * and will check the return code for errors.
 * If an error occured, an SDLException will be thrown.
 * This way, the application never needs to check return codes.
 */
namespace SDL_MIXER_CALLS
{
    //------------------------------------------------------------------------
    void OpenAudio(int rate, Uint16 format, int channels, int buffers);
    
    //------------------------------------------------------------------------
    void QuerySpec(int* rate, Uint16* format, int* channels);
    
    //------------------------------------------------------------------------
    void CloseAudio();

    //------------------------------------------------------------------------
    int AllocateChannels(int num);

    //------------------------------------------------------------------------
    Mix_Chunk* LoadWAV(const char* file);
    
    //------------------------------------------------------------------------
    int PlayChannel(const Mix_Chunk* chunk, int loops = 0);
    
    //------------------------------------------------------------------------
    void HaltChannel(int channel);
    
    //------------------------------------------------------------------------
    Mix_Music* LoadMUS(const char* track);

    //------------------------------------------------------------------------
    void PlayMusic(const Mix_Music* music, int loops);
    
    //------------------------------------------------------------------------
    void HookMusicFinished(void(*hook)());
    
    //------------------------------------------------------------------------
    void HaltMusic();

    //------------------------------------------------------------------------
    void FreeChunk(Mix_Chunk* chunk);

    //------------------------------------------------------------------------
    void FreeMusic(Mix_Music* music);
}

#endif //SDLMIXERCALLS_H
