/* Copyright (C) 2000-2002 Lavtech.com corp. All rights reserved.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
*/

#include "udm_config.h"

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/types.h>
#include <errno.h>
#ifdef HAVE_SYS_SOCKET_H
#include <sys/socket.h>
#endif
#ifdef   HAVE_UNISTD_H
#include <unistd.h>
#endif

#include "udmsearch.h"
#include "udm_xmalloc.h"

/* This should be last include */
#ifdef DMALLOC
#include "dmalloc.h"
#endif

#ifdef WIN32
#include "udm_winutils.h"
#endif

#define POWERED_LOGO "<BR><a href=\"http://www.mnogosearch.org/\"><IMG BORDER=0 SRC=\"http://www.mnogosearch.org/img/mwin.gif\"></A>&nbsp<FONT SIZE=1><A HREF=\"http://www.mnogosearch.org/\">Powered by mnoGoSearch - free web search engine software</A></FONT><BR>\n"

/******************** Misc functions *********************************/

static void ParseQStringUnescaped(UDM_VARLIST *vars, const char *qstring)
{
  char *tok, *lt, *qs; 
  
  if ((qs= (char*)UdmStrdup(qstring)))
  {
    UdmSGMLUnescape(qs);
    tok = udm_strtok_r(qs, "&", &lt);
    while(tok)
    {
      char *arg= strchr(tok,'=');
      if(arg)
        *arg++='\0';
      UdmVarListAddStr(vars,tok,arg?arg:"");
      tok= udm_strtok_r(NULL, "&", &lt);
    }
    UdmFree(qs);
  }
}

static int UdmVarListReplaceOrDelInt(UDM_VARLIST *V, const char *name, int i)
{
  return i ? UdmVarListReplaceInt(V, name, i) : UdmVarListDel(V, name);
}

static char * BuildPageURL(UDM_VARLIST * vars, char **dst)
{
  size_t i, nargs= 0, dstlen= 0;
  char *end;
  
  for(i= 0; i < vars->nvars; i++)
    dstlen+= 7 + strlen(vars->Var[i].name) + strlen(vars->Var[i].val);
  
  if (!(*dst= (char*)UdmRealloc(*dst, 3*dstlen)))
    return NULL;
  end = *dst;
  
  for(i=0; i < vars->nvars; i++)
  {
    strcpy(end, nargs ? "&amp;" : "?");
    end += nargs ? 5 : 1;
    strcpy(end,vars->Var[i].name);
    end= end + strlen(end);
    strcpy(end++,"=");
    strcpy(end,vars->Var[i].val);
    UdmURLCanonizePath(end, 3*strlen(vars->Var[i].val) + 1,vars->Var[i].val);
    end= end + strlen(end);
    nargs++;
  }
  return NULL;
}

/*****************************************************************/

static char *UdmConfDir(void)
{
#ifdef WIN32
  return WinUdmConfDir();
#else
  char* result;
  result = (char *)UdmStrdup(UDM_CONF_DIR);
  return result;
#endif
}


#ifndef WIN32
#include <grp.h>

static int UdmLoadGroups (UDM_ENV *E) {
  struct group *grp;
  size_t cnt = 0;
  char name[32];
  char **p;
  const char *user = UdmVarListFindStr(&E->Vars, "REMOTE_USER", NULL);

  if (! user) return(UDM_OK);

  setgrent();
  while ((grp = getgrent()))
  {
    for (p = grp->gr_mem; *p; p++)
    {
      if (! strcmp(user, *p))
      {
        udm_snprintf(name, sizeof(name), "REMOTE_GROUP%d", cnt);
        UdmVarListAddStr(&E->Vars, name, grp->gr_name);
        cnt++;
	break;
      }
    }
  }
  getgrent();

  return(UDM_OK);
}
#endif

/************************************************************/
static int StoreDocCGI (UDM_AGENT *Agent, UDM_ENV *Env, UDM_VARLIST *tmpl)
{
  UDM_DOCUMENT *Doc;
  UDM_RESULT   *Res;
  UDM_HTMLTOK  tag;
  char         *HDoc= NULL;
  char         *HEnd= NULL;
  char         *last= NULL;
  char         ch;
  const char   *content_type, *charset, *htok;
  UDM_CHARSET  *cs;
#ifdef USE_PARSER
  UDM_PARSER   *Parser;
#endif
  
  Doc=UdmDocInit(NULL);
  Res=UdmResultInit(NULL);
  UdmPrepare(Agent,Res);
  UdmVarListReplaceStr(&Doc->Sections, "URL", UdmVarListFindStr(&Env->Vars, "URL", "0"));
  UdmVarListReplaceStr(&Doc->Sections, "dbnum", UdmVarListFindStr(&Env->Vars, "dbnum", "0"));
  UdmURLAction(Agent, Doc, UDM_URL_ACTION_GET_CACHED_COPY);
  UdmVarListReplaceLst(&Env->Vars, &Doc->Sections, NULL, "*");
  
  charset = UdmVarListFindStr(&Env->Vars,"Charset","iso-8859-1");
  cs = UdmGetCharSet(charset);
  
  printf("Content-type: text/html; charset=%s\r\n\r\n", charset);
  
  /* Now start displaying template*/
  UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, tmpl, "storedoc_top");
  
  /* UnStore Doc, Highlight and Display */
  
  content_type = UdmVarListFindStr(&Env->Vars, "Content-Type", "text/html");
  
#ifdef USE_PARSER
  if ((Parser= UdmParserFind(&Env->Parsers, content_type)))
  {
    content_type = Parser->to_mime ? Parser->to_mime : "text/html";
  }
#endif
  if(!Doc->Buf.content)goto fin;
  
  HEnd=HDoc = (char*)UdmMalloc(UDM_MAXDOCSIZE + 32);
  *HEnd='\0';
  
  if (strncasecmp(content_type, "text/plain", 10) == 0)
  {
    sprintf(HEnd, "<pre>\n");
    HEnd += strlen(HEnd);
  }

  UdmHTMLTOKInit(&tag);
  for(htok= UdmHTMLToken(Doc->Buf.content, (const char **)&last, &tag) ; htok ;)
  {
    char *tmp;
    switch(tag.type) {
    case UDM_HTML_COM:
    case UDM_HTML_TAG:
      memcpy(HEnd,htok,(size_t)(last-htok));
      HEnd+= last-htok;
      HEnd[0]= '\0';
      UdmHTMLParseTag(&tag,Doc);
      break;
    case UDM_HTML_TXT:
      ch= *last;
      *last= '\0';
      if (tag.title || tag.script || tag.comment || tag.style)
      {
        if ((tmp= UdmHlConvert(NULL, htok, cs, cs)))
        {
          memcpy(HEnd, tmp, strlen(tmp) + 1);
          UdmFree(tmp);
        }
      }
      else
      {
        if ((tmp= UdmHlConvert(&Res->WWList, htok, cs, cs)))
        {
          memcpy(HEnd, tmp, strlen(tmp) + 1);
          UdmFree(tmp);
        }
      }
      HEnd=UDM_STREND(HEnd);
      *last = ch;
      break;
    }
    htok = UdmHTMLToken(NULL, (const char **)&last, &tag);
  }

  if (strncasecmp(content_type, "text/plain", 10) == 0)
  {
    sprintf(HEnd, "</pre>\n");
    HEnd+= strlen(HEnd);
  }
  
  UdmVarListAddStr(&Env->Vars, "document", HDoc);
  UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, tmpl, "storedoc");
  
fin:
  UdmResultFree(Res);
  UdmDocFree(Doc);
  
  UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, tmpl, "storedoc_bottom");
  UdmVarListFree(tmpl);
  UdmAgentFree(Agent);
  UdmEnvFree(Env);
  UDM_FREE(HDoc);
  return(0);
}
/************************************************************/

/*
   We need to initialize WSA to process possible
   includes in template.
*/
static void UdmWSAStartup(void)
{
#ifdef WIN32
  WSADATA wsaData;
  if(WSAStartup(0x101,&wsaData)!=0)
  {
    fprintf(stderr,"WSAStartup() error %d\n",WSAGetLastError);
    exit(1);
  }
#endif
}

static void UdmWSACleanup(void)
{
#ifdef WIN32
  WSACleanup();
#endif
}
/************************************************************/
#if defined(HAVE_PTHREAD) && !defined(WIN32)
static
int UdmThreadCreate(void **thd, void *(*start_routine)(void *), void *arg)
{
  return pthread_create((pthread_t*) thd, NULL, start_routine, arg); 
}

static
int UdmThreadJoin(void *thd)
{
  return pthread_join((pthread_t) thd, NULL);
}        
#endif

int main(int argc, char ** argv)
{
  const char  *env, *bcharset, *lcharset;
  char        template_name[1024]= "";
  char        search_time[100]= "";
  char        self[1024]= "";
  char        *query_string= NULL, *nav= NULL, *url= NULL;
  char        *searchwords= NULL, *storedstr= NULL;
  int         page_size, page_number, res,httpd= 0;
  size_t      i, swlen= 0, nav_len, storedlen, catcolumns= 0;
  ssize_t     page1,page2,npages,ppp=10;
  UDM_ENV     *Env;
  UDM_AGENT   *Agent;
  UDM_RESULT  *Res;
  UDM_VARLIST query_vars;
  UDM_VARLIST tmpl;
  
  UdmWSAStartup();
  /* Output Content-type if under HTTPD   */
  /* Some servers do not pass QUERY_STRING */
  /* if the query was empty, so check   */
  /* REQUEST_METHOD too     to be safe     */
  
  httpd=(getenv("QUERY_STRING")||getenv("REQUEST_METHOD"));
  
#if ( (defined WIN32) && (defined _DEBUG) )
  if(httpd)
  {
    WIN32_IIS_DEBUG_MSG
    DebugBreak();
  }
#endif
  
  UdmInit();
  Env=UdmEnvInit(NULL);
#if defined(HAVE_PTHREAD) && !defined(WIN32)
  Env->ThreadCreate= UdmThreadCreate;
  Env->ThreadJoin= UdmThreadJoin;
#endif
  UdmVarListInit(&tmpl);
  UdmVarListInit(&query_vars);
  Agent = UdmAgentInit(NULL, Env, 0);
  UdmVarListAddEnviron(&Env->Vars,"ENV");
  
  /* Detect self */
  if((env= getenv("UDMSEARCH_SELF")) || (env= getenv("REQUEST_URI")))
  {
    /* Use Apache's REQUEST_URI, which is not in CGI standard */
    char *end;
    strncpy(self,env,sizeof(self)-1);
    if ((end= strchr(self,'?')))
      end[0]='\0';
  }
  else if ((env= getenv("SCRIPT_NAME")))
  {
    /* Use standard CGI variables if not under Apache */
    const char *path_info= getenv("PATH_INFO");
    udm_snprintf(self,sizeof(self),"%s%s",env,path_info?path_info:"");
  }
  else
  {
    strncpy(self,"search.cgi",sizeof(self)-1);
  }
  
  
  /* Detect template name */
  if((env= getenv("UDMSEARCH_TEMPLATE")))
  {
    char ename[1024];
    strncpy(ename,env,sizeof(ename)-1);
    ename[sizeof(ename)]='\0';
    UdmUnescapeCGIQuery(template_name,ename);
  }
  else if(getenv("REDIRECT_STATUS") && (env= getenv("PATH_TRANSLATED")))
  {
    /* Check Apache internal redirect  */
    /* via   "AddHandler" and "Action" */
    strncpy(template_name,env,sizeof(template_name)-1);
  }
  else if ((env= getenv("PATH_INFO")) && env[0])
  {
    /* http://localhost/cgi-bin/search.cgi/path/to/search.htm */
    char name[128], *conf_dir;
    
    strncpy(name,env,sizeof(name)-1);
    name[sizeof(name)-1]='\0';
    if (UDMSLASH !='/')
    {
      char *s;
      for (s=name; s[0]; s++)
        if (s[0]=='\\')s[0]='/';
    }
    
    conf_dir= (env= getenv("UDM_ETC_DIR")) ? (char *)UdmStrdup(env) : UdmConfDir();
    /* Take from the config directory */
    udm_snprintf(template_name, sizeof(template_name)-5, "%s%s%s", 
                 conf_dir,UDMSLASHSTR,name);
    UDM_FREE(conf_dir);
  }
  else
  {
    /* CGI executed without Apache internal redirect */
    /* or started from command line                  */
    char *end, *conf_dir;
    size_t length;
    
    conf_dir= (env= getenv("UDM_ETC_DIR")) ? (char *)UdmStrdup(env) : UdmConfDir();
    
    /* Take from the config directory */
    length= udm_snprintf(template_name, sizeof(template_name)-5, "%s%s%s", 
                         conf_dir,UDMSLASHSTR,
                         (end= strrchr(self,'/')) ? (end+1) : (self));
    end= template_name + length;
    if ( length > 3 && (!strcmp(end-4,".exe") || !strcmp(end-4,".cgi")))
      end-=4;
    strcpy(end,".htm");
    UDM_FREE(conf_dir);
  }
  
  if((env= getenv("QUERY_STRING")))
  {
    query_string = (char*)UdmRealloc(query_string, strlen(env) + 2);
    strncpy(query_string, env, strlen(env) + 1);
  }
  else if(argv[1])
  {
    query_string = (char*)UdmRealloc(query_string, strlen(argv[1]) + 10);
    sprintf(query_string, "q=%s", argv[1]);
  }
  else
  {
    query_string = (char*)UdmRealloc(query_string, 1024);
    sprintf(query_string, "q=");
  }
  
  /* Hack for Russian Apache from apache.lexa.ru  */
  /* QUERY_STRING is already converted to server  */
  /* character set. We must print original query  */
  /* string instead however. Under usual apache   */ 
  /* we'll use QUERY_STRING. Note that query_vars */
  /* list will contain not unescaped values, so   */
  /* we don't have to escape them when displaying */
  env= getenv("CHARSET_SAVED_QUERY_STRING");
  ParseQStringUnescaped(&query_vars,env?env:query_string);
  
  /* Unescape and save variables from QUERY_STRING */
  /* Env->Vars will have unescaped values however  */
  UdmParseQueryString(Agent,&Env->Vars,query_string);

#ifndef WIN32
  env= getenv("REMOTE_USER");
  if (env)
  {
    UdmVarListAddStr(&Env->Vars, "REMOTE_USER", env);
    UdmLoadGroups(Env);
  }
#endif
  
  if((res=UdmTemplateLoad(Agent,template_name,&tmpl)))
  {
    if(httpd)
      printf("Content-Type: text/plain\r\n\r\n");
    printf("%s\n",Env->errstr);
    UdmVarListFree(&tmpl);
    UdmVarListFree(&query_vars);
    UdmEnvFree(Env);
    UDM_FREE(query_string);
    UdmAgentFree(Agent);
    return(0);
  }

#ifdef HAVE_SETVBUF
  {
    /*
      Set stdout buffer size. It allows to avoid re-rendering
      in the browser. After setting StdoutBufferSize to a
      reasonably big value, search.cgi will send whole output
      at once in the end, rather than gradually.
    */
    size_t bsz= (size_t) UdmVarListFindInt(&Env->Vars, "StdoutBufferSize", 0);
    if (bsz > 0)
      setvbuf(stdout, NULL, _IOFBF, bsz);
  }
#endif

  
  UdmTemplatePrint(Agent, NULL, NULL, 0, &Env->Vars, &tmpl, "variables");

  /* Call again to load search Limits if need */
/*  UdmParseQueryString(Agent, &Env->Vars, query_string); */
  UdmSetLogLevel(NULL, UdmVarListFindInt(&Env->Vars, "LogLevel", 0));
  UdmOpenLog("search.cgi", Env, !strcasecmp(UdmVarListFindStr(&Env->Vars, "Log2stderr", (!httpd) ? "yes" : "no"), "yes"));
  UdmLog(Agent,UDM_LOG_ERROR,"search.cgi started with '%s'",template_name);
  
  /* This is for query tracking */
  UdmVarListReplaceStr(&Env->Vars, "tmplt", template_name);
  UdmVarListAddStr(&Env->Vars,"QUERY_STRING",query_string);
  UdmVarListAddStr(&Env->Vars,"self",self);
  
  bcharset= UdmVarListFindStr(&Env->Vars,"BrowserCharset","iso-8859-1");
  Env->bcs= UdmGetCharSet(bcharset);
  lcharset= UdmVarListFindStr(&Env->Vars,"LocalCharset","iso-8859-1");
  Env->lcs= UdmGetCharSet(lcharset);
  ppp= UdmVarListFindInt(&Env->Vars,"PagesPerScreen",10);
  
  if (! Env->bcs)
  {
    if (httpd)
      printf("Content-Type: text/plain\r\n\r\n");
    printf("Unknown BrowserCharset '%s' in template '%s'\n",bcharset,template_name);
    exit(0);
  }
  
  if(! Env->lcs)
  {
    if (httpd)
      printf("Content-Type: text/plain\r\n\r\n");
    printf("Unknown LocalCharset '%s' in template '%s'\n",lcharset,template_name);
    exit(0);
  }
  
  if (UdmVarListFindInt(&Env->Vars, "cc", 0))
  {
    UdmVarListFree(&query_vars);
    UDM_FREE(query_string);
    return(StoreDocCGI(Agent, Env, &tmpl));
  }
  
  if (httpd)
    printf("Content-type: text/html; charset=%s\r\n\r\n",bcharset);
  
  /* These parameters taken from "variable section of template"*/
  
  res= UdmVarListFindInt(&Env->Vars,"np",0)*UdmVarListFindInt(&Env->Vars,"ps",10);
  UdmVarListAddInt(&Env->Vars,"pn",res);
  
  catcolumns= (size_t)atoi(UdmVarListFindStr(&Env->Vars,"CatColumns",""));
  
  if(catcolumns)
  {
    UDM_CATEGORY C;
    
    bzero((void*)&C, sizeof(C));
    strcpy(C.addr,UdmVarListFindStr(&Env->Vars,"cat",""));
    if(UDM_OK == UdmCatAction(Agent, &C, UDM_CAT_ACTION_LIST))
    {
      size_t n=1, l = 0;
      char *catlist;
      
      for(i= 0; i < C.ncategories; i++)
        l+= 128 + strlen(C.Category[i].path) + strlen(C.Category[i].name);
      
      if (l > 0  && (catlist= (char*)UdmMalloc(l)))
      {
        sprintf(catlist, "<table>\n");
        for(i = 0; i < C.ncategories; i++)
        {
          sprintf(catlist+strlen(catlist),
                  "%s<td><a href=\"?cat=%s\">%s</A></td><td width=60>&nbsp;</td>\n",
                  n==1 ? "<tr>\n" : "",
                  C.Category[i].path, C.Category[i].name);
          
          if(n == catcolumns)
          {
            sprintf(catlist+strlen(catlist),"</tr>\n");
            n=1;
          }
          else
          {
            n++;
          }
        }
        sprintf(catlist + strlen(catlist), "</table>\n");
        UdmVarListAddStr(&Env->Vars, "CS", catlist);
        UDM_FREE(catlist);
      }
    }
    else
    {
      UdmVarListAddStr(&Env->Vars,"E",UdmEnvErrMsg(Agent->Conf));
      UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "top");
      UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "error");
      goto end;
    }
    
    UDM_FREE(C.Category);
    bzero((void*)&C, sizeof(C));
    strcpy(C.addr,UdmVarListFindStr(&Env->Vars,"cat",""));
    if(UDM_OK == UdmCatAction(Agent, &C, UDM_CAT_ACTION_PATH))
    {
      char *catpath = NULL;
      size_t l= 0;
      
      for(i= 0; i < C.ncategories; i++)
        l+= 32 + strlen(C.Category[i].path) + strlen(C.Category[i].name);
      
      if (l > 0 && (catpath= (char*)UdmMalloc(l)))
      {
        catpath[0]= '\0';
        for(i = 0; i < C.ncategories; i++)
        {
          sprintf(catpath+strlen(catpath),"/<a href=\"?cat=%s\">%s</A>",
                  (C.Category[i].path) ? C.Category[i].path : "",
                  (C.Category[i].name) ? C.Category[i].name : "");
        }
        UdmVarListAddStr(&Env->Vars, "CP", catpath);
        UDM_FREE(catpath);
      }
    }
    else
    {
      UdmVarListAddStr(&Env->Vars,"E",UdmEnvErrMsg(Agent->Conf));
      UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "top");
      UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "error");
      goto end;
    }
    UDM_FREE(C.Category);
  }
  
  if(NULL==(Res=UdmFind(Agent)))
  {
    UdmVarListAddStr(&Env->Vars,"E",UdmEnvErrMsg(Agent->Conf));
    UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "top");
    UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "error");
    if (Res != NULL)
      goto freeres;
    goto end;
  }
  UdmVarListAddInt(&Env->Vars,"first",(int)Res->first);
  UdmVarListAddInt(&Env->Vars,"last",(int)Res->last);
  UdmVarListAddInt(&Env->Vars,"total",(int)Res->total_found);
  sprintf(search_time,"%.3f",((double)Res->work_time)/1000);
  UdmVarListAddStr(&Env->Vars,"SearchTime",search_time);
  UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "top");
#ifdef TRIAL_VER
  fprintf(stdout,"%s",POWERED_LOGO);
#endif
  
  if(!Res->WWList.nwords)
  {
    UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "noquery");
    goto freeres;
  }
  
  if(!Res->num_rows)
  {
    UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "notfound");
    goto freeres;
  }
  
  page_size   = UdmVarListFindInt(&Agent->Conf->Vars,"ps",10);
  page_number = UdmVarListFindInt(&Agent->Conf->Vars,"np",0);
  
  for (i = 0; i < Res->WWList.nwords; i++)
    swlen += (8 * Res->WWList.Word[i].len) + 2;
  
  if ((searchwords= UdmXmalloc(swlen)) != NULL)
  {
    int z=0;
    for (i= 0; i < Res->WWList.nwords; i++)
    {
      if (Res->WWList.Word[i].count > 0)
      {
        sprintf(UDM_STREND(searchwords), (z)?"+%s":"%s", Res->WWList.Word[i].word);
        z++;
      }
    }
  }
  storedstr= UdmRealloc(storedstr, storedlen = 1024 + 10 * swlen);
  
  npages= (Res->total_found/(page_size?page_size:10)) +
          ((Res->total_found % (page_size?page_size:10) != 0 ) ?  1 : 0);
  page1= page_number-ppp/2;
  page2= page_number+ppp/2;
  if(page1<0)
  {
    page2-=page1;
    page1=0;
  }
  else if(page2>npages)
  {
    page1-=(page2-npages);
    page2=npages;
  }
  if(page1 < 0)
    page1=0;
  if( page2 > npages)
    page2=npages;
  nav = (char *)UdmRealloc(nav, nav_len = (size_t)(page2 - page1 + 2) * (1024 + 1024)); 
                           /* !!! 1024 - limit for navbar0/navbar1 template size */ 
  nav[0] = '\0';
  
  /* build NL NB NR */
  for(i = (size_t)page1; i < (size_t)page2; i++)
  {
    UdmVarListReplaceOrDelInt(&query_vars,"np",(int)i);
    BuildPageURL(&query_vars, &url);
    UdmVarListReplaceStr(&Env->Vars,"NH",url);
    UdmVarListReplaceInt(&Env->Vars,"NP",(int)(i+1));
    UdmTemplatePrint(Agent, NULL, UDM_STREND(nav),
                     nav_len - (nav - UDM_STREND(nav)), &Env->Vars, &tmpl,
                     (i == (size_t)page_number)?"navbar0":"navbar1");
  }
  UdmVarListAddStr(&Env->Vars,"NB",nav);
  
  UdmVarListReplaceOrDelInt(&query_vars,"np",page_number-1);
  BuildPageURL(&query_vars, &url);
  UdmVarListReplaceStr(&Env->Vars,"NH",url);
  
  if(Res->first==1) /* First page */
  {
    UdmTemplatePrint(Agent, NULL, nav, nav_len, &Env->Vars, &tmpl, "navleft_nop");
    UdmVarListReplaceStr(&Env->Vars,"NL",nav);
  }
  else
  {
    UdmTemplatePrint(Agent, NULL, nav, nav_len, &Env->Vars, &tmpl, "navleft");
    UdmVarListReplaceStr(&Env->Vars,"NL",nav);
  }
  
  UdmVarListReplaceOrDelInt(&query_vars,"np",page_number+1);
  BuildPageURL(&query_vars, &url);
  UdmVarListReplaceStr(&Env->Vars,"NH",url);
  
  UdmVarListReplaceOrDelInt(&query_vars, "np", 0);
  UdmVarListDel(&query_vars, "s");
  BuildPageURL(&query_vars, &url);
  UdmVarListReplaceStr(&Env->Vars, "FirstPage", url);
  
  if(Res->last>=Res->total_found) /* Last page */
  {
    UdmTemplatePrint(Agent, NULL, nav, nav_len, &Env->Vars, &tmpl, "navright_nop");
    UdmVarListReplaceStr(&Env->Vars,"NR",nav);
  }
  else
  {
    UdmTemplatePrint(Agent, NULL, nav, nav_len, &Env->Vars, &tmpl, "navright");
    UdmVarListReplaceStr(&Env->Vars,"NR",nav);
  }
  
  UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars,&tmpl, "restop");
  
  for(i=0;i<Res->num_rows;i++)
  {
    UDM_DOCUMENT *Doc=&Res->Doc[i];
    UDM_CATEGORY C;
    UDM_MATCH    *Alias;
    UDM_MATCH_PART Parts[10];
    char         *aliastr, *alcopy, *clist, *eu;
    const char   *u;
    size_t       cl, sc, clistsize;
    urlid_t      dc_url_id = (urlid_t)UdmVarListFindInt(&Doc->Sections, "ID", 0);
    urlid_t      dc_origin_id = (urlid_t)UdmVarListFindInt(&Doc->Sections, "Origin-ID", 0);
    
    /* Create "Alias" variable */
    alcopy=UdmRemoveHiLightDup(UdmVarListFindStr(&Doc->Sections,"URL",""));
    if ((Alias=UdmMatchListFind(&Agent->Conf->Aliases,alcopy,10,Parts)))
    {
      size_t nbytes= strlen(Alias->arg) + strlen(alcopy) + 64;
      aliastr= (char*)UdmMalloc(nbytes);
      UdmMatchApply(aliastr, nbytes, alcopy, Alias->arg, Alias, 10, Parts);
    }
    else
    {
      aliastr = (char*)UdmStrdup(alcopy);
    }
    UdmVarListReplaceStr(&Doc->Sections,"Alias", aliastr);
    UdmFree(aliastr);
    UdmFree(alcopy);
    
    /* Skip clones */
    if (dc_origin_id)
      continue;
    
    clist= (char*)UdmMalloc(2048); /* FIXME */
    clist[0]= '\0';
    clistsize= 0;
    for (cl=0;cl<Res->num_rows;cl++)
    {
      UDM_DOCUMENT *Clone=&Res->Doc[cl];
      urlid_t      cl_origin_id = (urlid_t)UdmVarListFindInt(&Clone->Sections, "Origin-ID", 0);
      
      if ((dc_url_id == cl_origin_id) && cl_origin_id)
      {
        UDM_VARLIST  CloneVars;
        
        UdmVarListInit(&CloneVars);
        UdmVarListAddLst(&CloneVars,&Env->Vars,NULL,"*");
        UdmVarListReplaceLst(&CloneVars,&Clone->Sections,NULL,"*");
        clist = (char*)UdmRealloc(clist, (clistsize = strlen(clist)) + 2048);
        UdmTemplatePrint(Agent, NULL, clist + clistsize, 2048, &CloneVars, &tmpl, "clone");
        UdmVarListFree(&CloneVars);
      }
    }
    clistsize += 2048;
    
    UdmVarListReplaceStr(&Env->Vars,"CL",clist);
    UdmVarListReplaceInt(&Env->Vars, "ID", dc_url_id);
    UdmVarListReplaceStr(&Env->Vars, "URL", UdmVarListFindStr(&Doc->Sections, "URL", ""));
    UdmVarListReplaceStr(&Env->Vars, "title", "[no title]");
    
    /* Pass all found user-defined sections */
    for(sc=0;sc<Doc->Sections.nvars;sc++)
    {
      UDM_VAR *S=&Doc->Sections.Var[sc];
      UdmVarListReplaceStr(&Env->Vars,S->name,S->val);
    }
    
    bzero((void*)&C, sizeof(C));
    strcpy(C.addr,UdmVarListFindStr(&Doc->Sections,"Category",""));
    if(catcolumns && !UdmCatAction(Agent, &C, UDM_CAT_ACTION_PATH))
    {
      char *catpath;
      size_t c, l = 0;
      
      for(c = 0; c < C.ncategories; c++)
        l+= 32 + strlen(C.Category[c].path) + strlen(C.Category[c].name);
      
      if (l > 0 && (catpath= (char*)UdmMalloc(l)))
      {
        *catpath = '\0';
        for(c = 0; c < C.ncategories; c++)
          sprintf(catpath+strlen(catpath)," &gt; <A HREF=\"?cat=%s\">%s</A> ",
                  C.Category[c].path,C.Category[c].name);
        UdmVarListReplaceStr(&Env->Vars,"DY",catpath);
        UDM_FREE(catpath);
      }
    }
    UDM_FREE(C.Category);
    
    u= UdmVarListFindStr(&Env->Vars, "URL", "");
    eu= (char*)UdmMalloc(strlen(u)*10 + 30);
    UdmEscapeURL(eu, u);
    if (UdmVarListFindInt(&Doc->Sections, "dbnum", 0))
    {
      udm_snprintf(storedstr, storedlen, "?cc=1&amp;dbnum=%s&amp;URL=%s&amp;q=%s&amp;wm=%s",
        UdmVarListFindStr(&Doc->Sections, "dbnum", "0"),
        eu,
        searchwords,
        UdmVarListFindStr(&Env->Vars, "wm", "wrd"));
    }
    else
    {
      udm_snprintf(storedstr, storedlen, "?cc=1&amp;URL=%s&amp;q=%s&amp;wm=%s",
        eu,
        searchwords,
        UdmVarListFindStr(&Env->Vars, "wm", "wrd"));
    }
    UdmFree(eu);
    
    UdmVarListReplaceStr(&Env->Vars, "stored_href", UdmVarListFindStr(&Doc->Sections, "CachedCopy", NULL) ? storedstr : "");
    if ( (sc = UdmVarListFindInt(&Env->Vars, "site", 0)) == 0)
    {
      UdmVarListReplaceOrDelInt(&query_vars,"np", 0);
      UdmVarListReplaceInt(&query_vars, "site", UdmVarListFindInt(&Doc->Sections, "Site_id", 0));
      BuildPageURL(&query_vars, &url);
      UdmVarListReplaceStr(&Env->Vars, "sitelimit_href", url);
    }
    
    UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "res");
    
    /* Revoke all found user-defined sections */
    for(sc = 0; sc < Doc->Sections.nvars; sc++)
    {
      UDM_VAR *S = &Doc->Sections.Var[sc];
      UdmVarListDel(&Env->Vars, S->name);
    }
    
    UdmFree(clist);
  }
  UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "resbot");
  UDM_FREE(searchwords);
  UDM_FREE(storedstr);
  
freeres:
  UdmResultFree(Res);
  
end:
  UdmTemplatePrint(Agent, stdout, NULL, 0, &Env->Vars, &tmpl, "bottom");
  
  UdmVarListFree(&tmpl);
  UdmVarListFree(&query_vars);
  UdmEnvFree(Env);
  UdmAgentFree(Agent);
  UDM_FREE(query_string);
  UDM_FREE(url);
  UDM_FREE(nav);
  if (httpd) 
    fflush(NULL); 
  else
    fclose(stdout);
  UdmWSACleanup();
  return UDM_OK;
}
