#!/usr/bin/perl
# $Source: /usr/src/CVS/mnogosearch/install.pl,v $
# $Id: install.pl,v 1.5 2001/08/21 11:31:57 gluke Exp $

$prefix="/usr/local/mnogosearch";

$builtin='no';
$auto='yes';
$db='';
$db_string='';

$build_shared='no';
$build_static='yes';

$syslog='yes';
$syslog_facility='default';

$linux_threads='no';
$bsd_threads='no';

$guesser='no';
$parser='yes';
$mp3='yes';
$aliasprog='yes';
$ext_news='no';

$cache='yes';
$fast_tag='no';
$fast_cat='no';
$fast_site='no';
$phrase='no';

$cgi='yes';
$file='yes';
$http='yes';
$ftp='yes';
$htdb='yes';
$news='yes';
$ssl='no';
$ssl_dir='';

$conf_file='install.options';

$|=1;

print "mnoGoSeach installation script version 0.1\n\n";

set_layout();
set_db(); print "\n";
set_libs(); print "\n";
set_syslog(); print "\n";
set_threads(); print "\n";
set_other(); print "\n";
set_cache(); print "\n";
set_shema(); print "\n";

configure();

# ---------------------------
# configure
# ---------------------------
sub configure {
	push @arg,"./configure";
	push @arg,"--prefix=$prefix";
        push @arg,"--bindir=$bindir";
	push @arg,"--sbindir=$sbindir";
        push @arg,"--sysconfdir=$sysconfdir";
        push @arg,"--localstatedir=$localstatedir";
        push @arg,"--libdir=$libdir";
	push @arg,"--includedir=$includedir";
        push @arg,"--mandir=$mandir";

        if ($build_shared eq 'yes') {
        	push @arg,"--enable-shared";
        } elsif ($build_shared eq 'no') {
        	push @arg,"--disable-shared";
	}

        if ($build_static eq 'yes') {
        	push @arg,"--enable-static";
        } elsif ($build_shared eq 'no') {
        	push @arg,"--disable-static";
	}


        if ($syslog eq 'yes') {
        	if ($syslog_facility ne 'default') {
        		push @arg,"--enable-syslog=$syslog_facility";
        	} else {
        		push @arg,"--enable-syslog";
        	}
        } elsif ($syslog eq 'no') {
        	push @arg,"--disable-syslog";
	}

        if ($ssl eq 'yes') {
        	if ($ssl_dir ne '') {
        		push @arg,"--with-openssl=$ssl_dir";
        	} else {
        		push @arg,"--with-openssl";
        	}
        } 

        if ($linux_threads eq 'yes') {
        	push @arg,"--enable-linux-pthreads";
        } elsif ($linux_threads eq 'no') {
        	push @arg,"--disable-linux-pthreads";
	}

        if ($bsd_threads eq 'yes') {
        	push @arg,"--enable-freebsd-pthreads";
        } elsif ($bsd_threads eq 'no') {
        	push @arg,"--disable-freebsd-pthreads";
	}

        if ($guesser eq 'yes') {
        	push @arg,"--enable-charset-guesser";
        } elsif ($guesser eq 'no') {
        	push @arg,"--disable-charset-guesser";
	}
        
        if ($parser eq 'yes') {
        	push @arg,"--enable-parser";
        } elsif ($parser eq 'no') {
        	push @arg,"--disable-parser";
	}

        if ($mp3 eq 'yes') {
        	push @arg,"--enable-mp3";
        } elsif ($mp3 eq 'no') {
        	push @arg,"--disable-mp3";
	}

        if ($aliasprog eq 'yes') {
        	push @arg,"--enable-aliasprog";
        } elsif ($aliasprog eq 'no') {
        	push @arg,"--disable-aliasprog";
	}

        if ($ext_news eq 'yes') {
        	push @arg,"--enable-news-extension";
        } elsif ($ext_news eq 'no') {
        	push @arg,"--disable-news-extension";
	}

        if ($fast_tag eq 'yes') {
        	push @arg,"--enable-fast-tag";
        } elsif ($fast_tag eq 'no') {
        	push @arg,"--disable-fast-tag";
	}

        if ($fast_cat eq 'yes') {
        	push @arg,"--enable-fast-cat";
        } elsif ($fast_cat eq 'no') {
        	push @arg,"--disable-fast-cat";
	}

        if ($fast_site eq 'yes') {
        	push @arg,"--enable-fast-site";
        } elsif ($fast_site eq 'no') {
        	push @arg,"--disable-fast-site";
	}

        if ($phrase eq 'yes') {
        	push @arg,"--enable-phrase";
        } elsif ($phrase eq 'no') {
        	push @arg,"--disable-phrase";
	}

        if ($cgi eq 'yes') {
        	push @arg,"--enable-exec-cgi";
        } elsif ($cgi eq 'no') {
        	push @arg,"--disable-exec-cgi";
	}

        if ($file eq 'yes') {
        	push @arg,"--enable-file";
        } elsif ($file eq 'no') {
        	push @arg,"--disable-file";
	}

        if ($http eq 'yes') {
        	push @arg,"--enable-http";
        } elsif ($http eq 'no') {
        	push @arg,"--disable-http";
	}

        if ($ftp eq 'yes') {
        	push @arg,"--enable-ftp";
        } elsif ($ftp eq 'no') {
        	push @arg,"--disable-ftp";
	}

        if ($htdb eq 'yes') {
        	push @arg,"--enable-htdb";
        } elsif ($htdb eq 'no') {
        	push @arg,"--disable-htdb";
	}

        if ($news eq 'yes') {
        	push @arg,"--enable-news";
        } elsif ($news eq 'no') {
        	push @arg,"--disable-news";
	}

        push @arg,"$db_string";

        print "@arg\n\n";
	
	open(CONF,">$conf_file") || die "Cannot create $conf_file\n";
	foreach $arg (@arg) {
		print CONF "$arg ";
	}
	print CONF "\n";
	close(CONF);	
	chmod(0755,$conf_file);
	
	system(@arg) == 0 or die "configure failed: $?";
	
	print "mnoGoSearch configured successfully\n";
	print "Now you should run 'make' then 'make install' to finish installation.\n";
	print "To configure package with the same options you can run ./$conf_file\n\n";
}
 
# ---------------------------
# set_db
# ---------------------------
sub set_db {
	while () {
		print "Include built-in database support? (Use for small sites) (yes/no) [$builtin]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $builtin)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')) {
			$builtin=$temp;
			last;
		}
	}	
	
	if ($builtin eq 'yes') {
		$db_string='--with-built-in';
		return;
	}
	
	while () {
		print "Try to autodetect databases at known locations? (yes/no) [$auto]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $auto)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')) {
			$auto=$temp;
			last;
		}
	}	
	
	if ($auto eq 'yes') {
		print "\n";
		if ((-f "/usr/local/mysql/include/mysql/mysql.h") ||
		    (-f "/usr/include/mysql/mysql.h") ||
		    (-f "/usr/local/include/mysql/mysql.h") ||
		    (-f "/usr/include/mysql.h") ||
		    (-f "/usr/local/include/mysql.h")) {		    
		    	$db=1;
			print "MySQL server found\n";
		} elsif ((-f "/usr/include/pgsql/libpq-fe.h") ||
		         (-f "/usr/lib/libpq.a") ||
			 (-f "/usr/local/pgsql/include/libpq-fe.h") ||
		         (-f "/usr/local/pgsql/lib/libpq.a") ||
			 (-f "/usr/local/include/libpq-fe.h") ||
		         (-f "/usr/local/lib/libpq.a")) {
			$db=2;
			print "PostgreSQL server found\n";
		} elsif ((-f "/usr/local/Hughes/include/msql.h") ||		
		         (-f "/usr/Hughes/include/msql.h") ||
			 (-f "/usr/local/include/msql.h") ||		
			 (-f "/usr/include/msql.h")) {
			$db=3;
			print "mSQL server found\n";
		} elsif ((-f "/usr/local/include/isql.h") ||
			 (-f "/usr/include/isql.h")) {
			$db=10; 		         
			print "iODBC stuff found\n";
		} elsif ((-f "/usr/local/include/sql.h") ||
			 (-f "/usr/include/sql.h")) {			 
			$db=11;		         			 			
			print "unixODBC stuff found\n";
		} elsif ((-f "/usr/local/include/cli0cli.h") ||
		         (-f "/usr/include/cli0cli.h")) {
			$db=4; 
			print "Solid server found\n";
		} elsif ((-f "/usr/local/virtuoso-ent/odbcsdk/include/isql.h") ||
			 (-f "/usr/virtuoso-ent/odbcsdk/include/isql.h") ||
			 (-f "/usr/local/virtuoso-lite/odbcsdk/include/isql.h") ||
			 (-f "/usr/virtuoso-lite/odbcsdk/include/isql.h") ||
			 (-f "/usr/local/virtuoso/odbcsdk/include/isql.h") ||
			 (-f "/usr/virtuoso/odbcsdk/include/isql.h")) {
			$db=12;
			print "OpenLink stuff found\n";
		} elsif ((-f "/usr/local/easysoft/oob/client/include/sql.h") ||
		         (-f "/usr/easysoft/oob/client/include/sql.h")) {			 
			$db=13;
			print "EasySoft stuff found\n";
		} elsif ((-f "/usr/sapdb/incl/sql.h") ||
			 (-f "/usr/local/sapdb/incl/sql.h")) {
			$db=5;
			print "SAPDB server found\n";
		} elsif ((-f "/usr/interbase/include/ibase.h") ||
			 (-f "/usr/local/interbase/include/ibase.h")) {
			$db=6;
			print "Interbase server found\n";
		} elsif (-f "$ENV{ORA_HOME}/rdbms/demo/ocidfn.h") {
			$db=7;
			print "Oracle 7.x server found\n";
		} elsif (-f "/oracle8/app/oracle/product/8.0.5/rdbms/demo/oci.h") {
			$db=8;
			print "Oracle 8.0.x server found\n";
		} elsif (-f "$ENV{ORA_HOME}/rdbms/demo/oci.h") {
			$db=9;
			print "Oracle 8.x server found\n";
		} else {
			$db='';
			print "Sorry, no SQL servers at known location found\n";
		}
	}
	
	while () {
		print "\nWhich database support include?\n";
		
		print "  1 - Include MySQL support.\n";
		print "  2 - Include PostgreSQL support.\n";
		print "  3 - Include mSQL support.\n";
		print "  4 - Include Solid support.\n";		
		print "  5 - Include SAPDB support.\n";
		print "  6 - Include InterBase support.\n";
		print "  7 - Include Oracle 7.3 support.\n";
		print "  8 - Include Oracle 8 support.\n";
		print "  9 - Include Oracle 8i support.\n";
		print " 10 - Include iODBC support.\n";
		print " 11 - Include unixODBC support.\n";
		print " 12 - Include OpenLink ODBC support.\n";
		print " 13 - Include EasySoft ODBC support.\n";		
		
		if ($db eq '') {
			print "\nChoose one from the mentioned: ";
		} else {
			print "\nChoose one from the mentioned ($db):";
		}
		
		$temp=read_in();
		if ($temp eq '') {
			$temp=$db;
		}
		
		if ($temp eq '1') {
			if ($temp eq $db) {
				print "Enter MySQL base install directory [autodetect]: ";
			} else {
				print "Enter MySQL base install directory [/usr/local/mysql]: ";
			}
			
			$temp=read_in();
			if ($temp eq '') { $db_string="--with-mysql"; } 
			else { $db_string="--with-mysql=$temp"; }
			
			last;
		} elsif ($temp eq '2') {
			if ($temp eq $db) {
				print "Enter PostgreSQL base install directory [autodetect]: ";
			} else {			
				print "Enter PostgreSQL base install directory [/usr/local/pgsql]: ";
			}
			
			$temp=read_in();
			if ($temp eq '') { $db_string="--with-pgsql"; } 
			else { $db_string="--with-pgsql=$temp"; }
			
			last;
		} elsif ($temp eq '3') {
			if ($temp eq $db) {
				print "Enter mSQL base install directory [autodetect]: ";
			} else {
				print "Enter mSQL base install directory [/usr/local/Hughes]: ";
			}
			
			$temp=read_in();
			if ($temp eq '') { $db_string="--with-msql"; } 
			else { $db_string="--with-msql=$temp"; }
			
			last;
		} elsif ($temp eq '10') {
			if ($temp eq $db) {
				print "Enter iODBC base install directory [autodetect]: ";
			} else {
				print "Enter iODBC base install directory [/usr/local]: ";
			}
			
			$temp=read_in();
			if ($temp eq '') { $db_string="--with-iodbc"; } 
			else { $db_string="--with-iodbc=$temp"; }
			
			last;
		} elsif ($temp eq '11') {
			if ($temp eq $db) {
				print "Enter unixODBC base install directory [autodetect]: ";
			} else {
				print "Enter unixODBC base install directory [/usr/local]: ";
			}
			
			$temp=read_in();
			if ($temp eq '') { $db_string="--with-unixODBC"; } 
			else { $db_string="--with-unixODBC=$temp"; }
			
			last;
		} elsif ($temp eq '4') {
			if ($temp eq $db) {
				print "Enter Solid base install directory [autodetect]: ";
			} else {
				print "Enter Solid base install directory [/usr/local]: ";
			}
			
			$temp=read_in();
			if ($temp eq '') { $db_string="--with-solid"; } 
			else { $db_string="--with-solid=$temp"; }
			
			last;
		} elsif ($temp eq '12') {
			if ($temp eq $db) {
				print "Enter OpenLink ODBC base install directory [autodetect]: ";
			} else {
				print "Enter OpenLink ODBC base install directory [/usr/local/virtuoso/odbcsdk]: ";
			}
			
			$temp=read_in();
			if ($temp eq '') { $db_string="--with-openlink"; } 
			else { $db_string="--with-openlink=$temp"; }
			
			last;
		} elsif ($temp eq '13') {
			if ($temp eq $db) {
				print "Enter EasySoft ODBC base install directory [autodetect]: ";
			} else {
				print "Enter EasySoft ODBC base install directory [/usr/local/easysoft/oob/client]: ";
			}
			
			$temp=read_in();
			if ($temp eq '') { $db_string="--with-easysoft"; } 
			else { $db_string="--with-easysoft=$temp"; }
			
			last;
		} elsif ($temp eq '5') {
			if ($temp eq $db) {
				print "Enter SAPDB base install directory [autodetect]: ";				
			} else {
				print "Enter SAPDB base install directory [/usr/sapdb]: ";
			}
			
			$temp=read_in();
			if ($temp eq '') { $db_string="--with-sapdb"; } 
			else { $db_string="--with-sapdb=$temp"; }
			
			last;
		} elsif ($temp eq 'ibase') {
			if ($temp eq $db) {
				print "Enter InterBase base install directory [autodetect]: ";
			} else {
				print "Enter InterBase base install directory [/usr/interbase]: ";
			}
			
			$temp=read_in();
			if ($temp eq '') { $db_string="--with-ibase"; } 
			else { $db_string="--with-ibase=$temp"; }
			
			last;
		} elsif ($temp eq '7') {
			print "Enter Oracle home directory [\$ORA_HOME]: ";
			
			$temp=read_in();
			if ($temp eq '') { $db_string="--with-oracle7"; } 
			else { $db_string="--with-oracle7=$temp"; }
			
			last;
		} elsif ($temp eq '8') {
			if ($temp eq $db) {
				print "Enter Oracle home directory [autodetect]: ";
			} else {
				print "Enter Oracle home directory [/oracle8/app/oracle/product/8.0.5]: ";
			}
			
			$temp=read_in();
			if ($temp eq '') { $db_string="--with-oracle8"; } 
			else { $db_string="--with-oracle8=$temp"; }
			
			last;
		} elsif ($temp eq '9') {
			print "Enter Oracle home directory [\$ORA_HOME]: ";
			
			$temp=read_in();
			if ($temp eq '') { $db_string="--with-oracle8i"; } 
			else { $db_string="--with-oracle8i=$temp"; }
			
			last;
		} 
	}	
}

# ---------------------------
# set_syslog
# ---------------------------
sub set_syslog {
	while () {
		print "Use syslog (yes) or stdout/stderr (no)? (yes/no) [$syslog]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $syslog)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')) {
			$syslog=$temp;
			last;
		}
	}
	
	return if ($syslog eq 'no');
	
	print "Syslog facility (valid name from /usr/include/sys/syslog.h) [$syslog_facility]: ";
	$temp=read_in();
	if (($temp eq '') || ($temp eq $syslog_facility)) {
		return;
	} else {
		$syslog_facility=$temp;
		return;
	}
}

# ---------------------------
# set_threads
# ---------------------------
sub set_threads {
	while () {
		print "Enable Linux pthreads? (yes/no) [$linux_threads]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $linux_threads)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')) {
			$linux_threads=$temp;
			last;
		}
	}
	
	return if ($linux_threads eq 'yes');

	while () {
		print "Enable FreeBSD pthreads? (yes/no) [$bsd_threads]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $bsd_threads)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')) {
			$bsd_threads=$temp;
			last;
		}
	}
}

# ---------------------------
# set_other
# ---------------------------
sub set_other {
	while () {
		print "Enable automatic Russian charset guesser? (yes/no) [$guesser]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $guesser)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')) {
			$guesser=$temp;
			last;
		}
	}
	
	while () {
		print "Enable external parsers support? (yes/no) [$parser]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $parser)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')) {
			$parser=$temp;
			last;
		}
	}

	while () {
		print "Enable MP3 tags support? (yes/no) [$mp3]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $mp3)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')) {
			$mp3=$temp;
			last;
		}
	}

	while () {
		print "Enable AliasProg support? (yes/no) [$aliasprog]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $aliasprog)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')) {
			$aliasprog=$temp;
			last;
		}
	}

	while () {
		print "Enable extended NEWS features? (yes/no) [$ext_news]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $ext_news)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')) {
			$ext_news=$temp;
			last;
		}
	}
	
	while () {
		print "Enable OpenSSL support ? (yes/no) [$ssl]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $ssl)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')){
			$ssl=$temp;
			last;
		}
	}
	
	if ($ssl eq 'yes') {
		print "Enter SSL base install directory: [/usr/local/ssl]: ";
		$temp=read_in();
		$ssl_dir=$temp;
	}	
}

# ---------------------------
# set_cache()
# ---------------------------
sub set_cache {	
	while () {
		print "Do you plan to use cache storage mode? (yes/no) [$cache]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $cache)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')){
			$cache=$temp;
			last;
		}
	}
	
	return if ($cache eq 'no');
	
	while () {
		print "Enable fast tag search in cache mode? (yes/no) [$fast_tag]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $fast_tag)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')){
			$fast_tag=$temp;
			last;
		}
	}

	while () {
		print "Enable fast category search in cache mode? (yes/no) [$fast_cat]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $fast_cat)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')){
			$fast_cat=$temp;
			last;
		}
	}

	while () {
		print "Enable fast site search in cache mode? (yes/no) [$fast_site]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $fast_site)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')){
			$fast_site=$temp;
			last;
		}
	}

	while () {
		print "Enable phrase support in cache mode? (yes/no) [$phrase]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $phrase)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')){
			$phrase=$temp;
			last;
		}
	}
}

# ---------------------------
# set_shema()
# ---------------------------
sub set_shema {	
	while () {
		print "Enable exec: and cgi: virtual scheme support? (yes/no) [$cgi]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $cgi)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')){
			$cgi=$temp;
			last;
		}
	}

	while () {
		print "Enable file:/ URL scheme support? (yes/no) [$file]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $file)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')){
			$file=$temp;
			last;
		}
	}
	
	while () {
		print "Enable http:// URL scheme support? (yes/no) [$http]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $http)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')){
			$http=$temp;
			last;
		}
	}

	while () {
		print "Enable ftp:// URL scheme support? (yes/no) [$ftp]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $ftp)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')){
			$ftp=$temp;
			last;
		}
	}

	while () {
		print "Enable htdb:/  virtual URL scheme support? (yes/no) [$htdb]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $htdb)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')){
			$htdb=$temp;
			last;
		}
	}

	while () {
		print "Enable news:// URL schema support? (yes/no) [$news]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $news)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')){
			$news=$temp;
			last;
		}
	}
	

}

# ---------------------------
# set_libs
# ---------------------------
sub set_libs {
	while () {
		print "Build shared libraries? (yes/no) [$build_shared]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $build_shared)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')) {
			$build_shared=$temp;
			last;
		}
	}
	
	while () {
		print "build static libraries? (yes/no) [$build_static]: ";
		$temp=read_in();
		if (($temp eq '') || ($temp eq $build_static)) {
			last;			
		} elsif (($temp eq 'yes') || ($temp eq 'no')) {
			$build_static=$temp;
			last;
		}
	}
}

# ---------------------------
# set_layout
# ---------------------------
sub set_layout {
	print "Setting up directory layout:\n";

	print "Please set installation path [$prefix]: ";
	$temp=read_in();
	$prefix=$temp if ($temp ne '');

	update_dirs($prefix);
	while() {
		print_layout();
		print "\nChange layout ? (yes/no) [no]: ";		
		$temp=read_in();
		print "\n";
		if (($temp eq 'no') || ($temp eq '')) {
			last;
		} elsif ($temp eq 'yes') {
			print "Please set User executables DIR [$bindir]: ";
			$temp=read_in();
			$bindir=$temp if ($temp ne '');
		
			print "System executables DIR [$sbindir]: ";
			$temp=read_in();
			$sbindir=$temp if ($temp ne '');
			
			print "Configuration data DIR [$sysconfdir]: ";
			$temp=read_in();
			$sysconfdir=$temp if ($temp ne '');
		
			print "Modifiable data DIR: [$localstatedir]: ";
			$temp=read_in();
			$localstatedir=$temp if ($temp ne '');
		
			print "Object code libraries DIR [$libdir]:";
			$temp=read_in();
			$libdir=$temp if ($temp ne '');
		
			print "C header files DIR [$includedir]: ";
			$temp=read_in();
			$includedir=$temp if ($temp ne '');
		
			print "Man documentation DIR [$mandir]: ";
			$temp=read_in();
			$mandir=$temp if ($temp ne '');
		} else {
			next;
		}
	}
}

# -------------------------------
# read_in
# -------------------------------
sub read_in {
	my $temp;
	chomp($temp=<STDIN>);
	return lc($temp);
}

# -------------------------------
# update_dirs(prefix)
# -------------------------------
sub update_dirs {
	my $prefix=$_[0];
	
	$bindir="$prefix/bin";
	$sbindir="$prefix/sbin";
	$sysconfdir="$prefix/etc";
	$localstatedir="$prefix/var";
	$libdir="$prefix/lib";
	$includedir="$prefix/include";
	$mandir="$prefix/man";
}


# -------------------------------
# print_layout
# -------------------------------
sub print_layout {
	print "\nConfigured layout:\n";
	print " Installation path: $prefix\n";
	print " User executables DIR: $bindir\n";
	print " System executables DIR: $sbindir\n";
	print " Configuration data DIR: $sysconfdir\n";
	print " Modifiable data DIR: $localstatedir\n";
	print " Object code libraries DIR: $libdir\n";
	print " C header files DIR: $includedir\n";
	print " Man documentation DIR: $mandir\n";
}
