#ifndef _UDM_MUTEX_H
#define _UDM_MUTEX_H

/* MUTEX stuff to lock dangerous places in multi-threaded mode */

extern __INDLIB__ int UdmSetLockProc(UDM_ENV * Conf,void (*proc)(int command,int type));

#define UDM_DO_LOCK(Conf,lock)		if(Conf->LockProc)Conf->LockProc(UDM_LOCK,lock)
#define UDM_DO_UNLOCK(Conf,lock)	if(Conf->LockProc)Conf->LockProc(UDM_UNLOCK,lock)

#if (WIN32||WINNT)
#define UDM_WIN_LOCK(Conf,lock)		if(Conf->LockProc)Conf->LockProc(UDM_LOCK,lock)
#define UDM_WIN_UNLOCK(Conf,lock)	if(Conf->LockProc)Conf->LockProc(UDM_UNLOCK,lock)
#else
#define UDM_WIN_LOCK(Conf,lock)
#define UDM_WIN_UNLOCK(Conf,lock)
#endif

#endif
