      SUBROUTINE MN_GLU(XD,YD,NPT,MMODE,SINEH,SINEL,NCOL,THICK)
C
C------------------------------------------------------------------------------
C     SUBROUTINE TO DRAW GLUON LINES FOR FEYNMAN DIAGRAMS
C------------------------------------------------------------------------------
C
      implicit none
C
#include "mngrn.inc"
#include "mnpij.inc"
C
      REAL XD(*),YD(*)
      integer npt,mmode,ncol
      real sineh,sinel,thick
C
      integer nmmax
      PARAMETER (NMMAX=8)
C
      INTEGER MPNTMX
      PARAMETER (MPNTMX = 500)
      integer  msegm
      parameter (msegm = 20)
C
      REAL XPT(MPNTMX),YPT(MPNTMX)
      integer nmode,i,nn,n,ncycl
      real dist,phi,delx,x0,y0,frac,freq,zykloi
C
      IF(NPT.LE.1) RETURN
C
C     Check if LPDEV <= 1 then no or null device selected so should not
C     draw the text
C
      IF(LPDEV.LE.1) RETURN
C
C     CHECK THAT THE UNIT SIZE IS REASONABLE
C
      IF(SINEH.LT.0.01 .OR. SINEH.GT.50.0) SINEH = 0.2
      IF(SINEL.LT.0.01 .OR. SINEL.GT.50.0) SINEL = 0.2
C
      IF(MMODE.LE.0 .OR. MMODE.GT.NMMAX) THEN
          RETURN
      ENDIF
      IF(MMODE.LE.4) THEN
          NMODE = MMODE
      ELSE
          NMODE = MMODE + 7
      ENDIF
C
      CALL ISPLCI(NCOL)
      CALL ISLWSC(THICK)
      CALL ISLN(NMODE)
C
C     Make sure there is a half integral number of cycles
C
      DO I=1,NPT-1
          DIST  = SQRT((YD(I+1)-YD(I))**2 + (XD(I+1)-XD(I))**2)
          NCYCL = MAX0(1,INT(0.5 + DIST/SINEL))
          NN    = MIN0(NCYCL*msegm,MPNTMX)
          DELX = DIST / FLOAT(NN-1)
          FREQ = TWOPI / (DIST/(FLOAT(NCYCL)+0.5))
          PHI  = ATAN2(YD(I+1)-YD(I),XD(I+1)-XD(I))
          DO N=1,NN
C
C             Draw a circle and add an x translation
C
              FRAC   = DELX * float(N-1)
CICB              zykloi = 9.0*sinel
              zykloi = 0.5*sinel
CICB              X0 = DELX*(N-1) - zykloi/FREQ*(COS(frac*freq)-1.0)
              X0 = DELX*(N-1) - zykloi*(COS(frac*freq)-1.0)
     +         - float(n-1)/float(nn-1) * 2.0 * zykloi
              Y0 = sineh * SIN(frac*freq)
              XPT(N) = XD(I) + X0*COS(PHI) - Y0*SIN(PHI)
              YPT(N) = YD(I) + X0*SIN(PHI) + Y0*COS(PHI)
          ENDDO
          CALL IPL(NN,XPT,YPT)
      ENDDO
C
      RETURN
      END

