      SUBROUTINE MN_BSB(MMODE,IDELIM,IERR)
C
C     MAKE A BACKGROUND SUBTRACTED HISTOGRAM
C     NMODE = 1       make a normal background subtracted plot
C     NMODE = 2       same as 1 but make a signed chi difference
C
#include "mnpar.inc"
#include "mndat.inc"
#include "mnfit.inc"
#include "mninf.inc"
#include "mnfun.inc"
#include "mncmd.inc"
#include "mnlun.inc"
C
      INTEGER JDAF(MFITMX),JDBF(MFITMX)
      INTEGER IDBINF(2)
      REAL ADLOF(2),ADHIF(2)
C
      CHARACTER*80 TEXT
      CHARACTER*80 TITLE
      LOGICAL QERRL,QERRH
      DATA IDBB/0/
C
      IERR = 0
      NMODE = MMODE
C
C     CALCULATE THE BACKGROUND SUBTRACTED FUNCTION
C
      IF(.NOT.QSBACK) THEN
          CALL MN_ERR('MN_BSB','You must first SET BACKGROUND to' //
     +     ' specify the background function(s)')
          IERR = 1
          GOTO 9000
      ENDIF
C
      DO 1000 NH=1,NHFIT
          NDFUN = NDFUN + 1
          JDBF(NH) = -(980 + NDFUN)
          CALL MN_FFL(IBCKF,1,NH,JDAF(NH),JDBF(NH))
          WRITE(TXTMES,'('' Plot'',I7,I4,'':'')')
     1     IDFITA(NH),IDFITB(NH)
          CALL MN_MES(LUNTTO,'ME',TXTMES)
C
C         GET THE SECONDARY ID FOR THE BACKGROUND
C
          IF(QRFILE .OR. IDELIM.EQ.0 .OR.
     1       IDFITA(NH).NE.IDBCKA(NH) .OR.
     +       IDFITB(NH).EQ.IDBCKB(NH) .OR.
     +       IDBCKB(NH).LE.0) THEN
              IDBB = NDIDB + 1
              TEXT = 'Give secondary ID for background' //
     1         ' subtracted histogram (<CR>=   ):'
              WRITE(TEXT(61:63),'(I3)') IDBB
              LENT = LENOCC(TEXT)
              CALL WAITYQ(TEXT(1:LENT+1))
              CALL MN_SEC(IDBB,IDELIM,IERR)
              IF(IERR.NE.0) GOTO 9000
              IDBCKB(NH) = IDBB
          ENDIF
          IDBCKA(NH) = IDFITA(NH)
          WRITE(TXTMES
     1     ,'('' Background subtracted plot will be stored as plot''
     1     ,I7,I4)') IDBCKA(NH),IDBCKB(NH)
          CALL MN_MES(LUNTTO,'M',TXTMES)
          WRITE(TXTMES
     1     ,'('' Background function will be stored as plot       ''
     1     ,I7,I4)') JDAF(NH),JDBF(NH)
          CALL MN_MES(LUNTTO,'ME',TXTMES)
1000  CONTINUE
C
C     FIND OUT WHAT SORT OF SUBTRACTION TO DO
C
      IF(NMODE.LE.0 .OR. NMODE.GT.2) THEN
          NMODE = 1
 4000     CONTINUE
          CALL WAITYQ('Simple subtraction (1) or divide by' //
     1     ' background also (2) (<CR> = 1): ')
          NVAL = INTTYQ(.TRUE.,IDELIM)
          CALL MN_NCK(NVAL,IDELIM,IERR)
          IF(IERR.EQ.2) GOTO 4100
          IF(IERR.NE.0) GOTO 9000
          IF(NVAL.EQ.0 .OR. IABS(NVAL).GT.2) THEN
              WRITE(TXTERR,'(1X,I4,'' is not a valid mode'')')
              CALL MN_ERR('MN_BSB',TXTERR)
              GOTO 9000
          ENDIF
          NMODE = NVAL
 4100     CONTINUE
      ENDIF
C
C     NOW SUBTRACT BACKGROUND
C
      DO 6000 NH=1,NHFIT
C
C         GET THE FUNCTION HISTOGRAM
C
          IDAF = JDAF(NH)
          IDBF = JDBF(NH)
          CALL MN_HGT(IDAF,IDBF,NHF)
          NPTRHF = NPTRH
          NPTRDF = NPTRD
          NDIMF  = NDIM
          NWPPTF = NWPPT
          NPNTF  = NPNT
          CALL UCOPY_i(IDBIN,IDBINF,IABS(NDIMF))
          CALL UCOPY_r(ADLO,ADLOF,IABS(NDIMF))
          CALL UCOPY_r(ADHI,ADHIF,IABS(NDIMF))
          CALL AMNOFF(NDIMF,NWPPTF,NOFFF,NOFFLF,NOFFHF,QERRL,QERRH)
C
C         GET THE DATA HISTOGRAM
C
          IDA = IDFITA(NH)
          IDB = IDFITB(NH)
          NPTRHU = IFPTRH(NH)
          NPTRDU = IFPTRD(NH)
          CALL MN_FGT(IDA,IDB,NHF)
          NDIMU  = NDIM
          NWPPTU = NWPPT
          NPNTU  = NPNT
C
          IF(IABS(NDIM).NE.1) THEN
              CALL MN_ERR('MN_BSB'
     +         ,'Background subtraction only works for 1-d histograms')
              GOTO 9000
          ENDIF
C
C         AMNOFF is not correct for fitted histograms
C
          NOFFU  = IABS(NDIMU) + 1
          NOFFLU = 2*(IABS(NDIMU) + 1)
          NOFFHU = 3*(IABS(NDIMU) + 1)
          QERRL  = NWPPTU.GT.1*(IABS(NDIMU)+1)
          QERRH  = NWPPTU.GT.2*(IABS(NDIMU)+1)
C
          IDAB = IDBCKA(NH)
          IDBB = IDBCKB(NH)
          TITLE = 'Histogram              Background Subtracted'
          WRITE(TITLE(11:22),'(I8,I4)') IDA,IDB
C
C         GET THE STORAGE SPACE FOR THE NEW HISTOGRAM
C
          IF(IABS(NDIMU).EQ.1) THEN
              NDIM2  = NDIMU
              NWPPT2 = NWPPTU
          ELSE
              NDIM2  = 2
              NWPPT2 = 1
              IF(QERRL) NWPPT2 = 2
              IF(QERRH) NWPPT2 = 3
          ENDIF
          CALL AMNOFF(NDIM2,NWPPT2,NOFF2,NOFFL2,NOFFH2,QERRL,QERRH)
C
          NWRD2  = NPNTU*NWPPT2
          NBPPT2 = 32
          NTMOD2 = NTMODE
          CALL MN_HNW(IDAB,IDBB,NDIM2,NWRD2,NH2,NPTRH2,NPTRD2,NWH2
     1     ,NBPPT2,NTMOD2)
          IF(NH2.LE.0) GOTO 9000
C
          CALL AMNOFF(NDIM2,NWPPT2,NOFF2,NOFFL2,NOFFH2,QERRL,QERRH)
C
          IF(NDIMU.EQ.NDIM2 .AND. NWPPTU.EQ.NWPPT2)
     +     CALL UCOPY_r(RFIT(NPTRDU),RDAT(NPTRD2),NPNTU*NWPPTU)
C
          EDENT2 = 0.0
          EDLO2  = 1.0E+30
          EDHI2  = -1.0E+30
          YERRL = 0.0
          YERRH = 0.0
          DO 5500 II=1,NPNT
              NPTR1 = NPTRDU + NWPPTU*(II-1) - 1
              NPTR2 = NPTRD2 + NWPPT2*(II-1) - 1
              NPTRF = NPTRDF + NWPPTF*(II-1) - 1
              YFIT  = RFIT(NPTR1+NOFFU)
              IF(QERRL) YERRL = RFIT(NPTR1+NOFFLU)
              IF(QERRH) YERRH = RFIT(NPTR1+NOFFHU)
              YFUN  = RDAT(NPTRF+NOFFF)
              IF(NMODE.EQ.1) THEN
                  YDAT = YFIT - YFUN
              ELSE
                  IF(YFUN.EQ.0.0) THEN
                      YDAT = 0.0
                      YERRL = 0.0
                      YERRL = 0.0
                  ELSE
                      YDAT = YFIT/YFUN - 1.0
                      IF(QERRL) YERRL = YERRL / YFUN
                      IF(QERRH) YERRH = YERRH / YFUN
                  ENDIF
              ENDIF
              IF(.NOT.QERRH) YERRH = YERRL
              EDENT2 = EDENT2 + YDAT
              EDLO2  = AMIN1(EDLO2,YDAT-YERRL)
              EDHI2  = AMAX1(EDHI2,YDAT+YERRH)
              RDAT(NPTR2+NOFF2) = YDAT
              IF(QERRL) RDAT(NPTR2+NOFFL2) = YERRL
              IF(QERRH) RDAT(NPTR2+NOFFH2) = YERRH
5500      CONTINUE
C
          IF(NDIM2.EQ.1) THEN
              ACONT(2) = EDENT
          ELSEIF(NDIM2.EQ.2) THEN
              ACONT(5) = EDENT
          ENDIF
C
C         FILL IN THE HEADER
C
          NWTOT = NWH2 + NWRD2
          CALL M_RTIM(NHDAT2,NHTIM2)
          NSDAT2 = NSDATE
          NSTIM2 = NSTIME
          CALL MN_HDU(RDAT(NPTRH2),NWTOT,NWH2,NWRD2,IDAB,IDBB
     1     ,NDIM2,NWPPT2,NPNTU,NHDAT2,NHTIM2,NSDAT2,NSTIM2,NTMOD2
     +     ,EDENT2,EDLO2,EDHI2,IDBINF,ADLOF,ADHIF,NBPPT2,ACONT)
          CALL MN_PTU(NH2,NWTOT,IDAB,IDBB,NPTRH2,NPTRD2,TITLE
     1     ,'Generated internally',' ',TFNAM(1,NH))
          CALL MN_MSU(IDAB,IDBB,NDIM2,NWH2,NH2)
 6000 CONTINUE
C
 9000 CONTINUE
      RETURN
      END
