      SUBROUTINE M_FITC(IDELIM,IERR)
C
C-----------------------------------------------------------------------
C
C     Interprets the fit command
C
C     Called by MN_CMI
C
C-----------------------------------------------------------------------
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mnfit.inc"
#include "mninf.inc"
#include "mnfun.inc"
#include "mntyq.inc"
#include "mnlun.inc"
C
      INTEGER IDELIM,IERR
C
      INTEGER IF,NFU,NFUN,LFUN,NVAL,II,I,J,NF
      INTEGER IDA,IDB,NNID,NHD,LENT,LNBLNK
      LOGICAL QASSF
      CHARACTER*10 TCOMM
      INTEGER INTTYQ,IVLTYQ
C
      INTEGER MFTQUL,MFT1,MFT2
      PARAMETER (MFTQUL = 9)
      PARAMETER (MFT1   = 3)
      PARAMETER (MFT2   = 5)
      CHARACTER*10 FITQUL(MFTQUL)
      INTEGER NQUAL,IQUAL(10)
      LOGICAL QUICK_FIT,QGAUSS,QFLAT,QLINE
      INTEGER NFADD,NGAUSS,NFLAT,NLINE
      INTEGER NFUNS,IUSES(MFUNMX),NORD,NPAR
C
      EXTERNAL INTTYQ,IVLTYQ
C
      DATA FITQUL/'CHI','LIKELIHOOD','SLIKELIHOO'
     + ,'FRACTIONS','NORMALIZAT'
     + ,'GAUSS','FLAT','LINE'
     + ,' '/
C
      NHFIT = 0
      NDFUN = 0
C
C     Set the defaults for the qualifiers
C
      QUICK_FIT = .FALSE.
      QGAUSS    = .FALSE.
      QFLAT     = .FALSE.
      QLINE     = .FALSE.
      NGAUSS    = 0
      NFLAT     = 0
      NLINE     = 0
      NFADD     = 0
      NFITTP    = -1
      NPARTP    = 0
C
C     Check for qualifiers
C
      CALL M_QUAL(IDELIM,FITQUL,MFTQUL,IQUAL,NQUAL)
      IF(NQUAL.LT.0) GOTO 9000
      DO I=1,NQUAL
          IF(FITQUL(IQUAL(I)).EQ.'CHI') THEN
              NFITTP = 0
          ELSEIF(FITQUL(IQUAL(I)).EQ.'LIKELIHOOD') THEN
              NFITTP = 1
          ELSEIF(FITQUL(IQUAL(I)).EQ.'SLIKELIHOO') THEN
              NFITTP = 2
              NPARTP = 1
          ELSEIF(FITQUL(IQUAL(I)).EQ.'FRACTION') THEN
              NPARTP = 1
          ELSEIF(FITQUL(IQUAL(I)).EQ.'NORMALIZAT') THEN
              QSNORM = .TRUE.
          ELSEIF(FITQUL(IQUAL(I)).EQ.'GAUSS') THEN
              QUICK_FIT = .TRUE.
              QGAUSS    = .TRUE.
              NGAUSS    = NGAUSS + 1
              NFADD     = NFADD + 1
          ELSEIF(FITQUL(IQUAL(I)).EQ.'FLAT') THEN
              QUICK_FIT = .TRUE.
              QFLAT     = .TRUE.
              NFLAT     = NFLAT + 1
              NFADD     = NFADD + 1
          ELSEIF(FITQUL(IQUAL(I)).EQ.'LINE') THEN
              QUICK_FIT = .TRUE.
              QLINE     = .TRUE.
              NLINE     = NLINE + 1
              NFADD     = NFADD + 1
          ENDIF
      ENDDO
C
C
C     CHECK WE HAVE A FUNCTION TO FIT
C
      IF(.NOT.QUICK_FIT .AND. NFUN_MN.EQ.0) THEN
          TXTERR = 'No function has been selected'
          CALL M_EMSG('M_FITC',TXTERR)
          txterr = 'Use the FUN ADD command to select one'
          CALL MN_ERR('M_FITC',TXTERR)
          GOTO 9000
      ELSEIF(.NOT.QUICK_FIT) THEN
          NFU = 0
          DO IF=1,NFUN_MN
              IF(IUSEF(IF).EQ.1) NFU = NFU + 1
          ENDDO
          IF(NFU.EQ.0) THEN
              WRITE(TXTERR,'('' No function to use.''
     1         ,'' Use the FUN USE command to select one'')')
              CALL MN_ERR('M_FITC',TXTERR)
              GOTO 9000
          ENDIF
      ENDIF
C
      NHFIT = 0
      QASSF = .FALSE.
 1100 CONTINUE
      CALL WAITYQ('Give histogram number(s) to fit: ')
      CALL MN_HNO(IDA,IDB,IDELIM,NNID)
      IF(NNID.LE.0) GOTO 9000
      NHFIT = NHFIT + 1
      IDFITA(NHFIT) = IDA
      IDFITB(NHFIT) = IDB
      CALL VFILL(IASSF(1,NHFIT),MFUNMX,1)
C
C     SEE IF ANY FUNCTIONS ARE SPECIFIED WHICH ARE NOT TO BE USED
C     IN FITTING THE CURRENT PLOT
C     THEY WILL BE GIVEN AS NEGATIVE NUMBERS
C
      IF(IDELIM.EQ.0) THEN
 1200     CONTINUE
          NFUN = INTTYQ(.TRUE.,IDELIM)
          IF(NFUN.GE.0) THEN
              CALL RESTYQ
              GOTO 1100
          ELSE
              LFUN = IABS(NFUN)
              IF(LFUN.LE.NFUN_MN) THEN
                  QASSF = .TRUE.
                  IASSF(LFUN,NHFIT) = 0
              ELSE
                  WRITE(TXTERR,'(''Illegal function''
     1             ,'' number specified'',I4)') NFUN
                  CALL MN_ERR('M_FITC',TXTERR)
                  GOTO 9000
              ENDIF
              IF(IDELIM.EQ.0) GOTO 1200
          ENDIF
      ENDIF
C
C     If we are excluding some functions from the fit then we are
C     only allowed to fit 2 histograms at most
C
      IF(NHFIT.GT.2 .AND. QASSF .AND. QRATIO) THEN
          CALL MN_ERR('MN_CMI','You can fit a maximum of ' //
     +     '2 plots with different functions')
          GOTO 9000
      ENDIF
C
C     If doing a quick fit, save the functions in use and add the new one
C
      IF(QUICK_FIT) THEN
          NFUNS = NFUN_MN
          CALL UCOPY_i(IUSEF,IUSES,MFUNMX)
C
          IF(NFUN_MN.GE.MFUNMX) THEN
              WRITE(TXTERR,'(''I have no room for a new function.''
     +         ,'' Use the FUNCTION DELETE command to clean up'')')
              CALL MN_ERR('M_FITC',TXTERR)
              GOTO 9000
          ENDIF
C
          IDA = IDFITA(1)
          IDB = IDFITB(1)
          CALL MN_HGT(IDA,IDB,NHD)
          IF(NHD.LE.0) THEN
              WRITE(TXTERR,'(''Histogram'',I7,I4
     1         ,'' does not exist'')') IDA,IDB
              CALL MN_ERR('M_FITC',TXTERR)
              IERR = 1
              GOTO 9000
          ENDIF
          IF(IABS(NDIM).NE.1) THEN
              WRITE(TXTERR
     +         ,'(''Quick fitting only works for 1-D plots'')')
              CALL MN_ERR('M_FITC',TXTERR)
              IERR = 2
              GOTO 9000
          ENDIF
C
C         Turn off all other functions
C
          DO I=1,NFUN_MN
              IUSEF(I) = 0
          ENDDO
C
C         Loop over the functions to add
C
          NF = NFUN_MN
          DO J=1,NFADD
C
C             Add a Gaussian
C
              IF(J.LE.NGAUSS) THEN
                  NFUN = LFGAUSS
                  NPAR = IFPAR(NFUN)
C
C             Add a flat background
C
              ELSEIF(J.LE.NGAUSS+NFLAT) THEN
                  NFUN = LFPOLY
                  NPAR = 1
                  NORD = 0
C
C             Add a straight line
C
              ELSEIF(J.LE.NGAUSS+NFLAT+NLINE) THEN
                  NFUN = LFPOLY
                  NPAR = 3
                  NORD = 1
              ENDIF
C
C             See if I already have a such quick function defined - not in use
C
              DO I=NFUN_MN,1,-1
                  IF(INUMF(I).EQ.NFUN .AND.
     +               IUSEF(I).EQ.0 .AND. NPAR.EQ.IPARF(I)) THEN
                      LENT = LNBLNK(TUSEF(I))
                      IF(TUSEF(I)(LENT-7:LENT).EQ.' - QUICK') THEN
                          NF = I
                          GOTO 2200
                      ENDIF
                  ENDIF
              ENDDO
              NF = NF + 1
C
 2200         CONTINUE
              INUMF(NF)    = NFUN
              IPARF(NF)    = NPAR
              IUSEF(NF)    = 1
              ISIGF(NF)    = 1
              IBCKF(NF)    = 0
              LENT = LNBLNK(TFNNAM(INUMF(NF)))
              TUSEF(NF)    = TFNNAM(INUMF(NF))(:LENT) // ' - QUICK'
              CALL VZERO_r(XFXPAR(1,NF),20)
              IADRF(NF) = 0
              TFILF(NF) = ' '
              TNAMF(NF) = ' '
              DO II=1,IPARF(NF)
                  TPARF(II,NF) = TFPNAM(II,NFUN)
              ENDDO
C
C             Initialize the parameters
C
C             Gaussian
C
              IF(J.LE.NGAUSS) THEN
                  FPAR(1,NF)   = EDENT
                  DFPAR(1,NF)  = SQRT(EDENT)
                  FPAR(2,NF)   = AMEAN(1)
                  DFPAR(2,NF)  = 0.05 * (ADHI(1) - ADLO(1))
                  FPAR(3,NF)   = ASIG(1)
                  DFPAR(3,NF)  = ASIG(1) / AMAX1(1.0,EDENT)
C
C             Flat
C
              ELSEIF(J.LE.NGAUSS+NFLAT) THEN
                  TUSEF(NF) = TFNNAM(INUMF(NF))(:LENT) // ' 0' //
     +             ' - QUICK'
                  FPAR(1,NF)   = 0.1*EDHI
                  DFPAR(1,NF)  = SQRT(0.1*EDHI)
C
C             Straight Line
C
              ELSEIF(J.LE.NGAUSS+NFLAT+NLINE) THEN
                  TUSEF(NF) = TFNNAM(INUMF(NF))(:LENT) // ' 1' //
     +             ' - QUICK'
                  FPAR(1,NF)   = 0.1*EDHI
                  DFPAR(1,NF)  = SQRT(0.1*EDHI)
                  TPARF(2,NF)  = 'SLOPE'
                  FPAR(2,NF)   = 0.0
                  DFPAR(2,NF)  = 0.1*(EDHI-EDLO)/(ADHI(1)-ADLO(1))
                  TPARF(3,NF)  = 'OFFSET'
                  FPAR(3,NF)   = 0.0
                  DFPAR(3,NF)  = 0.0
              ENDIF
C
              DO II=1,IPARF(NF)
                  FPARLO(II,NF) = 0.0
                  FPARHI(II,NF) = 0.0
              ENDDO
C
              NF = MAX0(NF,NFUN_MN)
          ENDDO
C
C         Update the number of functions
C
          NFUN_MN = NF
      ENDIF
C
      IF(NHFIT.GT.1) THEN
          TCOMM = 'histograms'
      ELSE
          TCOMM = 'histogram'
      ENDIF
C
      IF(NFITTP.LT.0) THEN
          WRITE(LUNTTO,'('' Possible fit types are:''
     +     ,/,''  0 - Chi**2''
     +     ,/,''  1 - Likelihood''
     +     ,/,''  2 - Likelihood including function statistics''
     +     ,/,'' 1n - Parameters are fractions + overall normalization''
     +     )')
 3100     CONTINUE
          CALL WAITYQ('Give fit type (0, 1, 10, 11 or 12, <CR>=0): ')
          NVAL = IVLTYQ(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) GOTO 3100
C
          IF(NVAL.EQ.2) THEN
              WRITE(LUNTTO,'('' Fit type 2 implies that''
     +         ,'' parameters are fractions + overall normalization''
     +         ,/,'' Fit type will be set to 12'')')
              NVAL = 12
          ENDIF
C
          NFITTP = MOD(NVAL,10)
          NPARTP = NVAL / 10
      ENDIF
C
C     START UP MINUIT
C
      LENT = LNBLNK(TCOMM)
      IF(NFITTP.EQ.0) THEN
          WRITE(LUNTTO,13000)
     1     'Will do a chi**2 fit to',TCOMM(:LENT)
     2     ,(IDFITA(II),IDFITB(II),II=1,NHFIT)
      ELSEIF(NFITTP.EQ.1) THEN
          WRITE(LUNTTO,13000)
     1     'Will do a likelihood fit to',TCOMM(:LENT)
     2     ,(IDFITA(II),IDFITB(II),II=1,NHFIT)
      ELSEIF(NFITTP.EQ.2) THEN
          WRITE(LUNTTO,13000)
     1     'Will do a likelihood fit including function stats to'
     +     ,TCOMM(:LENT)
     2     ,(IDFITA(II),IDFITB(II),II=1,NHFIT)
      ENDIF
13000 FORMAT(1X,A,1X,A,': ',(4(I7,I4,';')))
      IF(NPARTP.EQ.1) THEN
          WRITE(LUNTTO,'('' An overall normalization will be used''
     +     ,'' and the parameters will be fractions'')')
      ENDIF
C
C     Set the number of commands in the command stack for fitting
C
      IF(QUICK_FIT) THEN
          NFSTKU = NFSTKD
      ELSE
          NFSTKU = 0
      ENDIF
C
      CALL MN_FTI(IERR)
      NHFIT = 0
      NDFUN = 0
C
C     If doing a quick fit reset the functions - and deactivate the new one
C
      IF(QUICK_FIT) THEN
          CALL UCOPY_i(IUSES,IUSEF,NFUNS)
          DO NF=NFUNS+1,NFUN_MN
              IUSEF(NF) = 0
          ENDDO
      ENDIF
C
 9000 CONTINUE
      END
