      DOUBLE PRECISION FUNCTION XMNRD3(Z,EREAL,BSIG)
C
C--------------------------------------------------------
C     This functions is used to evaluate radiative corrections
C     for data taken in electron-positron collisions.
C     RAD1 is a numerical approximation for the radiatively
C     corrected convolution function for an (assumed) gaussian
C     beam energy dispersion.
C     IT IS ASSUMED THAT ALL ENERGIES ARE IN GEV
C-----------------------------------------------------
C
      IMPLICIT DOUBLE PRECISION(A-H,O-Z)
C
C     virtual radiative correction
C
      EPSI = 0.15
      PI=3.14159
      ALPHA=137.036
      XME=.511003
      DNOM=SQRT(2*PI)*BSIG
      ERAT=EREAL*1000./XME
      T=2.*(DLOG(ERAT**2)-1.)/ALPHA/PI
CICB  T=2.*(ALOG(ERAT**2)-1.)/ALPHA/PI
      X=1.+T
C
C     arithmetic gamma function
C
      Y=GAMMA(X)
      GAUSPO=0.
      RAD0=0.
      IF(ABS(Z).LE.12.)THEN
        GAUSPO=EXP(-((Z**2)/2.))
        DENOM1=SQRT(1.+((Z/(1+(1.37*T)))**2))
        ONEP=(0.31-((0.73*Z)/(DENOM1))+(Z**2))**(-T/2.)
        RAD0=(Y/SQRT(2.*PI))*(EXP(-((Z**2)/2.)))*ONEP
      ENDIF
C
C     dimensionless
C
      IF (Z.LT.0.) THEN
        RAD1=RAD0
C
C     add radiative tail
C
      ELSE
        TWOP=(Z**2.18)/(1+(Z**3.18))
        DENOM2=(1.5*T)+2.44+((Z-(46./((Z**2)+21.)))**2)
        THREEP=1.+(((1.-T)*(2.-T)/2.)/DENOM2)
        TAIL=(T*(Z**T))*TWOP*THREEP
        RAD1=RAD0+TAIL
      ENDIF
C
C     put in dimensions
C
      RAD2=((2.*BSIG/EREAL)**T)*RAD1/BSIG
      XMNRD3=(EPSI*GAUSPO/DNOM)+RAD2
      RETURN
      END
