      SUBROUTINE M_DBASE(IDELIM)
C
C------------------------------------------------------------------------------
C     Main routine for sending out database plotting commands
C
C     Arguments to DB routines are:
C     TPATH   is the full directory pathname
C     N1,N2   are the first and last channels to get (0,0 means all)
C     NDBTS   is the starting time (in DB format seconds)
C     NDBTF   is the finishing time (only in history mode)
C     NMODE   0 means divide by standard value
C             1 means do not divide
C            -1 means divide by last value (-2 last but 1, etc. - not yet in!)
C     NDAT    is maximum number of words and returned is actual number
C     ITIME   are the times (in DB format seconds)
C     RBUF    is the data
C------------------------------------------------------------------------------
C
#if ( defined(L3_DB) )
#include "mnpar.inc"
#include "mndat.inc"
#include "mninf.inc"
#include "mnhpj.inc"
#include "mncmd.inc"
#include "mntim.inc"
#include "mnlun.inc"
C
#include "dbcde.inc"
C
      INTEGER MDBS,MDBOH,MDBOS
      PARAMETER (MDBS = 7)
      PARAMETER (MDBOH = 4)
      PARAMETER (MDBOS = 6)
      CHARACTER*10 DBSNAM(MDBS),DBOHST(MDBOH),DBOSNP(MDBOS)
      INTEGER MDBQUL
      PARAMETER (MDBQUL = 5)
      CHARACTER DBSQUL(MDBQUL)*10
C
C     Working space
C
#include "mnscr.inc"
      PARAMETER (MPNTMX = 10000)
      INTEGER ITIME(MPNTMX)
      REAL RBUF(MPNTMX)
*      EQUIVALENCE(SCRATCH(1), ITIME)
*      EQUIVALENCE(SCRATCH(1), RBUF)
C
      CHARACTER*32 TNAME(2)
      CHARACTER*80 TPATH,TITLE,TFILE,TEXT
      CHARACTER*13 TSTART,TSTOP
      CHARACTER*10 TN1,TN2
      CHARACTER*1 TTIME
      CHARACTER*1 CHOPT
      REAL EX(3)
      INTEGER IDTREF,ITMREF,IDBREF,IDTSCL,ITMSCL,IDBSCL,LN1,LN2,IVRSN
      LOGICAL QRNGE,QCLEAR,QPLOT,QPEDS
      INTEGER NQUAL,IQUAL(10)
C
C     ECAL number of phi crystals per theta sector
C
      integer ipht(41)
C
      DATA DBSQUL/
     + 'PLOT', 'NOPLOT', 'PEDESTAL', 'NOPEDESTAL', ' '/
      DATA DBSNAM/
     + 'DB_HISTORY', 'DB_SNAP', 'DBN_HISTORY', 'DBN_SNAP'
     + ,'DBP_HISTORY', 'DBP_SNAP', ' '/
      DATA DBOHST/
     + 'SCALED', 'UNSCALED', 'CURRENT', ' '/
      DATA DBOSNP/
     + 'SCALED', 'UNSCALED', 'PREVIOUS', 'DIFFERENCE', 'RDIFFERENCE',
     + ' '/
C
      data ipht/160,160,160,160,160,160,160,160,
     + 160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,160,
     + 128,128,128,112,112,112,96,96,96,80,80,80,64,64,64,48,48/
#endif

C
#if ( !defined(L3_DB) )
      CALL MN_ERR('MN_CMD','Command only valid in L3 environment')
C
#endif
#if ( defined(L3_DB) )
C
      TTIME = TIMNAM(NMTIME)(1:1)
C
      IF(COMND1.EQ.'DB_HISTORY' .OR. COMND1.EQ.'DB_SNAP') THEN
          CALL RESTYQ
      ENDIF
C
1000  CONTINUE
      CALL WAITYQ('Give command or ?: ')
      JCMD = ICMTYQ(.TRUE.,IDELIM,DBSNAM)
      COMND2 = ' '
      IF(JCMD.GT.0) COMND2 = DBSNAM(JCMD)
      IF(JCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
          CALL QUOTYQ('DATABASE ' // COMND2)
          IDELIM = 0
          CALL MN_HLP(IDELIM,IERR)
          GOTO 1000
      ELSEIF(JCMD.LT.0) THEN
          GOTO 9000
      ENDIF
      CALL MN_DCK(IDELIM,JCMD,MDBS,DBSNAM,IERR)
      IF(IERR.EQ.2) CALL MN_UNK('M_DBASE')
      IF(IERR.NE.0) GOTO 9000
C
C     Set default values for any qualifiers and check for qualifiers
C
      QPLOT = .TRUE.
      QPEDS = .FALSE.
      IF(COMND2(1:3).EQ.'DBN') QPLOT = .FALSE.
      IF(COMND2(1:3).EQ.'DBP') QPEDS = .TRUE.
C
      CALL M_QUAL(IDELIM,DBSQUL,MDBQUL,IQUAL,NQUAL)
      IF(NQUAL.LT.0) GOTO 9000
      DO I=1,NQUAL
          IF(IQUAL(I).EQ.1) THEN
              QPLOT = .TRUE.
          ELSEIF(IQUAL(I).EQ.2) THEN
              QPLOT = .FALSE.
          ELSEIF(IQUAL(I).EQ.3) THEN
              QPEDS = .TRUE.
          ELSEIF(IQUAL(I).EQ.4) THEN
              QPEDS = .FALSE.
          ENDIF
      ENDDO
C
C     Get the pathname
C
      CALL WAITYQ('Give full directory pathname: ')
      NPATH = ISTTYP(.TRUE.,IDELIM,TPATH)
      IF(NPATH.LE.0) GOTO 9000
      IF(TPATH(1:2).NE.'//' .OR. NPATH.LT.8) THEN
          CALL MN_ERR('M_DBASE','Error in directory name: ' //
     +     TPATH(1:NPATH))
          GOTO 9000
      ENDIF
C
C     Open the database if needed
C
      CALL M_DBOPEN(TPATH(3:6),IERR)
      IF(IERR.NE.0) GOTO 9000
C
C     Get the first and last channel numbers
C
      CALL WAITYQ(
     + 'Give the first and last channel numbers (0 for all): ')
      N1 = IVLTYQ(.TRUE.,IDELIM)
      CALL MN_NCK(N1,IDELIM,IERR)
      IF(IERR.NE.0) GOTO 9000
      CALL WAITYQ('Give last channel number (<CR> = 1st channel): ')
      N2 = IVLTYQ(.TRUE.,IDELIM)
      CALL MN_NCK(N2,IDELIM,IERR)
      IF(IERR.EQ.2) THEN
          N2 = N1
      ELSEIF(IERR.NE.0) THEN
          GOTO 9000
      ENDIF
C
      IF(N2.LT.N1) THEN
          WRITE(TXTERR,'(''Error in the channel numbers '',I6
     +     ,'' ->'',I6)',IOSTAT=IOERR) N1,N2
          CALL MN_ERR('M_DBASE',TXTERR)
          GOTO 9000
      ENDIF
C
C     Get the time (or times)
C     Use dot delimiter to see if time is given
C
      NLOOP = 0
2000  CONTINUE
      NLOOP = NLOOP + 1
      IF(INDEX(COMND2,'HISTORY').GT.0) THEN
          IF(NLOOP.EQ.1) THEN
              CALL WAITYQ('Give the starting time (yYYMMDD.HHMMSS): ')
          ELSE
              CALL WAITYQ('Give the finishing time (yYYMMDD.HHMMSS): ')
          ENDIF
      ELSE
          CALL WAITYQ('Give the time (yYYMMDD.HHMMSS): ')
      ENDIF
      NDATE = INTTYQ(.TRUE.,IDELIM)
      if(ndate.ne.0 .and. ndate/10000.lt.80) ndate = ndate + 1000000
      IF(IDELIM.EQ.ICHAR('.')) THEN
          NTIME = INTTYQ(.TRUE.,IDELIM)
      ELSE
          NTIME = 0
      ENDIF
C
C     Set up default limits
C
      IF(NDATE.EQ.0 .AND. NTIME.EQ.0) THEN
          IF(INDEX(COMND2,'HISTORY').GT.0) THEN
              CALL DATIME(NDATE,NTIME)
              if(ndate.ne.0 .and. ndate/10000.lt.80)
     +         ndate = ndate + 1000000
              NTIME = NTIME*100
              write(txtmes,'('' Requesting history for''
     +         ,i8.7,''/'',i6.6)') ndate,ntime
              call mn_mes(luntto,'ME',txtmes)
          ELSE
              CALL DATIME(NDATE,NTIME)
              if(ndate.ne.0 .and. ndate/10000.lt.80)
     +         ndate = ndate + 1000000
              NTIME = NTIME*100
              write(txtmes,'('' Requesting snapshot for''
     +         ,i8.7,''/'',i6.6)') ndate,ntime
              call mn_mes(luntto,'ME',txtmes)
          ENDIF
      ENDIF
C
C     Negative finishing date means subtract it from the start time and
C     then flip start and stop time. This only works for days!
C
      if(nloop.eq.2 .and. ndate.lt.0 .and. ntime.eq.0) then
          call m_dbdsub(ndats,iabs(ndate),ndate,ierr)
          if(ierr.ne.0) goto 9000
          ntime = ntims - ntime
      endif
C
*ICB      IF(NDATE.LT.800101 .OR. NDATE.GT.991231) THEN
      IF(NDATE.LT.800101 .OR. NDATE.GT.1991231) THEN
          WRITE(TXTERR,'(''Date is out of range: '',I8)'
     +     ,IOSTAT=IOERR) NDATE
          CALL MN_ERR('M_DBASE',TXTERR)
          GOTO 9000
      ENDIF
      IF(NTIME.LT.0 .OR. NTIME.GT.240000) THEN
          WRITE(TXTERR,'(''Time is out of range: '',I8)'
     +     ,IOSTAT=IOERR) NTIME
          CALL MN_ERR('M_DBASE',TXTERR)
          GOTO 9000
      ENDIF
C
      IF(NLOOP.EQ.1) THEN
          NDATS = NDATE
          NTIMS = NTIME
          CALL DBPKTS(NDATS,NTIMS,NDBTS)
      ELSE
          if(ndate.lt.ndats) then
              ndatf = ndats
              ntimf = ntims
              ndbtf = ndbts
              NDATs = NDATE
              NTIMs = NTIME
              CALL DBPKTS(NDATs,NTIMs,NDBTs)
          else
              NDATf = NDATE
              NTIMf = NTIME
              CALL DBPKTS(NDATf,NTIMf,NDBTf)
          endif
      ENDIF
      IF(INDEX(COMND2,'HISTORY').GT.0 .AND.
     +   NLOOP.EQ.1) GOTO 2000
C
      IF(INDEX(COMND2,'HISTORY').GT.0) THEN
          NMDEF = 1
      ELSE
          NMDEF = 1
      ENDIF
2500  CONTINUE
      IF(INDEX(COMND2,'HISTORY').GT.0) THEN
          CALL WAITYQ('Give option (S,U or C, <CR> = U): ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,DBOHST)
      ELSE
          CALL WAITYQ('Give option (S,U P,D or RD <CR> = U): ')
          KCMD = ICMTYQ(.TRUE.,IDELIM,DBOSNP)
      ENDIF
      IF(KCMD.LT.0 .AND. IDELIM.EQ.ICHAR('?')) THEN
          CALL QUOTYQ('DATABASE ' // COMND2)
          IDELIM = 0
          CALL MN_HLP(IDELIM,IERR)
          GOTO 2500
      ELSEIF(KCMD.LE.0) THEN
          IF(KCMD.EQ.0) THEN
              CALL M_EMSG('M_DBASE'
     +         ,'Unknown or ambiguous option - default taken')
          ENDIF
          NMODE = NMDEF
      ELSEIF(KCMD.EQ.1) THEN
          NMODE = 10
      ELSEIF(KCMD.EQ.2) THEN
          NMODE = 1
      ELSEIF(KCMD.EQ.3) THEN
          NMODE = -1
      ELSEIF(KCMD.EQ.4) THEN
          NMODE = -2
      ELSEIF(KCMD.EQ.5) THEN
          NMODE = 11
      ENDIF
C
C     Get the reference time to scale by
C
      IF(NMODE.EQ.10 .OR. NMODE.EQ.11) THEN
          CALL WAITYQ('Give time to scale by (YYMMDD.HHMMSS): ')
          NDATE = INTTYQ(.TRUE.,IDELIM)
          IF(IDELIM.EQ.ICHAR('.')) THEN
              NTIME = INTTYQ(.TRUE.,IDELIM)
          ELSE
              NTIME = 0
          ENDIF
C
C         Set up default limits
C
          IF(NDATE.EQ.0 .AND. NTIME.EQ.0) THEN
              IDTSCL = 0
              ITMSCL = 0
              IDBSCL = 0
*ICB          ELSEIF(NDATE.LT.800101 .OR. NDATE.GT.991231) THEN
          ELSEIF(NDATE.LT.800101 .OR. NDATE.GT.1991231) THEN
              WRITE(TXTERR,'(''Date is out of range: '',I8)'
     +         ,IOSTAT=IOERR) NDATE
              CALL MN_ERR('M_DBASE',TXTERR)
              GOTO 9000
          ELSEIF(NTIME.LT.0 .OR. NTIME.GT.240000) THEN
              WRITE(TXTERR,'(''Time is out of range: '',I8)'
     +         ,IOSTAT=IOERR) NTIME
              CALL MN_ERR('M_DBASE',TXTERR)
              GOTO 9000
          ELSE
              IDTSCL = NDATE
              ITMSCL = NTIME
              CALL DBPKTS(NDATE,NTIME,IDBSCL)
          ENDIF
      ENDIF
C
C     Get the version number for DBFL
C
      IVRSN = 0
      IF(TPATH(3:6).EQ.'DBFL' .AND. IDELIM.EQ.0) THEN
          CALL WAITYQ('Give version number to get: ')
          IVRSN = IVLTYQ(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) IVRSN = 0
C
C     Get the detector part for DBEC
C
      ELSEIF(TPATH(3:6).EQ.'DBEC') THEN
          IF(IDELIM.LT.0) THEN
              CALL MN_MES(LUNTTO,'M'
     +         ,' Valid Detector parts are 100*k + 10*j + i')
              CALL MN_MES(LUNTTO,'M'
     +         ,' k =  0   Pedestals')
              CALL MN_MES(LUNTTO,'M'
     +         ,' k =  1   Widths')
              CALL MN_MES(LUNTTO,'M'
     +         ,' j =  1   Low Energy')
              CALL MN_MES(LUNTTO,'M'
     +         ,' j =  2   High Energy')
              CALL MN_MES(LUNTTO,'M'
     +         ,' i = -1   -Z Barrel + Endcap')
              CALL MN_MES(LUNTTO,'M'
     +         ,' i = -2   +Z Barrel + Endcap')
              CALL MN_MES(LUNTTO,'M'
     +         ,' i =  0   All')
              CALL MN_MES(LUNTTO,'M'
     +         ,' i =  1   -Z Barrel')
              CALL MN_MES(LUNTTO,'M'
     +         ,' i =  2   +Z Barrel')
              CALL MN_MES(LUNTTO,'M'
     +         ,' i =  3   -Z Endcap')
              CALL MN_MES(LUNTTO,'M'
     +         ,' i =  4   +Z Endcap')
              CALL MN_MES(LUNTTO,'ME',' ')
          ENDIF
          CALL WAITYQ('Give detector (e.g. -11 for -Z, Low Energy): ')
          IVRSN = IVLTYQ(.TRUE.,IDELIM)
          IF(IDELIM.GT.0) IVRSN = 0
      ENDIF
C
      IF(QPEDS) THEN
          CHOPT = 'P'
      ELSE
          CHOPT = ' '
      ENDIF
C
      NDAT = MPNTMX
C
C     History of one or more channels requested
C
      IF(INDEX(COMND2,'HISTORY').GT.0) THEN
          CALL DB_HIST(LUNDB,TPATH(1:NPATH),N1,N2,NDBTS,NDBTF,IDBSCL
     +     ,NMODE,NDAT,ITIME,RBUF,IVRSN,ALIMDB,CHOPT)
C
          IF(NDAT.EQ.0) THEN
              CALL MN_ERR('M_DBASE','Database directory ' //
     +         TPATH(1:NPATH) // ' does not exist')
              GOTO 9000
          ELSEIF(NDAT.LT.0) THEN
              CALL MN_ERR('M_DBASE','Error getting the requested data')
              GOTO 9000
          ENDIF
          CALL DBUPTS(NDAT1,NTIM1,ITIME(1))
          CALL DBUPTS(NDAT2,NTIM2,ITIME(NDAT))
C
C         Define the reference time
C
          IF(NDTREF.EQ.0 .AND. NTMREF.EQ.0) THEN
              IDTREF = NDAT1
              ITMREF = NTIM1
              IDBREF = ITIME(1)
          ELSE
              IDTREF = NDTREF
              ITMREF = NTMREF
              CALL M_PKTS(IDTREF,ITMREF,IDBREF)
          ENDIF
C
C         Book a new histogram for the data
C
          WRITE(TSTART,'(I6.6,''/'',I6.6)',IOSTAT=IOERR) NDAT1,NTIM1
          WRITE(TSTOP,'(I6.6,''/'',I6.6)',IOSTAT=IOERR) NDAT2,NTIM2
          WRITE(TN1,'(I5)',IOSTAT=IOERR) N1
          WRITE(TN2,'(I5)',IOSTAT=IOERR) N2
          TFILE = 'From database ' // TPATH(1:NPATH)
          IF(N1.EQ.N2) THEN
              IF(TPATH(3:6).EQ.'DBEC') THEN
                  TITLE = 'Box' // TN1(1:5) //
     +             ' from ' // TSTART // ' to ' // TSTOP
              ELSE
                  TITLE = 'Chan' // TN1(1:5) //
     +             ' from ' // TSTART // ' to ' // TSTOP
              ENDIF
          ELSE
              TITLE = 'Chan' // TN1(1:5) // ' ->' // TN2(1:5) //
     +         ' from ' // TSTART // ' to ' // TSTOP
          ENDIF
          IDA   = 98766
          IDB   = NDIDB
          NDIM  = -1
          NWPPT = 2
          NBPPT = 0
          NPNT  = NDAT
          NWRD  = NWPPT * NPNT
C
          TNAME(1) = TIMNAM(NMTIME)
          IDBIN(1) = 0
          DELTIM   = DB_TDIF(IDBREF,ITIME(NDAT),TTIME)
          ADLO(1)  = -0.1*DELTIM
          ADHI(1)  =  1.1*DELTIM
C
          NSDATE = IDTREF
          NSTIME = ITMREF
          NTMODE = NMTIME
C
          CALL MN_HNW(IDA,IDB,NDIM,NWRD,NH,NPTRH,NPTRD,NWH,NBPPT,NTMODE)
          IF(NH.LE.0) GOTO 9000
C
C         Loop over the data and put in the histogram
C
          EDLO = +1.0E+31
          EDHI = -1.0E+31
          EDENT = 0.0
          NPTR = NPTRD - NWPPT
          DO 3100 I=1,NPNT
              NPTR = NPTR + NWPPT
              RDAT(NPTR)   = DB_TDIF(IDBREF,ITIME(I),TTIME)
              RDAT(NPTR+1) = RBUF(I)
              EDLO = AMIN1(EDLO,RBUF(I))
              EDHI = AMAX1(EDHI,RBUF(I))
              EDENT = EDENT +  RBUF(I)
3100      CONTINUE
C
          NWTOT = NWH + NWRD
          CALL M_RTIM(NHDATE,NHTIME)
          CALL MN_HDU(RDAT(NPTRH),NWTOT,NWH,NWRD,IDA,IDB,NDIM,NWPPT,NPNT
     +     ,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     +     ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,ACONT)
          CALL MN_PTU(NH,NWTOT,IDA,IDB,NPTRH,NPTRD,TITLE
     +     ,TFILE,' ',TNAME)
          CALL MN_MSU(IDA,IDB,NDIM,NWH,NH)
C
          IF(NSYMS.EQ.1) THEN
              NSYM = -11
          ELSE
              NSYM = NSYMS
          ENDIF
          NHAT = 0
          NPAT = 0
C
C     Current value of one or more channels requested
C
      ELSEIF(INDEX(COMND2,'SNAP').GT.0) THEN
          ITIME(2) = IDBSCL
          CALL DB_SNAP(LUNDB,TPATH(1:NPATH),N1,N2,NDBTS,NMODE
     +     ,NDAT,ITIME,RBUF,IVRSN,CHOPT)
          IF(N1.EQ.0 .AND. N2.EQ.0) THEN
              N1 = 1
              N2 = NDAT
          ENDIF
C
          IF(NDAT.EQ.0) THEN
              CALL MN_ERR('M_DBASE','Database directory ' //
     +         TPATH(1:NPATH) // ' does not exist')
              GOTO 9000
          ELSEIF(NDAT.LT.0) THEN
              CALL MN_ERR('M_DBASE','Error getting the requested data')
              GOTO 9000
          ENDIF
          CALL DBUPTS(NDATF,NTIMF,ITIME(1))
C
C         Book a new histogram for the data
C
          TFILE = 'From database ' // TPATH(1:NPATH)
          WRITE(TSTOP,'(I6.6,''/'',I6.6)',IOSTAT=IOERR) NDATF,NTIMF
          LN1 = LENOCC(TSTOP)
          IF(NMODE.EQ.1) THEN
              TITLE = 'Snapshot from ' // TSTOP
          ELSE
              IDBSCL = ITIME(2)
              CALL DBUPTS(IDTSCL,ITMSCL,IDBSCL)
              WRITE(TEXT,'('' (Ref '',I6.6,1X,I6.6,'')'')')IDTSCL,ITMSCL
              LN2 = LENOCC(TEXT)
              TITLE = 'Snapshot from ' // TSTOP(1:LN1) // TEXT(1:LN2)
          ENDIF
          IDA   = 98767
          IDB   = NDIDB
          NPNT  = NDAT
C
C       For ECAL set the number of dimensions to 2 if this is a snap
C
          IF(TPATH(3:6).EQ.'DBEC') THEN
              NDIM = 2
              TNAME(1) = 'Phi'
              TNAME(2) = 'Theta'
c              IF(IVRSN.EQ.1 .OR. IVRSN.EQ.2) THEN
                  IDBIN(1) = 160
                  ADLO(1)  =   0.0
                  ADHI(1)  = 160.0
                  IDBIN(2) =  41
                  ADLO(2)  =   0.0
                  ADHI(2)  =  41.0
                  NPNT = IDBIN(1)*IDBIN(2)
c              ELSE
c              ENDIF
          ELSE
              NDIM  = 1
              TNAME(1) = 'X'
              IDBIN(1) = NPNT
              ADLO(1)  = FLOAT(N1-1)
              ADHI(1)  = FLOAT(N2)
          ENDIF
          NWPPT = 1
          NBPPT = 0
          NWRD  = NWPPT * NPNT
C
          NSDATE = 0
          NSTIME = 0
          NTMODE = 0
C
          CALL MN_HNW(IDA,IDB,NDIM,NWRD,NH,NPTRH,NPTRD,NWH,NBPPT,NTMODE)
          IF(NH.LE.0) GOTO 9000
C
          CALL VZERO_r(RDAT(NPTRD),NWRD)
          IF(TPATH(3:6).EQ.'DBEC') THEN
              IF(MOD(IVRSN,10).EQ.1 .OR. MOD(IVRSN,10).EQ.2) THEN
                  CALL UCOPY_r(RBUF,RDAT(NPTRD),NDAT)
              ELSEIF(MOD(IVRSN,10).EQ.-1 .OR. MOD(IVRSN,10).EQ.-2) THEN
                  N1 = 160*24
                  CALL UCOPY_r(RBUF,RDAT(NPTRD),N1)
                  NPTRI = N1 + 1
                  NPTRO = NPTRD + N1
                  DO NTHE=25,41
                      NCOP = IPHT(NTHE)
                      CALL UCOPY_r(RBUF(NPTRI),RDAT(NPTRO),NCOP)
                      NPTRI = NPTRI + NCOP
                      NPTRO = NPTRO + 160
                  ENDDO
              ELSEIF(MOD(IVRSN,10).EQ.3 .OR. MOD(IVRSN,10).EQ.4) THEN
                  N1 = 160*24
                  NPTRI = 1
                  NPTRO = NPTRD + N1
                  DO NTHE=25,41
                      NCOP = IPHT(NTHE)
                      CALL UCOPY_r(RBUF(NPTRI),RDAT(NPTRO),NCOP)
                      NPTRI = NPTRI + NCOP
                      NPTRO = NPTRO + 160
                  ENDDO
              ENDIF
          ELSE
              CALL UCOPY_r(RBUF,RDAT(NPTRD),NDAT)
          ENDIF
C
          EX(1) = 1.0E+31
          EX(2) = -1.0E+31
          EX(3) = 0.0
          CALL VEXCUM(RBUF,EX,NPNT)
          EDLO  = EX(1)
          EDHI  = EX(2)
          EDENT = EX(3)
C
          NWTOT = NWH + NWRD
          CALL M_RTIM(NHDATE,NHTIME)
          CALL MN_HDU(RDAT(NPTRH),NWTOT,NWH,NWRD,IDA,IDB,NDIM,NWPPT,NPNT
     +     ,NHDATE,NHTIME,NSDATE,NSTIME,NTMODE
     +     ,EDENT,EDLO,EDHI,IDBIN,ADLO,ADHI,NBPPT,ACONT)
          CALL MN_PTU(NH,NWTOT,IDA,IDB,NPTRH,NPTRD,TITLE
     +     ,TFILE,' ',TNAME)
          CALL MN_MSU(IDA,IDB,NDIM,NWH,NH)
C
          NSYM = NSYMS
          NHAT = NHATS
          NPAT = NPATS
      ENDIF
C
C     Draw the plot
C
      IF(QPLOT) THEN
          QRNGE  = .FALSE.
          QCLEAR = .TRUE.
          CALL M_NPLT(QRNGE,QCLEAR,IERR)
          IF(IERR.NE.0) GOTO 9000
          CALL MN_ZER(NHPLT,IDELIM)
C
          IPLTIA(NHPLT) = IDA
          IPLTIB(NHPLT) = IDB
          IPLTSY(NHPLT) = NSYM
          IPLTHA(NHPLT) = NHAT
          IPLTPA(NHPLT) = NPAT
          IPLTCO(1,NHPLT) = ICOLS(7)
          IPLTCO(2,NHPLT) = ICOLS(8)
          IPLTCO(3,NHPLT) = ICOLS(9)
          IPLTFL(NHPLT) = 1
          IPLTCL(NHPLT) = 1
          IPLTLG(NHPLT) = 0
C
          NFLAG = 0
          QLEGO = .FALSE.
          QDFUN = .FALSE.
          CALL MN_DRW(NFLAG,NDERR)
      ENDIF
#endif

C
9000  CONTINUE
      END
