      SUBROUTINE MN_TXT(XX,YY,TXTI,SIZE,ANG,IOPT,NFONTI,NCOL,THICK)
C
C     ROUTINE FOR PRINTING A CHARACTER STRING
C     SIZES ARE IN CM
C     ANGLES ARE IN DEGREES
C     OPTION CAN BE -1  LEFT ADJUSTED
C                    0  CENTRED
C                    1  RIGHT ADJUSTED
C
      IMPLICIT NONE
C
#include "mnpar.inc"
#include "mngrn.inc"
#include "mnhpj.inc"
#include "mnlun.inc"
C
      REAL XX,YY,SIZE,ANG,THICK
      CHARACTER*(*) TXTI
      INTEGER IOPT,NFONTI,NCOL
C
      INTEGER NFONT,NPREC,LENI,LEN1,LENOCC,IOERR
      CHARACTER*1 TOPT(-1:1)
      CHARACTER*80 TXT1,TXT2
      REAL ANGLE,APASS,CSHI
C
      EXTERNAL LENOCC
C
      DATA TOPT/'L','C','R'/
      DATA CSHI/0.015/
C
      LENI = LENOCC(TXTI)
      IF(LENI.LE.0) GOTO 9000
      IF(LENI.GT.80) THEN
          WRITE(LUNTTO,'('' *** MN_TXT: Text string too long:'',I4
     +     ,/,1X,A)',IOSTAT=IOERR) LENI,TXTI(1:79)
          LENI = 80
      ENDIF
C
      IF(IOPT.LT.-1 .OR. IOPT.GT.1) THEN
          WRITE(LUNTTO,'('' *** MN_TXT: Illegal option'',I4)') IOPT
          GOTO 9000
      ENDIF
C
C     Check if LPDEV <= 1 then no or null device selected so should not
C     draw the text
C
      IF(LPDEV.LE.1) RETURN
C
C     Set the rotation angle
C
      ANGLE = ANG
      TXT1 = TXTI(1:LENI)
C
C     IGTEXT or Postscript font through IGTEXT
C
      IF(NFONTI.LE.0 .OR. MOD(NFONTI,100).EQ.0) THEN
          NPREC = IABS(NFONTI)/1000
          NFONT = ISIGN(MOD(IABS(NFONTI),1000),NFONTI)
C
          CALL MN_SPC(TXT1,TXT2,NFONT)
C
          TXT1 = TXT2
          LEN1 = LENOCC(TXT1)
          IF(LEN1.LE.0) GOTO 9000
C
          CALL ISTXFP(NFONT,NPREC)
          CALL ISTXCI(NCOL)
          IF(MOD(NFONTI,100).EQ.0) THEN
              APASS = AMAX1(1.0,THICK)
              CALL ISLWSC(THICK)
              CALL IGSET('PASS',APASS)
              CALL IGSET('CSHI',CSHI)
              CALL IGTEXT(XX,YY,TXT1,SIZE,ANGLE,TOPT(IOPT))
              CALL ISLWSC(ATHKU(1))
          ELSE
              CALL TVTEXT(XX,YY,TXT1,LEN1,SIZE,ANGLE,IOPT,NFONTI
     1         ,NCOL,THICK)
          ENDIF
      ELSE
C
          LEN1 = LENOCC(TXT1)
          IF(TXT1(LEN1:LEN1).EQ.'$') LEN1 = LEN1 - 1
          IF(LEN1.LE.0) GOTO 9000
          CALL TVTEXT(XX,YY,TXT1,LEN1,SIZE,ANGLE,IOPT,NFONTI
     1     ,NCOL,THICK)
      ENDIF
C
9000  CONTINUE
      RETURN
      END
